/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import opendap.dap.BaseType;
import opendap.dap.DAPNode;
import opendap.servers.SDArray;
import opendap.servers.ServerDDS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.opendap.HasNetcdfVariable;
import thredds.server.opendap.NcSDArray;
import thredds.server.opendap.NcSDByte;
import thredds.server.opendap.NcSDCharArray;
import thredds.server.opendap.NcSDFloat32;
import thredds.server.opendap.NcSDFloat64;
import thredds.server.opendap.NcSDGrid;
import thredds.server.opendap.NcSDInt16;
import thredds.server.opendap.NcSDInt32;
import thredds.server.opendap.NcSDString;
import thredds.server.opendap.NcSDStructure;
import thredds.server.opendap.NcSDUInt16;
import thredds.server.opendap.NcSDUInt32;
import ucar.ma2.DataType;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;

public class NcDDS
extends ServerDDS {
    private static Logger log = LoggerFactory.getLogger(NcDDS.class);
    private Hashtable<String, Variable> coordvars = new Hashtable(50);
    private Vector<Variable> ddsvars = new Vector(50);
    private Hashtable<String, Variable> gridarrays = new Hashtable(50);
    private Hashtable<String, Variable> used = new Hashtable(50);

    private Variable findvariable(String name) {
        for (Variable v : this.ddsvars) {
            if (!v.getFullName().equals(name)) continue;
            return v;
        }
        return null;
    }

    public NcDDS(String name, NetcdfFile ncfile) {
        super(name);
        Iterator<Object> i$ = ncfile.getVariables().iterator();
        while (i$.hasNext()) {
            Variable o;
            Variable v = o = (Variable)i$.next();
            this.ddsvars.add(v);
        }
        for (Variable o : ncfile.getDimensions()) {
            Dimension dim = (Dimension)o;
            Variable cv = this.findvariable(dim.getName());
            if (cv == null || !cv.isCoordinateVariable()) continue;
            this.coordvars.put(dim.getName(), cv);
            if (!log.isDebugEnabled()) continue;
            log.debug(" NcDDS adding coordinate variable " + cv.getFullName() + " for dimension " + dim.getName());
        }
        for (Variable v : this.ddsvars) {
            Variable gv;
            boolean isgridarray;
            boolean bl = isgridarray = v.getRank() > 1 && v.getDataType() != DataType.STRUCTURE && v.getParentStructure() == null;
            if (!isgridarray) continue;
            Iterator iter = v.getDimensions().iterator();
            while (isgridarray && iter.hasNext()) {
                Dimension dim = (Dimension)iter.next();
                if (dim.getName() == null) {
                    isgridarray = false;
                    continue;
                }
                gv = this.coordvars.get(dim.getName());
                if (gv != null) continue;
                isgridarray = false;
            }
            if (!isgridarray) continue;
            this.gridarrays.put(v.getFullName(), v);
            for (Dimension dim : v.getDimensions()) {
                gv = this.coordvars.get(dim.getName());
                if (gv == null) continue;
                this.used.put(gv.getFullName(), gv);
            }
        }
        i$ = this.ddsvars.iterator();
        while (i$.hasNext()) {
            Variable o1;
            Variable cv = o1 = (Variable)i$.next();
            BaseType bt = null;
            bt = this.createVariable(ncfile, cv);
            this.addVariable(bt);
        }
    }

    private BaseType createVariable(NetcdfFile ncfile, Variable v) {
        Object bt = v.getRank() == 0 ? this.createScalarVariable(ncfile, v) : (v.getDataType() == DataType.CHAR ? (v.getRank() > 1 ? new NcSDCharArray(v) : new NcSDString(v)) : (v.getDataType() == DataType.STRING ? (v.getRank() == 0 ? new NcSDString(v) : new NcSDArray(v, (BaseType)new NcSDString(v))) : this.createArray(ncfile, v)));
        return bt;
    }

    private BaseType createScalarVariable(NetcdfFile ncfile, Variable v) {
        DataType dt = v.getDataType();
        if (dt == DataType.DOUBLE) {
            return new NcSDFloat64(v);
        }
        if (dt == DataType.FLOAT) {
            return new NcSDFloat32(v);
        }
        if (dt == DataType.INT) {
            return v.isUnsigned() ? new NcSDUInt32(v) : new NcSDInt32(v);
        }
        if (dt == DataType.SHORT) {
            return v.isUnsigned() ? new NcSDUInt16(v) : new NcSDInt16(v);
        }
        if (dt == DataType.BYTE) {
            return new NcSDByte(v);
        }
        if (dt == DataType.CHAR) {
            return new NcSDString(v);
        }
        if (dt == DataType.STRING) {
            return new NcSDString(v);
        }
        if (dt == DataType.STRUCTURE) {
            return this.createStructure(ncfile, (Structure)v);
        }
        throw new UnsupportedOperationException("NcDDS Variable data type = " + dt);
    }

    private BaseType createArray(NetcdfFile ncfile, Variable v) {
        boolean isGrid = this.gridarrays.get(v.getFullName()) != null;
        NcSDArray arr = new NcSDArray(v, this.createScalarVariable(ncfile, v));
        if (!isGrid) {
            return arr;
        }
        ArrayList<SDArray> list = new ArrayList<SDArray>();
        list.add(arr);
        for (Dimension dim : v.getDimensions()) {
            Variable v1 = this.used.get(dim.getName());
            assert (v1 != null);
            HasNetcdfVariable bt = null;
            bt = v1.getDataType() == DataType.CHAR ? (v1.getRank() > 1 ? new NcSDCharArray(v1) : new NcSDString(v1)) : new NcSDArray(v1, this.createScalarVariable(ncfile, v1));
            assert (bt != null);
            list.add((SDArray)bt);
        }
        return new NcSDGrid(v.getShortName(), list);
    }

    private BaseType createStructure(NetcdfFile ncfile, Structure s) {
        ArrayList<BaseType> list = new ArrayList<BaseType>();
        Iterator i$ = s.getVariables().iterator();
        while (i$.hasNext()) {
            Variable o;
            Variable nested = o = (Variable)i$.next();
            list.add(this.createVariable(ncfile, nested));
        }
        return new NcSDStructure(s, list);
    }

    public DAPNode cloneDAG(DAPNode.CloneMap map) throws CloneNotSupportedException {
        NcDDS d = (NcDDS)super.cloneDAG(map);
        d.coordvars = this.coordvars;
        return d;
    }
}

