/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.root;

import java.io.File;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.servlet.mvc.LastModified;
import thredds.server.config.TdsContext;
import thredds.servlet.UsageLog;
import thredds.util.RequestForwardUtils;
import thredds.util.TdsPathUtils;

public class RootController
extends AbstractController
implements LastModified {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private TdsContext tdsContext;

    public void setTdsContext(TdsContext tdsContext) {
        this.tdsContext = tdsContext;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest req, HttpServletResponse res) throws Exception {
        this.log.info("handleRequestInternal(): " + UsageLog.setupRequestContext(req));
        String path = TdsPathUtils.extractPath(req);
        if (null == path || path.equals("/") || path.equals("")) {
            String newPath = this.tdsContext.getContextPath() + "/catalog.html";
            res.sendRedirect(newPath);
            this.log.info("handleRequestInternal(): " + UsageLog.closingMessageForRequestContext(302, -1L));
            return null;
        }
        File file = this.tdsContext.getPublicDocFileSource().getFile(path);
        if (file == null) {
            RequestForwardUtils.forwardRequest(path, this.tdsContext.getDefaultRequestDispatcher(), req, res);
            return null;
        }
        this.log.info("handleRequestInternal(): " + UsageLog.closingMessageForRequestContext(200, -1L));
        return new ModelAndView("threddsFileView", "file", (Object)file);
    }

    public long getLastModified(HttpServletRequest req) {
        String path = TdsPathUtils.extractPath(req);
        File file = this.tdsContext.getPublicDocFileSource().getFile(path);
        if (file == null) {
            return -1L;
        }
        long lastModTime = file.lastModified();
        if (lastModTime == 0L) {
            return -1L;
        }
        return lastModTime;
    }
}

