/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wms;

import java.io.IOException;
import java.util.List;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import thredds.server.wms.ThreddsDataset;
import thredds.server.wms.ThreddsLayer;
import thredds.server.wms.config.LayerSettings;
import ucar.nc2.Attribute;
import ucar.nc2.dt.GridDatatype;
import uk.ac.rdg.resc.ncwms.cdm.CdmUtils;
import uk.ac.rdg.resc.ncwms.cdm.DataReadingStrategy;
import uk.ac.rdg.resc.ncwms.coords.HorizontalCoordSys;
import uk.ac.rdg.resc.ncwms.coords.HorizontalPosition;
import uk.ac.rdg.resc.ncwms.coords.PointList;
import uk.ac.rdg.resc.ncwms.exceptions.InvalidDimensionValueException;
import uk.ac.rdg.resc.ncwms.graphics.ColorPalette;
import uk.ac.rdg.resc.ncwms.util.Range;
import uk.ac.rdg.resc.ncwms.wms.AbstractScalarLayer;

class ThreddsScalarLayer
extends AbstractScalarLayer
implements ThreddsLayer {
    private GridDatatype grid;
    private ThreddsDataset dataset;
    private List<DateTime> times;
    private DataReadingStrategy dataReadingStrategy;
    private LayerSettings layerSettings;

    public ThreddsScalarLayer(String id) {
        super(id);
    }

    public String getName() {
        return this.getId();
    }

    @Override
    public ThreddsDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(ThreddsDataset dataset) {
        this.dataset = dataset;
    }

    public void setGridDatatype(GridDatatype grid) {
        this.grid = grid;
    }

    public Chronology getChronology() {
        if (this.times == null || this.times.isEmpty()) {
            return null;
        }
        return this.times.get(0).getChronology();
    }

    public List<DateTime> getTimeValues() {
        return this.times;
    }

    public void setTimeValues(List<DateTime> timeValues) {
        this.times = timeValues;
    }

    public void setDataReadingStrategy(DataReadingStrategy dataReadingStrategy) {
        this.dataReadingStrategy = dataReadingStrategy;
    }

    public Float readSinglePoint(DateTime time, double elevation, HorizontalPosition xy) throws InvalidDimensionValueException, IOException {
        PointList singlePoint = PointList.fromPoint((HorizontalPosition)xy);
        return this.readPointList(time, elevation, singlePoint).get(0);
    }

    public List<Float> readPointList(DateTime time, double elevation, PointList pointList) throws InvalidDimensionValueException, IOException {
        int tIndex = this.findAndCheckTimeIndex(time);
        int zIndex = this.findAndCheckElevationIndex(elevation);
        return CdmUtils.readPointList((GridDatatype)this.grid, (HorizontalCoordSys)this.getHorizontalCoordSys(), (int)tIndex, (int)zIndex, (PointList)pointList, (DataReadingStrategy)this.dataReadingStrategy);
    }

    @Override
    public String getStandardName() {
        if (this.grid == null) {
            return null;
        }
        Attribute stdNameAtt = this.grid.findAttributeIgnoreCase("standard_name");
        if (stdNameAtt == null || stdNameAtt.getStringValue().trim().equals("")) {
            return null;
        }
        return stdNameAtt.getStringValue();
    }

    @Override
    public void setLayerSettings(LayerSettings layerSettings) {
        this.layerSettings = layerSettings;
    }

    public boolean isQueryable() {
        return this.layerSettings.isAllowFeatureInfo();
    }

    public Range<Float> getApproxValueRange() {
        return this.layerSettings.getDefaultColorScaleRange();
    }

    public boolean isLogScaling() {
        return this.layerSettings.isLogScaling();
    }

    public ColorPalette getDefaultColorPalette() {
        return ColorPalette.get((String)this.layerSettings.getDefaultPaletteName());
    }

    public int getDefaultNumColorBands() {
        return this.layerSettings.getDefaultNumColorBands();
    }
}

