/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.File;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import thredds.servlet.DataRootHandler;
import thredds.servlet.DatasetSource;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;

public class DatasetSourceExample
implements DatasetSource {
    static final String prefix = "/special/";
    static final int prefixLen = "/special/".length();

    public DatasetSourceExample() {
        System.out.printf("%s%n", "YO");
    }

    @Override
    public boolean isMine(HttpServletRequest req) {
        String path = req.getPathInfo();
        return path.startsWith(prefix);
    }

    @Override
    public NetcdfFile getNetcdfFile(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String path = req.getPathInfo().substring(prefixLen);
        DataRootHandler.DataRootMatch match = DataRootHandler.getInstance().findDataRootMatch(path);
        if (match == null) {
            res.sendError(404, path);
            return null;
        }
        int pos = match.remaining.lastIndexOf(46);
        String filename = match.remaining.substring(0, pos);
        File file = new File(match.dirLocation + filename);
        if (!file.exists()) {
            res.sendError(404, match.dirLocation + filename);
            return null;
        }
        NetcdfFile ncfile = NetcdfDataset.openFile((String)file.getPath(), null);
        ncfile.addAttribute(null, new Attribute("Special", req.getRequestURI()));
        ncfile.finish();
        return ncfile;
    }
}

