/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet.restrict;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import thredds.servlet.restrict.RoleSource;

public class RoleDatabase
implements RoleSource {
    private HashMap<String, User> users = new HashMap();

    RoleDatabase(String filename) throws IOException {
        Document doc;
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(filename));
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build((InputStream)is);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        Element rootElem = doc.getRootElement();
        List elems = rootElem.getChildren("user");
        for (Object elem1 : elems) {
            Element elem = (Element)elem1;
            String username = elem.getAttributeValue("username");
            User user = new User(username);
            String roles = elem.getAttributeValue("roles");
            StringTokenizer stoke = new StringTokenizer(roles, ", ");
            while (stoke.hasMoreTokens()) {
                String role = stoke.nextToken();
                user.add(role);
            }
            this.users.put(username, user);
        }
    }

    @Override
    public boolean hasRole(String username, String role) {
        User user = this.users.get(username);
        if (user == null) {
            return false;
        }
        for (String role1 : user.roles) {
            if (!role.equals(role1)) continue;
            return true;
        }
        return false;
    }

    private class User {
        String name;
        ArrayList<String> roles = new ArrayList();

        User(String name) {
            this.name = name;
        }

        void add(String role) {
            this.roles.add(role);
        }
    }
}

