/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet.tomcat;

import java.io.IOException;
import java.util.Formatter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.valves.ValveBase;

public class UsageValve
extends ValveBase
implements Lifecycle {
    private Formatter fout;
    private long startTime;
    private long count = 0L;
    private boolean started = false;
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);

    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (this.started) {
            int status = response.getStatus();
            if (status == 302) {
                this.getNext().invoke(request, response);
                return;
            }
            long t1 = System.currentTimeMillis();
            this.getNext().invoke(request, response);
            long time = System.currentTimeMillis() - t1;
            long minute = (t1 - this.startTime) / 60000L;
            if (this.count % 10L == 0L) {
                this.fout.format("ret msecs bytes minute  ip             context   servlet   path?query          dataset%n", new Object[0]);
            }
            ++this.count;
            StringBuilder sb = new StringBuilder();
            if (request.getPathInfo() != null) {
                sb.append(request.getPathInfo());
            }
            if (request.getQueryString() != null) {
                sb.append("?");
                sb.append(request.getQueryString());
            }
            String dataset = null;
            HttpSession s = request.getSession(false);
            if (s != null) {
                dataset = (String)s.getAttribute("dataset");
            }
            this.fout.format("%3d %5d %5d %5d %-16s %-10s %-10s %-20s %-20s%n", status, time, response.getContentCount(), minute, request.getRemoteAddr(), request.getContextPath(), request.getServletPath(), sb.toString(), dataset == null ? "" : dataset);
        } else {
            this.getNext().invoke(request, response);
        }
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.addLifecycleListener(lifecycleListener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.removeLifecycleListener(lifecycleListener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("accessLogValve.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.startTime = System.currentTimeMillis();
        this.fout = new Formatter(System.out);
        this.fout.format("AccessValve started%n", new Object[0]);
        this.started = true;
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("accessLogValve.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
    }
}

