/*
 * Decompiled with CFR 0.152.
 */
package thredds.dqc.server;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.dqc.server.DqcHandlerInstantiationException;
import thredds.dqc.server.DqcServletConfigItem;

public abstract class DqcHandler {
    private static Logger log = LoggerFactory.getLogger(DqcHandler.class);
    private DqcServletConfigItem handlerInfo = null;

    protected DqcServletConfigItem getHandlerInfo() {
        return this.handlerInfo;
    }

    protected void setHandlerInfo(DqcServletConfigItem info) {
        this.handlerInfo = info;
    }

    public static final DqcHandler factory(DqcServletConfigItem handlerInfo, String configPath) throws DqcHandlerInstantiationException, IOException {
        String tmpMsg = null;
        Class<?> handlerClass = null;
        DqcHandler newHandler = null;
        try {
            handlerClass = Class.forName(handlerInfo.getHandlerClassName());
        }
        catch (ClassNotFoundException e) {
            tmpMsg = "Requested DqcHandler class not found <" + handlerInfo.getHandlerClassName() + ">: " + e.getMessage();
            throw new DqcHandlerInstantiationException(tmpMsg, e);
        }
        log.debug("factory(): loaded class for DqcHandler <" + handlerInfo.getHandlerClassName() + "> with given config doc.");
        try {
            newHandler = (DqcHandler)handlerClass.newInstance();
        }
        catch (InstantiationException e) {
            tmpMsg = "Could not instantiate requested DqcHandler <" + handlerInfo.getHandlerClassName() + ">: " + e.getMessage();
            throw new DqcHandlerInstantiationException(tmpMsg, e);
        }
        catch (IllegalAccessException e) {
            tmpMsg = "Could not instantiate requested DqcHandler <" + handlerInfo.getHandlerClassName() + ">: " + e.getMessage();
            throw new DqcHandlerInstantiationException(tmpMsg, e);
        }
        log.debug("Instantiated DqcHandler <" + handlerInfo.getHandlerClassName() + ">.");
        newHandler.setHandlerInfo(handlerInfo);
        URL configDocURL = null;
        if (configPath != null && handlerInfo.getHandlerConfigFileName() != null) {
            File configFile = new File(configPath, handlerInfo.getHandlerConfigFileName());
            if (!configFile.canRead()) {
                configDocURL = handlerClass.getResource(configPath + "/" + handlerInfo.getHandlerConfigFileName());
            } else {
                URI configDocURI = configFile.toURI();
                try {
                    configDocURL = configDocURI.toURL();
                }
                catch (MalformedURLException e) {
                    tmpMsg = "Config file URL malformed <" + configDocURL.toString() + ">: " + e.getMessage();
                    throw new DqcHandlerInstantiationException(tmpMsg, e);
                }
            }
        }
        newHandler.initWithHandlerConfigDoc(configDocURL);
        log.debug("Initialized DqcHandler with config documents.");
        return newHandler;
    }

    public abstract void initWithHandlerConfigDoc(URL var1) throws IOException;

    public abstract void handleRequest(HttpServletRequest var1, HttpServletResponse var2) throws IOException, ServletException;
}

