/*
 * Decompiled with CFR 0.152.
 */
package thredds.dqc.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDocumentation;
import thredds.catalog.InvService;
import thredds.catalog.ServiceType;
import thredds.dqc.server.DqcHandler;
import thredds.dqc.server.DqcHandlerInstantiationException;
import thredds.dqc.server.DqcServletConfig;
import thredds.dqc.server.DqcServletConfigItem;
import thredds.server.config.TdsContext;
import thredds.servlet.HtmlWriter;
import thredds.servlet.ThreddsConfig;
import thredds.servlet.UsageLog;

public class DqcServiceController
extends AbstractController {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Logger logServerStartup = LoggerFactory.getLogger((String)"serverStartup");
    private TdsContext tdsContext;
    private HtmlWriter htmlWriter;
    private boolean allow = false;
    private String dqcConfigDirName;
    private String dqcConfigFileName;
    private File dqcConfigDir;
    private File dqcConfigFile;
    private DqcServletConfig dqcConfig;

    public void setTdsContext(TdsContext tdsContext) {
        this.tdsContext = tdsContext;
    }

    public void setHtmlWriter(HtmlWriter htmlWriter) {
        this.htmlWriter = htmlWriter;
    }

    public void setDqcConfigDirName(String dqcConfigDirName) {
        this.dqcConfigDirName = dqcConfigDirName;
    }

    public void setDqcConfigFileName(String dqcConfigFileName) {
        this.dqcConfigFileName = dqcConfigFileName;
    }

    public void init() {
        this.logServerStartup.info("DQC Service - init start - " + UsageLog.setupNonRequestContext());
        this.allow = ThreddsConfig.getBoolean("DqcService.allow", false);
        if (!this.allow) {
            this.logServerStartup.info("Dqc Service not enabled in threddsConfig.xml - " + UsageLog.closingMessageNonRequestContext());
            return;
        }
        if (this.tdsContext == null) {
            this.allow = false;
            this.logServerStartup.error("Disabling Dqc Service - null TdsContext - " + UsageLog.closingMessageNonRequestContext());
            return;
        }
        this.dqcConfigDir = this.tdsContext.getConfigFileSource().getFile(this.dqcConfigDirName);
        if (this.dqcConfigDir == null) {
            this.dqcConfigDir = this.createDqcConfigDirectory();
            if (this.dqcConfigDir == null) {
                this.allow = false;
                this.logServerStartup.error("Disabling Dqc Service - " + UsageLog.closingMessageNonRequestContext());
                return;
            }
        }
        this.dqcConfigFile = new File(this.dqcConfigDir, this.dqcConfigFileName);
        if (!this.dqcConfigFile.exists()) {
            this.dqcConfigFile = this.createDqcConfigFile();
            if (this.dqcConfigFile == null) {
                this.allow = false;
                this.logServerStartup.error("Disabling Dqc Service - " + UsageLog.closingMessageNonRequestContext());
                return;
            }
        }
        this.logServerStartup.debug("Dqc Service config directory = " + this.dqcConfigDir.toString());
        this.logServerStartup.debug("Dqc Service config file      = " + this.dqcConfigFile.toString());
        try {
            this.dqcConfig = new DqcServletConfig(this.dqcConfigDir, this.dqcConfigFileName);
        }
        catch (Throwable t) {
            this.allow = false;
            this.logServerStartup.error("Disabling Dqc Service - failed to read DqcConfig document: " + t.getMessage());
            this.logServerStartup.info("Done - " + UsageLog.closingMessageNonRequestContext());
            return;
        }
        this.logServerStartup.info("DQC Service - init done - " + UsageLog.closingMessageNonRequestContext());
    }

    public void destroy() {
        this.logServerStartup.info("DQC Service - destroy start - " + UsageLog.setupNonRequestContext());
        this.logServerStartup.info("DQC Service - destroy done - " + UsageLog.closingMessageNonRequestContext());
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        DqcHandler reqHandler;
        this.log.info("handleRequestInternal(): " + UsageLog.setupRequestContext(request));
        if (!this.allow) {
            String msg = "DQC service not supported.";
            this.log.info("handleRequestInternal(): " + msg);
            this.log.info("handleRequestInternal(): " + UsageLog.closingMessageForRequestContext(403, msg.length()));
            response.sendError(403, msg);
            return null;
        }
        String reqPath = request.getPathInfo();
        if (reqPath.equals("/")) {
            ArrayList<DqcServletConfigItem> items = new ArrayList<DqcServletConfigItem>();
            Iterator itemIterator = this.dqcConfig.getIterator();
            while (itemIterator.hasNext()) {
                items.add((DqcServletConfigItem)itemIterator.next());
            }
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("contextPath", request.getContextPath());
            model.put("servletPath", request.getServletPath());
            model.put("dqcConfigItems", items);
            this.tdsContext.getHtmlConfig().addHtmlConfigInfoToModel(model);
            this.log.info("handleRequestInternal(): " + UsageLog.closingMessageForRequestContext(200, -1L));
            return new ModelAndView("/thredds/server/dqc/dqcConfig", model);
        }
        if (reqPath.equals("/catalog.xml")) {
            InvCatalog catalog = this.createCatalogRepresentation(request.getContextPath(), request.getServletPath());
            return new ModelAndView("threddsInvCatXmlView", "catalog", (Object)catalog);
        }
        if (reqPath.equals("/catalog.html")) {
            InvCatalog catalog = this.createCatalogRepresentation(request.getContextPath(), request.getServletPath());
            int i = this.htmlWriter.writeCatalog(request, response, (InvCatalogImpl)catalog, true);
            this.log.info("handleRequestInternal(): " + UsageLog.closingMessageForRequestContext(200, i));
            return null;
        }
        String handlerName = reqPath = reqPath.substring(1);
        this.log.debug("handleRequestInternal(): Attempt to find \"" + handlerName + "\" handler.");
        DqcServletConfigItem reqHandlerInfo = this.dqcConfig.findItem(handlerName);
        if (reqHandlerInfo == null && reqPath.endsWith(".xml")) {
            handlerName = reqPath.substring(0, reqPath.length() - 4);
            this.log.debug("handleRequestInternal(): Attempt to find \"" + handlerName + "\" handler ('.xml').");
            reqHandlerInfo = this.dqcConfig.findItem(handlerName);
        }
        if (reqHandlerInfo == null && reqPath.endsWith(".html")) {
            handlerName = reqPath.substring(0, reqPath.length() - 5);
            this.log.debug("handleRequestInternal(): Attempt to find \"" + handlerName + "\" handler ('.html').");
            reqHandlerInfo = this.dqcConfig.findItem(handlerName);
            if (reqHandlerInfo != null) {
                String msg = "Not currently handling HTML views of DQC documents.";
                this.log.info("handleRequestInternal(): " + msg + " - " + UsageLog.closingMessageForRequestContext(400, msg.length()));
                response.sendError(400, msg);
                return null;
            }
        }
        if (reqHandlerInfo == null && reqPath.indexOf(47) != -1) {
            handlerName = reqPath.substring(0, reqPath.indexOf(47));
            this.log.debug("handleRequestInternal(): Attempt to find \"" + handlerName + "\" handler. ('/')");
            reqHandlerInfo = this.dqcConfig.findItem(handlerName);
        }
        if (reqHandlerInfo == null) {
            String tmpMsg = "No DQC Handler available for path <" + reqPath + ">.";
            this.log.warn("handleRequestInternal(): " + tmpMsg);
            response.sendError(400, tmpMsg);
            this.log.info("handleRequestInternal(): " + UsageLog.closingMessageForRequestContext(400, -1L));
            return null;
        }
        this.log.debug("handleRequestInternal(): creating handler for " + reqHandlerInfo.getHandlerClassName());
        try {
            reqHandler = DqcHandler.factory(reqHandlerInfo, this.dqcConfigDir.getAbsolutePath());
        }
        catch (DqcHandlerInstantiationException e) {
            String tmpMsg = "Handler could not be constructed for " + reqHandlerInfo.getHandlerClassName() + ": " + e.getMessage();
            this.log.error("handleRequestInternal(): " + tmpMsg, (Throwable)e);
            response.sendError(500, tmpMsg);
            this.log.info("handleRequestInternal(): " + UsageLog.closingMessageForRequestContext(500, -1L));
            return null;
        }
        if (reqHandler != null) {
            this.log.debug("handleRequestInternal(): handing query to handler");
            reqHandler.handleRequest(request, response);
            return null;
        }
        String tmpMsg = "No handler for " + reqHandlerInfo.getHandlerClassName();
        this.log.error("handleRequestInternal(): " + tmpMsg);
        response.sendError(500, tmpMsg);
        this.log.info("handleRequestInternal(): " + UsageLog.closingMessageForRequestContext(500, 0L));
        return null;
    }

    public InvCatalog createCatalogRepresentation(String contextPath, String servletPath) {
        URI baseUri;
        String serviceName = "myDqcServlet";
        try {
            baseUri = new URI(contextPath + servletPath + "/catalog.xml");
        }
        catch (URISyntaxException e) {
            baseUri = null;
        }
        InvCatalogImpl catalog = new InvCatalogImpl(null, null, baseUri);
        InvService myService = new InvService(serviceName, ServiceType.RESOLVER.toString(), contextPath + servletPath + "/", null, null);
        InvDatasetImpl topDs = new InvDatasetImpl(null, "DqcServlet Available Datasets");
        catalog.addService(myService);
        catalog.addDataset(topDs);
        DqcServletConfigItem curItem = null;
        Iterator it = this.dqcConfig.getIterator();
        InvDatasetImpl curDs = null;
        InvDocumentation curDoc = null;
        StringBuffer docContent = null;
        while (it.hasNext()) {
            curItem = (DqcServletConfigItem)it.next();
            curDs = new InvDatasetImpl(topDs, curItem.getDescription(), null, serviceName, curItem.getName() + ".xml");
            docContent = new StringBuffer();
            docContent.append(curItem.getDescription() + "\n").append("Using the DqcHandler " + curItem.getHandlerClassName()).append(" with config file " + curItem.getHandlerConfigFileName() + ".");
            curDoc = new InvDocumentation(null, null, null, null, docContent.toString());
            curDs.addDocumentation(curDoc);
            topDs.addDataset(curDs);
        }
        catalog.finish();
        return catalog;
    }

    private File createDqcConfigDirectory() {
        File dqcConfigDir = new File(this.tdsContext.getContentDirectory(), this.dqcConfigDirName);
        if (dqcConfigDir.exists()) {
            this.log.error("createDqcConfigDirectory(): Existing DqcConfigDir [" + dqcConfigDir + "] not found in TdsContext ConfigFileSource, check TdsContext config.");
            return null;
        }
        if (!dqcConfigDir.mkdirs()) {
            this.log.error("createDqcConfigDirectory(): Failed to create DqcConfig directory.");
            return null;
        }
        if (!dqcConfigDir.equals(this.tdsContext.getConfigFileSource().getFile(this.dqcConfigDirName))) {
            this.log.error("createDqcConfigDirectory(): Newly created DqcConfig directory not found by TdsContext ConfigFileSource.");
            return null;
        }
        return dqcConfigDir;
    }

    private File createDqcConfigFile() {
        File dqcConfigFile = new File(this.dqcConfigDir, this.dqcConfigFileName);
        if (dqcConfigFile.exists()) {
            this.log.error("createDqcConfigFile(): Existing DqcConfigFile [" + dqcConfigFile + "] not found in TdsContext ConfigFileSource, check TdsContext config.");
            return null;
        }
        boolean created = false;
        try {
            created = dqcConfigFile.createNewFile();
        }
        catch (IOException e) {
            this.log.error("createDqcConfigFile(): I/O error while creating DqcConfig file.");
            return null;
        }
        if (!created) {
            this.log.error("createDqcConfigFile(): Failed to create DqcConfig file.");
            return null;
        }
        if (!this.writeEmptyConfigDocToFile(dqcConfigFile)) {
            this.log.error("createDqcConfigFile(): Failed to write empty config file [" + dqcConfigFile + "].");
            return null;
        }
        return dqcConfigFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeEmptyConfigDocToFile(File configFile) {
        FileOutputStream fos = null;
        OutputStreamWriter writer = null;
        try {
            fos = new FileOutputStream(configFile);
            writer = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            writer.append(this.genEmptyConfigDocAsString());
            writer.flush();
        }
        catch (IOException e) {
            this.log.debug("writeEmptyConfigDocToFile(): IO error writing blank config file: " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                this.log.debug("writeEmptyConfigDocToFile(): IO error closing just written blank config file: " + e.getMessage());
                return true;
            }
        }
        return true;
    }

    private String genEmptyConfigDocAsString() {
        StringBuilder sb = new StringBuilder().append("<?xml version='1.0' encoding='UTF-8'?>\n").append("<preferences EXTERNAL_XML_VERSION='1.0'>\n").append("  <root type='user'>\n").append("    <map>\n").append("      <beanCollection key='config' class='thredds.dqc.server.DqcServletConfigItem'>\n").append("      </beanCollection>\n").append("    </map>\n").append("  </root>\n").append("</preferences>");
        return sb.toString();
    }
}

