/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalogservice;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.util.DeepCopyUtils;
import thredds.server.catalogservice.CatalogServiceUtils;
import thredds.server.catalogservice.Command;
import thredds.server.catalogservice.LocalCatalogRequest;
import thredds.server.config.TdsContext;
import thredds.servlet.DataRootHandler;
import thredds.servlet.HtmlWriter;
import thredds.servlet.UsageLog;
import thredds.util.RequestForwardUtils;

public class LocalCatalogServiceController
extends AbstractController {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private TdsContext tdsContext;
    private HtmlWriter htmlWriter;
    private boolean catalogSupportOnly;
    private boolean htmlView;

    public void setTdsContext(TdsContext tdsContext) {
        this.tdsContext = tdsContext;
    }

    public void setHtmlWriter(HtmlWriter htmlWriter) {
        this.htmlWriter = htmlWriter;
    }

    public boolean isCatalogSupportOnly() {
        return this.catalogSupportOnly;
    }

    public void setCatalogSupportOnly(boolean catalogSupportOnly) {
        this.catalogSupportOnly = catalogSupportOnly;
    }

    public boolean isHtmlView() {
        return this.htmlView;
    }

    public void setHtmlView(boolean htmlView) {
        this.htmlView = htmlView;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            this.log.info("handleRequestInternal(): " + UsageLog.setupRequestContext(request));
            BindingResult bindingResult = CatalogServiceUtils.bindAndValidateLocalCatalogRequest(request, this.htmlView);
            if (bindingResult.hasErrors()) {
                StringBuilder msg = new StringBuilder("Bad request");
                List oeList = bindingResult.getAllErrors();
                for (ObjectError e : oeList) {
                    msg.append(": ").append(e.getDefaultMessage() != null ? e.getDefaultMessage() : e.toString());
                }
                this.log.info("handleRequestInternal(): " + msg);
                this.log.info("handleRequestInternal(): " + UsageLog.closingMessageForRequestContext(400, msg.length()));
                response.sendError(400, msg.toString());
                return null;
            }
            LocalCatalogRequest catalogServiceRequest = (LocalCatalogRequest)bindingResult.getTarget();
            String path = catalogServiceRequest.getPath();
            String catalogPath = this.htmlView ? path.replaceAll(".html$", ".xml") : path;
            DataRootHandler drh = DataRootHandler.getInstance();
            InvCatalog catalog = null;
            String baseUriString = request.getRequestURL().toString();
            try {
                catalog = drh.getCatalog(catalogPath, new URI(baseUriString));
            }
            catch (URISyntaxException e) {
                String msg = "Bad URI syntax [" + baseUriString + "]: " + e.getMessage();
                this.log.error("handleRequestInternal(): " + msg);
                this.log.info("handleRequestInternal(): " + UsageLog.closingMessageForRequestContext(400, msg.length()));
                response.sendError(400, msg.toString());
                return null;
            }
            if (catalog == null) {
                return this.handlePublicDocumentRequest(request, response, path);
            }
            if (catalogServiceRequest.getCommand().equals((Object)Command.SHOW)) {
                if (this.htmlView) {
                    int i = this.htmlWriter.writeCatalog(request, response, (InvCatalogImpl)catalog, true);
                    this.log.info("handleRequestInternal(): " + UsageLog.closingMessageForRequestContext(200, i));
                    return null;
                }
                return new ModelAndView("threddsInvCatXmlView", "catalog", (Object)catalog);
            }
            if (catalogServiceRequest.getCommand().equals((Object)Command.SUBSET)) {
                String datasetId = catalogServiceRequest.getDataset();
                InvDataset dataset = catalog.findDatasetByID(datasetId);
                if (dataset == null) {
                    String msg = "Did not find dataset [" + datasetId + "] in catalog [" + baseUriString + "].";
                    this.log.info("handleRequestInternal(): " + UsageLog.closingMessageForRequestContext(404, msg.length()));
                    response.sendError(404, msg.toString());
                    return null;
                }
                if (this.htmlView) {
                    int i = this.htmlWriter.showDataset(baseUriString, (InvDatasetImpl)dataset, request, response, true);
                    this.log.info("handleRequestInternal(): " + UsageLog.closingMessageForRequestContext(200, i));
                    return null;
                }
                InvCatalog subsetCat = DeepCopyUtils.subsetCatalogOnDataset((InvCatalog)catalog, (InvDataset)dataset);
                return new ModelAndView("threddsInvCatXmlView", "catalog", (Object)subsetCat);
            }
            String msg = "Unsupported request command [" + (Object)((Object)catalogServiceRequest.getCommand()) + "].";
            this.log.error("handleRequestInternal(): " + msg + " -- NOTE: Should have been caught on input validation.");
            this.log.info("handleRequestInternal(): " + UsageLog.closingMessageForRequestContext(400, msg.length()));
            response.sendError(400, msg.toString());
            return null;
        }
        catch (IOException e) {
            this.log.error("handleRequestInternal(): Trouble writing to response.", (Throwable)e);
            this.log.info("handleRequestInternal(): " + UsageLog.closingMessageForRequestContext(400, -1L));
            return null;
        }
        catch (Throwable e) {
            this.log.error("handleRequestInternal(): Problem handling request.", e);
            this.log.info("handleRequestInternal(): " + UsageLog.closingMessageForRequestContext(500, -1L));
            if (!response.isCommitted()) {
                response.sendError(500);
            }
            return null;
        }
    }

    private ModelAndView handlePublicDocumentRequest(HttpServletRequest request, HttpServletResponse response, String path) throws IOException, ServletException {
        if (this.catalogSupportOnly) {
            this.log.info("handlePublicDocumentRequest(): " + UsageLog.closingMessageForRequestContext(404, 0L));
            response.sendError(404);
            return null;
        }
        File publicFile = this.tdsContext.getPublicDocFileSource().getFile(path);
        if (publicFile != null) {
            this.log.info("handlePublicDocumentRequest(): " + UsageLog.closingMessageForRequestContext(200, -1L));
            return new ModelAndView("threddsFileView", "file", (Object)publicFile);
        }
        RequestForwardUtils.forwardRequest(path, this.tdsContext.getDefaultRequestDispatcher(), request, response);
        return null;
    }
}

