/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.cdmremote;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.servlet.mvc.LastModified;
import thredds.server.config.TdsContext;
import thredds.servlet.DataRootHandler;
import thredds.servlet.DatasetHandler;
import thredds.servlet.ServletUtil;
import thredds.servlet.UsageLog;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ParsedSectionSpec;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.stream.NcStreamWriter;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;
import ucar.nc2.util.net.EscapeStrings;
import ucar.unidata.geoloc.LatLonRect;

public class CdmRemoteControllerOld
extends AbstractController
implements LastModified {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private TdsContext tdsContext;
    private boolean allow = true;
    private boolean debug = false;

    public void setTdsContext(TdsContext tdsContext) {
        this.tdsContext = tdsContext;
    }

    public void setAllow(boolean allow) {
        this.allow = allow;
    }

    public long getLastModified(HttpServletRequest req) {
        File file = DataRootHandler.getInstance().getCrawlableDatasetAsFile(req.getPathInfo());
        if (file != null && file.exists()) {
            return file.lastModified();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelAndView handleRequestInternal(HttpServletRequest req, HttpServletResponse res) throws Exception {
        if (!this.allow) {
            res.sendError(403, "Service not supported");
            return null;
        }
        this.log.info(UsageLog.setupRequestContext(req));
        String pathInfo = req.getPathInfo();
        if (this.debug) {
            System.out.println("request= " + ServletUtil.getRequest(req));
        }
        String query = EscapeStrings.unescapeOGC((String)req.getQueryString());
        String view = ServletUtil.getParameterIgnoreCase(req, "view");
        if (view == null) {
            view = query;
        }
        if (view == null) {
            view = "";
        }
        if (view.equalsIgnoreCase("getCapabilities")) {
            CdmRemoteControllerOld.sendCapabilities(req, (OutputStream)res.getOutputStream(), FeatureType.STATION, true);
            res.flushBuffer();
            this.log.info(UsageLog.closingMessageForRequestContext(200, -1L));
            return null;
        }
        NetcdfFile ncfile = null;
        try {
            ncfile = DatasetHandler.getNetcdfFile(req, res, pathInfo);
            if (ncfile == null) {
                res.setStatus(404);
                this.log.info(UsageLog.closingMessageForRequestContext(404, -1L));
                return null;
            }
        }
        catch (FileNotFoundException e) {
            this.log.info(UsageLog.closingMessageForRequestContext(404, 0L));
            res.sendError(404, e.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.log.info(UsageLog.closingMessageForRequestContext(500, 0L));
            res.sendError(500, e.getMessage());
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)res.getOutputStream(), 10000);
            if (query == null || view.equalsIgnoreCase("cdl")) {
                res.setContentType("text/plain");
                String cdl = ncfile.toString();
                res.setContentLength(cdl.length());
                ((OutputStream)out).write(cdl.getBytes());
            } else if (view.equalsIgnoreCase("ncml")) {
                res.setContentType("application/xml");
                ncfile.writeNcML((OutputStream)out, pathInfo);
            } else {
                res.setContentType("application/octet-stream");
                res.setHeader("Content-Description", "ncstream");
                WritableByteChannel wbc = Channels.newChannel(out);
                NcStreamWriter ncWriter = new NcStreamWriter(ncfile, ServletUtil.getRequestBase(req));
                if (query.equals("header")) {
                    ncWriter.sendHeader(wbc);
                } else {
                    query = EscapeStrings.urlDecode((String)query);
                    StringTokenizer stoke = new StringTokenizer(query, ";");
                    while (stoke.hasMoreTokens()) {
                        ParsedSectionSpec cer = ParsedSectionSpec.parseVariableSection((NetcdfFile)ncfile, (String)stoke.nextToken());
                        ncWriter.sendData(cer.v, cer.section, wbc);
                    }
                }
            }
            ((OutputStream)out).flush();
            res.flushBuffer();
            this.log.info(UsageLog.closingMessageForRequestContext(200, -1L));
        }
        catch (IllegalArgumentException e) {
            this.log.info(UsageLog.closingMessageForRequestContext(400, 0L));
            res.sendError(400, e.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.log.info(UsageLog.closingMessageForRequestContext(500, 0L));
            res.sendError(500, e.getMessage());
        }
        finally {
            if (null != ncfile) {
                try {
                    ncfile.close();
                }
                catch (IOException ioe) {
                    this.log.error("Failed to close = " + pathInfo);
                }
            }
        }
        return null;
    }

    static void sendCapabilities(HttpServletRequest req, OutputStream os, FeatureType ft, boolean addSuffix) throws IOException {
        Element rootElem = new Element("cdmRemoteCapabilities");
        Document doc = new Document(rootElem);
        rootElem.setAttribute("location", ServletUtil.getRequestBase(req));
        Element elem = new Element("featureDataset");
        elem.setAttribute("type", ft.toString());
        elem.setAttribute("url", CdmRemoteControllerOld.makeFeatureUri(req, ft, addSuffix));
        rootElem.addContent((Content)elem);
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        fmt.output(doc, os);
    }

    static void sendCapabilities(HttpServletRequest req, OutputStream os, FeatureDatasetPoint fd, boolean addSuffix) throws IOException {
        DateRange t;
        Element rootElem = new Element("cdmRemoteCapabilities");
        Document doc = new Document(rootElem);
        rootElem.setAttribute("location", ServletUtil.getRequestBase(req));
        Element elem = new Element("featureDataset");
        elem.setAttribute("type", fd.getFeatureType().toString());
        elem.setAttribute("url", CdmRemoteControllerOld.makeFeatureUri(req, fd.getFeatureType(), addSuffix));
        rootElem.addContent((Content)elem);
        LatLonRect bb = fd.getBoundingBox();
        if (bb != null) {
            elem = new Element("geospatialCoverage");
            rootElem.addContent((Content)elem);
            Element northsouth = new Element("northsouth");
            elem.addContent((Content)northsouth);
            northsouth.addContent((Content)new Element("start").setText(Double.toString(bb.getLatMin())));
            northsouth.addContent((Content)new Element("size").setText(Double.toString(bb.getHeight())));
            Element eastwest = new Element("eastwest");
            elem.addContent((Content)eastwest);
            eastwest.addContent((Content)new Element("start").setText(Double.toString(bb.getLonMin())));
            eastwest.addContent((Content)new Element("size").setText(Double.toString(bb.getWidth())));
        }
        if ((t = fd.getDateRange()) != null) {
            Element telem;
            elem = new Element("timeCoverage");
            rootElem.addContent((Content)elem);
            DateType start = t.getStart();
            DateType end = t.getEnd();
            TimeDuration duration = t.getDuration();
            if (t.useStart() && start != null && !start.isBlank()) {
                Element startElem = new Element("start");
                startElem.setText(start.toString());
                elem.addContent((Content)startElem);
            }
            if (t.useEnd() && end != null && !end.isBlank()) {
                telem = new Element("end");
                telem.setText(end.toString());
                elem.addContent((Content)telem);
            }
            if (t.useDuration() && duration != null && !duration.isBlank()) {
                telem = new Element("duration");
                telem.setText(duration.toString());
                elem.addContent((Content)telem);
            }
        }
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        fmt.output(doc, os);
    }

    static String makeFeatureUri(HttpServletRequest req, FeatureType ft, boolean addSuffix) {
        String url = ServletUtil.getRequestServer(req) + req.getContextPath() + req.getServletPath() + req.getPathInfo();
        if (addSuffix) {
            url = url + "/" + ft.toString().toLowerCase();
        }
        return url;
    }
}

