/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.config;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.util.Log4jWebConfigurer;
import thredds.inventory.CollectionUpdater;
import thredds.server.config.TdsContext;
import thredds.servlet.UsageLog;

public class TdsConfigContextListener
implements ServletContextListener {
    private Logger logServerStartup = LoggerFactory.getLogger((String)"serverStartup");

    public void contextInitialized(ServletContextEvent event) {
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.logServerStartup.info("TdsConfigContextListener.contextDestroyed(): start." + UsageLog.setupNonRequestContext());
        CollectionUpdater.INSTANCE.shutdown();
        ServletContext servletContext = event.getServletContext();
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        TdsContext tdsContext = (TdsContext)wac.getBean("tdsContext", TdsContext.class);
        tdsContext.destroy();
        this.logServerStartup.info("TdsConfigContextListener.contextDestroyed(): Done except for shutdownLogging() - " + UsageLog.closingMessageNonRequestContext());
        Log4jWebConfigurer.shutdownLogging((ServletContext)servletContext);
    }
}

