/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset.controller;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import thredds.server.ncSubset.controller.AbstratNcssDataRequestController;
import thredds.server.ncSubset.controller.NcssDiskCache;
import thredds.server.ncSubset.controller.SupportedFormat;
import thredds.server.ncSubset.controller.SupportedOperation;
import thredds.server.ncSubset.exception.InvalidBBOXException;
import thredds.server.ncSubset.exception.NcssException;
import thredds.server.ncSubset.exception.OutOfBoundariesException;
import thredds.server.ncSubset.exception.RequestTooLargeException;
import thredds.server.ncSubset.exception.TimeOutOfWindowException;
import thredds.server.ncSubset.exception.UnsupportedOperationException;
import thredds.server.ncSubset.exception.UnsupportedResponseFormatException;
import thredds.server.ncSubset.exception.VariableNotContainedInDatasetException;
import thredds.server.ncSubset.params.GridDataRequestParamsBean;
import thredds.server.ncSubset.params.RequestParamsBean;
import thredds.server.ncSubset.util.NcssRequestUtils;
import thredds.servlet.ThreddsConfig;
import thredds.servlet.UsageLog;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.NetcdfCFWriter;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.util.IO;
import ucar.nc2.util.Misc;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionRect;

@Controller
@RequestMapping(value={"/ncss/grid/"})
class GridDataController
extends AbstratNcssDataRequestController {
    private static final Logger log = LoggerFactory.getLogger(GridDataController.class);
    private HttpHeaders httpHeaders = new HttpHeaders();
    private File netcdfResult;
    private long maxFileDownloadSize = -1L;

    GridDataController() {
    }

    @RequestMapping(value={"**"}, params={"!latitude", "!longitude", "var"})
    void getGridSubset(@Valid GridDataRequestParamsBean params, BindingResult validationResult, HttpServletResponse response) throws UnsupportedResponseFormatException, RequestTooLargeException, OutOfBoundariesException, VariableNotContainedInDatasetException, InvalidBBOXException, InvalidRangeException, ParseException, IOException, UnsupportedOperationException, TimeOutOfWindowException {
        if (validationResult.hasErrors()) {
            this.handleValidationErrorsResponse(response, 400, validationResult);
        } else {
            SupportedFormat sf = this.getSupportedFormat(params, SupportedOperation.GRID_REQUEST);
            this.checkRequestedVars(this.gridDataset, params);
            if (this.isSpatialSubset(params)) {
                this.spatialSubset(params, response);
            } else {
                this.coordinatesSubset(params, response);
            }
            this.setResponseHeaders(response, this.httpHeaders);
            IO.copyFileB((File)this.netcdfResult, (OutputStream)response.getOutputStream(), (int)60000);
            response.flushBuffer();
            response.getOutputStream().close();
            response.setStatus(200);
            log.info(UsageLog.closingMessageForRequestContext(200, -1L));
        }
    }

    private void spatialSubset(GridDataRequestParamsBean params, HttpServletResponse response) throws RequestTooLargeException, OutOfBoundariesException, InvalidRangeException, ParseException, IOException, VariableNotContainedInDatasetException, InvalidBBOXException, TimeOutOfWindowException {
        boolean hasBB;
        LatLonRect maxBB = this.getGridDataset().getBoundingBox();
        LatLonRect requestedBB = this.setBBForRequest(params, this.gridDataset);
        boolean bl = hasBB = !Misc.closeEnough((double)requestedBB.getUpperRightPoint().getLatitude(), (double)maxBB.getUpperRightPoint().getLatitude()) || !Misc.closeEnough((double)requestedBB.getLowerLeftPoint().getLatitude(), (double)maxBB.getLowerLeftPoint().getLatitude()) || !Misc.closeEnough((double)requestedBB.getUpperRightPoint().getLongitude(), (double)maxBB.getUpperRightPoint().getLongitude()) || !Misc.closeEnough((double)requestedBB.getLowerLeftPoint().getLongitude(), (double)maxBB.getLowerLeftPoint().getLongitude());
        if (this.checkBB(maxBB, requestedBB)) {
            long estimatedSize;
            Range zRange = null;
            if (params.getVertCoord() != null || params.getVertStride() > 1) {
                zRange = this.getZRange(this.getGridDataset(), params.getVertCoord(), params.getVertStride(), params.getVar());
            }
            List<CalendarDate> wantedDates = this.getRequestedDates(this.gridDataset, params);
            CalendarDateRange wantedDateRange = CalendarDateRange.of((CalendarDate)wantedDates.get(0), (CalendarDate)wantedDates.get(wantedDates.size() - 1));
            NetcdfCFWriter writer = new NetcdfCFWriter();
            this.maxFileDownloadSize = ThreddsConfig.getBytes("NetcdfSubsetService.maxFileDownloadSize", -1L);
            if (this.maxFileDownloadSize > 0L && (estimatedSize = writer.makeGridFileSizeEstimate(this.getGridDataset(), params.getVar(), (LatLonRect)(hasBB ? requestedBB : null), params.getHorizStride().intValue(), zRange, wantedDateRange, params.getTimeStride().intValue(), params.isAddLatLon())) > this.maxFileDownloadSize) {
                throw new RequestTooLargeException("NCSS request too large = " + estimatedSize + " max = " + this.maxFileDownloadSize);
            }
            this.makeGridFile(writer, this.getGridDataset(), params.getVar(), (LatLonRect)(hasBB ? requestedBB : null), params.getHorizStride(), zRange, wantedDateRange, params.getTimeStride(), params.isAddLatLon());
        }
    }

    private void coordinatesSubset(GridDataRequestParamsBean params, HttpServletResponse response) throws OutOfBoundariesException, ParseException, InvalidRangeException, RequestTooLargeException, IOException, InvalidBBOXException, TimeOutOfWindowException {
        long estimatedSize;
        Double minx = params.getMinx();
        Double maxx = params.getMaxx();
        Double miny = params.getMiny();
        Double maxy = params.getMaxy();
        int contValid = 0;
        if (minx != null) {
            ++contValid;
        }
        if (maxx != null) {
            ++contValid;
        }
        if (miny != null) {
            ++contValid;
        }
        if (maxy != null) {
            ++contValid;
        }
        if (contValid == 4) {
            if (minx > maxx) {
                throw new InvalidBBOXException("Invalid bbox. Bounding Box must have minx < maxx");
            }
            if (miny > maxy) {
                throw new InvalidBBOXException("Invalid bbox. Bounding Box must have miny < maxy");
            }
        } else {
            throw new InvalidBBOXException("Invalid bbox. All params minx, maxx. miny, maxy must be provided");
        }
        ProjectionRect rect = new ProjectionRect(minx.doubleValue(), miny.doubleValue(), maxx.doubleValue(), maxy.doubleValue());
        Range zRange = null;
        if (params.getVertCoord() != null || params.getVertStride() > 1) {
            zRange = this.getZRange(this.getGridDataset(), params.getVertCoord(), params.getVertStride(), params.getVar());
        }
        List<CalendarDate> wantedDates = this.getRequestedDates(this.gridDataset, params);
        CalendarDateRange wantedDateRange = CalendarDateRange.of((CalendarDate)wantedDates.get(0), (CalendarDate)wantedDates.get(wantedDates.size() - 1));
        NetcdfCFWriter writer = new NetcdfCFWriter();
        this.maxFileDownloadSize = ThreddsConfig.getBytes("NetcdfSubsetService.maxFileDownloadSize", -1L);
        if (this.maxFileDownloadSize > 0L && (estimatedSize = writer.makeGridFileSizeEstimate(this.getGridDataset(), params.getVar(), rect, params.getHorizStride().intValue(), zRange, wantedDateRange, params.getTimeStride().intValue(), params.isAddLatLon())) > this.maxFileDownloadSize) {
            throw new RequestTooLargeException("NCSS request too large = " + estimatedSize + " max = " + this.maxFileDownloadSize);
        }
        String filename = this.gridDataset.getLocationURI();
        int pos = filename.lastIndexOf("/");
        if (!(filename = filename.substring(pos + 1)).endsWith(".nc")) {
            filename = filename + ".nc";
        }
        Random random = new Random(System.currentTimeMillis());
        int randomInt = random.nextInt();
        String pathname = Integer.toString(randomInt) + "/" + filename;
        File ncFile = NcssDiskCache.getInstance().getDiskCache().getCacheFile(pathname);
        String cacheFilename = ncFile.getPath();
        String url = GridDataController.buildCacheUrl(pathname);
        this.httpHeaders.set("Content-Location", url);
        this.httpHeaders.set("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        writer.makeFile(cacheFilename, this.gridDataset, params.getVar(), rect, params.getHorizStride().intValue(), zRange, wantedDateRange, 1, params.isAddLatLon());
        this.netcdfResult = new File(cacheFilename);
    }

    @Override
    protected void checkRequestedVars(GridDataset gds, RequestParamsBean params) throws VariableNotContainedInDatasetException, UnsupportedOperationException {
        if (params.getVar().get(0).equals("all")) {
            params.setVar(NcssRequestUtils.getAllVarsAsList(this.getGridDataset()));
        }
        boolean checkVertLevels = params.getVertCoord() != null;
        Iterator<String> it = params.getVar().iterator();
        String varName = it.next();
        GridDatatype grid = gds.findGridByShortName(varName);
        if (grid == null) {
            throw new VariableNotContainedInDatasetException("Variable: " + varName + " is not contained in the requested dataset");
        }
        CoordinateAxis1D vertAxis = grid.getCoordinateSystem().getVerticalAxis();
        CoordinateAxis1D newVertAxis = null;
        boolean sameVertCoord = true;
        while (sameVertCoord && it.hasNext()) {
            varName = it.next();
            grid = gds.findGridByShortName(varName);
            if (grid == null) {
                throw new VariableNotContainedInDatasetException("Variable: " + varName + " is not contained in the requested dataset");
            }
            if (!checkVertLevels) continue;
            newVertAxis = grid.getCoordinateSystem().getVerticalAxis();
            if (vertAxis != null) {
                if (vertAxis.equals((Object)newVertAxis)) {
                    vertAxis = newVertAxis;
                    continue;
                }
                sameVertCoord = false;
                continue;
            }
            if (newVertAxis == null) continue;
            sameVertCoord = false;
        }
        if (!sameVertCoord) {
            throw new UnsupportedOperationException("The variables requested: " + params.getVar() + " have different vertical levels. Grid requests with vertCoord must have variables with same vertical levels.");
        }
    }

    private boolean isSpatialSubset(GridDataRequestParamsBean params) throws InvalidBBOXException {
        boolean spatialSubset = false;
        int contValid = 0;
        if (params.getNorth() != null) {
            ++contValid;
        }
        if (params.getSouth() != null) {
            ++contValid;
        }
        if (params.getEast() != null) {
            ++contValid;
        }
        if (params.getWest() != null) {
            ++contValid;
        }
        if (contValid == 4) {
            if (params.getNorth() < params.getSouth()) {
                throw new InvalidBBOXException("Invalid bbox. Bounding Box must have north > south");
            }
            if (params.getEast() < params.getWest()) {
                throw new InvalidBBOXException("Invalid bbox. Bounding Box must have east > west; if crossing 180 meridian, use east boundary > 180");
            }
            spatialSubset = true;
        } else {
            if (contValid > 0) {
                throw new InvalidBBOXException("Invalid bbox. All params north, south, east and west must be provided");
            }
            if (params.getMaxx() == null && params.getMinx() == null && params.getMaxy() == null && params.getMiny() == null) {
                spatialSubset = true;
            }
        }
        return spatialSubset;
    }

    private boolean checkBB(LatLonRect maxBB, LatLonRect requestedBB) throws OutOfBoundariesException {
        boolean isInBB = true;
        LatLonRect intersect = maxBB.intersect(requestedBB);
        if (intersect == null) {
            throw new OutOfBoundariesException("Request Bounding Box does not intersect the Data. Data Bounding Box = " + maxBB.toString2());
        }
        return isInBB;
    }

    private LatLonRect setBBForRequest(GridDataRequestParamsBean params, GridDataset gds) throws InvalidBBOXException {
        if (params.getNorth() == null && params.getSouth() == null && params.getWest() == null && params.getEast() == null) {
            return gds.getBoundingBox();
        }
        return new LatLonRect((LatLonPoint)new LatLonPointImpl(params.getSouth().doubleValue(), params.getWest().doubleValue()), (LatLonPoint)new LatLonPointImpl(params.getNorth().doubleValue(), params.getEast().doubleValue()));
    }

    private Range getZRange(GridDataset gds, Double verticalCoord, Integer vertStride, List<String> vars) throws OutOfBoundariesException {
        boolean hasVerticalCoord = false;
        Range zRange = null;
        if (verticalCoord != null) {
            boolean bl = hasVerticalCoord = !Double.isNaN(verticalCoord);
            if (hasVerticalCoord) {
                try {
                    for (String varName : vars) {
                        GridDatatype grid = gds.findGridDatatype(varName);
                        GridCoordSystem gcs = grid.getCoordinateSystem();
                        CoordinateAxis1D vaxis = gcs.getVerticalAxis();
                        if (vaxis == null || vaxis.getSize() <= 1L) continue;
                        int bestIndex = -1;
                        double bestDiff = Double.MAX_VALUE;
                        int i = 0;
                        while ((long)i < vaxis.getSize()) {
                            double diff = Math.abs(vaxis.getCoordValue(i) - verticalCoord);
                            if (diff < bestDiff) {
                                bestIndex = i;
                                bestDiff = diff;
                            }
                            ++i;
                        }
                        if (bestIndex < 0) continue;
                        zRange = new Range(bestIndex, bestIndex);
                    }
                }
                catch (InvalidRangeException ire) {
                    throw new OutOfBoundariesException("Invalid vertical level: " + ire.getMessage());
                }
            }
        } else if (vertStride > 1) {
            try {
                zRange = new Range(0, 0, vertStride.intValue());
                for (String varName : vars) {
                    GridDatatype grid = gds.findGridDatatype(varName);
                    GridCoordSystem gcs = grid.getCoordinateSystem();
                    CoordinateAxis1D vaxis = gcs.getVerticalAxis();
                    if (vaxis == null) continue;
                    zRange = new Range(zRange.first(), (long)zRange.last() > vaxis.getSize() ? zRange.last() : (int)vaxis.getSize() - 1, vertStride.intValue());
                }
            }
            catch (InvalidRangeException ire) {
                throw new OutOfBoundariesException("Invalid vertical stride: " + ire.getMessage());
            }
        }
        return zRange;
    }

    private void makeGridFile(NetcdfCFWriter writer, GridDataset gds, List<String> vars, LatLonRect bbox, Integer horizStride, Range zRange, CalendarDateRange dateRange, Integer timeStride, boolean addLatLon) throws RequestTooLargeException, InvalidRangeException, IOException {
        String filename = gds.getLocationURI();
        int pos = filename.lastIndexOf("/");
        if (!(filename = filename.substring(pos + 1)).endsWith(".nc")) {
            filename = filename + ".nc";
        }
        Random random = new Random(System.currentTimeMillis());
        int randomInt = random.nextInt();
        String pathname = Integer.toString(randomInt) + "/" + filename;
        File ncFile = NcssDiskCache.getInstance().getDiskCache().getCacheFile(pathname);
        String cacheFilename = ncFile.getPath();
        String url = GridDataController.buildCacheUrl(pathname);
        this.httpHeaders.set("Content-Type", "application/x-netcdf");
        this.httpHeaders.set("Content-Location", url);
        this.httpHeaders.set("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        try {
            writer.makeFile(cacheFilename, gds, vars, bbox, horizStride.intValue(), zRange, dateRange, timeStride.intValue(), addLatLon);
        }
        catch (IllegalArgumentException e) {
            throw new RequestTooLargeException("Request too large", e);
        }
        this.netcdfResult = new File(cacheFilename);
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public String handle(RequestTooLargeException rtle) {
        log.info(UsageLog.closingMessageForRequestContext(403, 0L));
        return "NetCDF Subset Service exception handled : " + rtle.getMessage();
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public String handle(NcssException ncsse) {
        log.info(UsageLog.closingMessageForRequestContext(400, 0L));
        return "NetCDF Subset Service exception handled : " + ncsse.getMessage();
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public String handle(IOException ioe) {
        log.info(UsageLog.closingMessageForRequestContext(500, 0L));
        return "I/O xception handled : " + ioe.getMessage();
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public String handle(InvalidRangeException ire) {
        log.info(UsageLog.closingMessageForRequestContext(500, 0L));
        return "Invalid Range Exception handled (Invalid Lat/Lon or Time Range): " + ire.getMessage();
    }
}

