/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset.view;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import thredds.server.ncSubset.controller.AbstractNcssController;
import thredds.server.ncSubset.controller.NcssDiskCache;
import thredds.server.ncSubset.view.PointDataWriter;
import thredds.server.ncSubset.view.netcdf.CFPointWriterWrapper;
import thredds.server.ncSubset.view.netcdf.CFPointWriterWrapperFactory;
import ucar.nc2.Attribute;
import ucar.nc2.constants.CF;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.IO;
import ucar.unidata.geoloc.LatLonPoint;

public class NetCDFPointDataWriter
implements PointDataWriter {
    private static Logger log = LoggerFactory.getLogger(NetCDFPointDataWriter.class);
    private OutputStream outputStream;
    private DiskCache2 diskCache;
    private File netcdfResult;
    private CF.FeatureType featureType;
    private CFPointWriterWrapper pointWriterWrapper;
    private HttpHeaders httpHeaders = new HttpHeaders();

    private NetCDFPointDataWriter(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.diskCache = NcssDiskCache.getInstance().getDiskCache();
        this.netcdfResult = this.diskCache.createUniqueFile("ncss", ".nc");
    }

    public static NetCDFPointDataWriter createNetCDFPointDataWriter(OutputStream outputStream) {
        return new NetCDFPointDataWriter(outputStream);
    }

    @Override
    public boolean header(Map<String, List<String>> groupedVars, GridDataset gridDataset, List<CalendarDate> wDates, DateUnit dateUnit, LatLonPoint point) {
        ArrayList<String> keys;
        List<String> varsForRequest;
        CoordinateAxis1D zAxis;
        boolean headerDone = false;
        this.featureType = groupedVars.size() > 1 ? CF.FeatureType.profile : ((zAxis = gridDataset.findGridDatatype((varsForRequest = groupedVars.get((keys = new ArrayList<String>(groupedVars.keySet())).get(0))).get(0)).getCoordinateSystem().getVerticalAxis()) == null ? CF.FeatureType.timeSeries : CF.FeatureType.point);
        try {
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            atts.add(new Attribute("title", "Extract Points data from Grid file " + gridDataset.getLocationURI()));
            this.pointWriterWrapper = CFPointWriterWrapperFactory.getWriterForFeatureType(this.featureType, this.netcdfResult.getAbsolutePath(), atts);
            headerDone = this.pointWriterWrapper.header(groupedVars, gridDataset, wDates, dateUnit, point);
        }
        catch (IOException ioe) {
            log.error("Error writing header", (Throwable)ioe);
        }
        return headerDone;
    }

    @Override
    public boolean write(Map<String, List<String>> groupedVars, GridDataset gridDataset, CalendarDate date, LatLonPoint point, Double targetLevel) {
        boolean allWrite = this.pointWriterWrapper.write(groupedVars, gridDataset, date, point, targetLevel);
        if (allWrite) {
            this.setHeaders(gridDataset);
        }
        return allWrite;
    }

    @Override
    public boolean trailer() {
        boolean allDone = false;
        this.pointWriterWrapper.trailer();
        try {
            IO.copyFileB((File)this.netcdfResult, (OutputStream)this.outputStream, (int)60000);
            allDone = true;
        }
        catch (IOException ioe) {
            log.error("Error copying result to the output stream", (Throwable)ioe);
        }
        return allDone;
    }

    @Override
    public HttpHeaders getResponseHeaders() {
        return this.httpHeaders;
    }

    private void setHeaders(GridDataset gridDataset) {
        String filename = gridDataset.getLocationURI();
        int pos = filename.lastIndexOf("/");
        if (!(filename = filename.substring(pos + 1)).endsWith(".nc")) {
            filename = filename + ".nc";
        }
        String url = AbstractNcssController.buildCacheUrl(this.netcdfResult.getName());
        this.httpHeaders.set("Content-Location", url);
        this.httpHeaders.set("Content-Disposition", "attachment; filename=\"" + filename + "\"");
    }
}

