/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset.view;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import thredds.server.ncSubset.util.NcssRequestUtils;
import thredds.server.ncSubset.view.PointDataWriter;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridAsPointDataset;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonPoint;

class XMLPointDataWriter
implements PointDataWriter {
    private static Logger log = LoggerFactory.getLogger(XMLPointDataWriter.class);
    private XMLStreamWriter xmlStreamWriter;

    private XMLPointDataWriter(OutputStream os) {
        this.xmlStreamWriter = this.createXMLStreamWriter(os);
    }

    public static XMLPointDataWriter createXMLPointDataWriter(OutputStream os) {
        return new XMLPointDataWriter(os);
    }

    @Override
    public boolean header(Map<String, List<String>> vars, GridDataset gridDataset, List<CalendarDate> wDates, DateUnit dateUnit, LatLonPoint point) {
        boolean headerWritten = false;
        try {
            this.xmlStreamWriter.writeStartDocument("UTF-8", "1.0");
            this.xmlStreamWriter.writeStartElement("grid");
            this.xmlStreamWriter.writeAttribute("dataset", gridDataset.getLocationURI());
            headerWritten = true;
        }
        catch (XMLStreamException xse) {
            log.error("Error writting xml header", (Throwable)xse);
        }
        return headerWritten;
    }

    @Override
    public boolean write(Map<String, List<String>> groupedVars, GridDataset gridDataset, CalendarDate date, LatLonPoint point, Double targetLevel) {
        boolean allDone = true;
        ArrayList<String> keys = new ArrayList<String>(groupedVars.keySet());
        for (String key : keys) {
            List<String> varsGroup = groupedVars.get(key);
            GridAsPointDataset gap = NcssRequestUtils.buildGridAsPointDataset(gridDataset, varsGroup);
            CoordinateAxis1D verticalAxisForGroup = gridDataset.findGridDatatype(varsGroup.get(0)).getCoordinateSystem().getVerticalAxis();
            if (verticalAxisForGroup == null) {
                allDone = allDone && this.write(varsGroup, gridDataset, gap, date, point);
                continue;
            }
            if (targetLevel != null) {
                Double vertCoord = NcssRequestUtils.getTargetLevelForVertCoord(verticalAxisForGroup, targetLevel);
                allDone = this.write(varsGroup, gridDataset, gap, date, point, vertCoord, verticalAxisForGroup.getUnitsString());
                continue;
            }
            double[] arr$ = verticalAxisForGroup.getCoordValues();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Double vertCoord = arr$[i$];
                if (verticalAxisForGroup.getCoordValues().length == 1) {
                    vertCoord = NcssRequestUtils.getTargetLevelForVertCoord(verticalAxisForGroup, vertCoord);
                }
                allDone = allDone && this.write(varsGroup, gridDataset, gap, date, point, vertCoord, verticalAxisForGroup.getUnitsString());
            }
        }
        return allDone;
    }

    private boolean write(List<String> vars, GridDataset gridDataset, GridAsPointDataset gap, CalendarDate date, LatLonPoint point, Double targetLevel, String zUnits) {
        Iterator<String> itVars = vars.iterator();
        boolean pointDone = false;
        try {
            this.xmlStreamWriter.writeStartElement("point");
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("name", "date");
            this.writeDataTag(this.xmlStreamWriter, attributes, date.toString());
            attributes.clear();
            int contVars = 0;
            while (itVars.hasNext()) {
                String varName = itVars.next();
                GridDatatype grid = gridDataset.findGridDatatype(varName);
                if (gap.hasTime(grid, date) && gap.hasVert(grid, targetLevel.doubleValue())) {
                    GridAsPointDataset.Point p = gap.readData(grid, date, targetLevel.doubleValue(), point.getLatitude(), point.getLongitude());
                    if (contVars == 0) {
                        this.writeCoordinates(this.xmlStreamWriter, p.lat, p.lon);
                        attributes.put("name", "vertCoord");
                        attributes.put("units", zUnits);
                        this.writeDataTag(this.xmlStreamWriter, attributes, Double.valueOf(p.z).toString());
                        attributes.clear();
                    }
                    attributes.put("name", varName);
                    attributes.put("units", grid.getUnitsString());
                    this.writeDataTag(this.xmlStreamWriter, attributes, Double.valueOf(p.dataValue).toString());
                    attributes.clear();
                } else {
                    if (contVars == 0) {
                        this.writeCoordinates(this.xmlStreamWriter, point.getLatitude(), point.getLongitude());
                    }
                    attributes.put("name", varName);
                    attributes.put("units", grid.getUnitsString());
                    this.writeDataTag(this.xmlStreamWriter, attributes, Double.valueOf(gap.getMissingValue(grid)).toString());
                    attributes.clear();
                }
                ++contVars;
            }
            this.xmlStreamWriter.writeEndElement();
            pointDone = true;
        }
        catch (XMLStreamException xse) {
            log.error("Error writting tag point", (Throwable)xse);
        }
        catch (IOException ioe) {
            log.error("Error reading point data", (Throwable)ioe);
        }
        return pointDone;
    }

    private boolean write(List<String> vars, GridDataset gridDataset, GridAsPointDataset gap, CalendarDate date, LatLonPoint point) {
        Iterator<String> itVars = vars.iterator();
        boolean pointDone = false;
        try {
            this.xmlStreamWriter.writeStartElement("point");
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("name", "date");
            this.writeDataTag(this.xmlStreamWriter, attributes, date.toString());
            attributes.clear();
            int contVars = 0;
            while (itVars.hasNext()) {
                String varName = itVars.next();
                GridDatatype grid = gridDataset.findGridDatatype(varName);
                if (gap.hasTime(grid, date)) {
                    GridAsPointDataset.Point p = gap.readData(grid, date, point.getLatitude(), point.getLongitude());
                    if (contVars == 0) {
                        this.writeCoordinates(this.xmlStreamWriter, p.lat, p.lon);
                        attributes.clear();
                    }
                    attributes.put("name", varName);
                    attributes.put("units", grid.getUnitsString());
                    this.writeDataTag(this.xmlStreamWriter, attributes, Double.valueOf(p.dataValue).toString());
                    attributes.clear();
                } else {
                    if (contVars == 0) {
                        this.writeCoordinates(this.xmlStreamWriter, point.getLatitude(), point.getLongitude());
                    }
                    attributes.put("name", varName);
                    attributes.put("units", grid.getUnitsString());
                    this.writeDataTag(this.xmlStreamWriter, attributes, Double.valueOf(gap.getMissingValue(grid)).toString());
                    attributes.clear();
                }
                ++contVars;
            }
            this.xmlStreamWriter.writeEndElement();
            pointDone = true;
        }
        catch (XMLStreamException xse) {
            log.error("Error writting tag point", (Throwable)xse);
        }
        catch (IOException ioe) {
            log.error("Error reading point data", (Throwable)ioe);
        }
        return pointDone;
    }

    @Override
    public boolean trailer() {
        boolean endDocument = false;
        try {
            this.xmlStreamWriter.writeEndElement();
            this.xmlStreamWriter.writeEndDocument();
            endDocument = true;
        }
        catch (XMLStreamException xse) {
            log.error("Error writing end document", (Throwable)xse);
        }
        return endDocument;
    }

    @Override
    public HttpHeaders getResponseHeaders() {
        return new HttpHeaders();
    }

    private XMLStreamWriter createXMLStreamWriter(OutputStream os) {
        XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
        XMLStreamWriter writer = null;
        try {
            writer = outputFactory.createXMLStreamWriter(os, "UTF-8");
        }
        catch (XMLStreamException xse) {
            log.error(xse.getMessage());
        }
        return writer;
    }

    private void writeDataTag(XMLStreamWriter writer, Map<String, String> attributes, String content) throws XMLStreamException {
        writer.writeStartElement("data");
        Set<String> attNames = attributes.keySet();
        for (String attName : attNames) {
            writer.writeAttribute(attName, attributes.get(attName));
        }
        writer.writeCharacters(content);
        writer.writeEndElement();
    }

    private void writeCoordinates(XMLStreamWriter writer, Double lat, Double lon) throws XMLStreamException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("name", "lat");
        attributes.put("units", "degrees_north");
        this.writeDataTag(writer, attributes, lat.toString());
        attributes.clear();
        attributes.put("name", "lon");
        attributes.put("units", "degrees_east");
        this.writeDataTag(writer, attributes, lon.toString());
        attributes.clear();
    }
}

