/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.root;

import java.io.File;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import thredds.server.config.TdsContext;
import thredds.servlet.DataRootHandler;
import thredds.servlet.HtmlWriter;
import thredds.servlet.UsageLog;
import thredds.util.RequestForwardUtils;

public class DirDisplayController
extends AbstractController {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private TdsContext tdsContext;
    private HtmlWriter htmlWriter;

    public void setTdsContext(TdsContext tdsContext) {
        this.tdsContext = tdsContext;
    }

    public void setHtmlWriter(HtmlWriter htmlWriter) {
        this.htmlWriter = htmlWriter;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest req, HttpServletResponse res) throws Exception {
        this.log.info("handleRequestInternal(): " + UsageLog.setupRequestContext(req));
        String path = req.getPathInfo();
        if (path == null) {
            path = "";
        }
        if (path.indexOf("/../") != -1 || path.equals("..") || path.startsWith("../") || path.endsWith("/..")) {
            res.sendError(403, "Path cannot contain ..");
            this.log.info(UsageLog.closingMessageForRequestContext(403, -1L));
            return null;
        }
        File file = null;
        if (path.startsWith("/content/")) {
            file = new File(this.tdsContext.getContentDirectory(), path.substring(9));
            if (!file.exists()) {
                file = this.tdsContext.getConfigFileSource().getFile(path.substring(9));
            }
        } else if (path.startsWith("/logs/")) {
            file = new File(this.tdsContext.getTomcatLogDirectory(), path.substring(6));
        } else if (path.startsWith("/dataDir/")) {
            String root = path.substring(9);
            file = DataRootHandler.getInstance().getCrawlableDatasetAsFile(root);
        }
        if (file == null) {
            RequestForwardUtils.forwardRequest(path, this.tdsContext.getDefaultRequestDispatcher(), req, res);
            return null;
        }
        if (file.isDirectory()) {
            int i = this.htmlWriter.writeDirectory(res, file, path);
            int status = i == 0 ? 404 : 200;
            this.log.info("handleRequestInternal(): " + UsageLog.closingMessageForRequestContext(status, i));
            return null;
        }
        return new ModelAndView("threddsFileView", "file", (Object)file);
    }
}

