/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wcs.v1_0_0_Plus;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.wcs.VersionHandler;
import thredds.server.wcs.v1_0_0_Plus.WcsRequestParser;
import thredds.servlet.ServletUtil;
import thredds.servlet.UsageLog;
import thredds.util.Version;
import thredds.wcs.v1_0_0_Plus.DescribeCoverage;
import thredds.wcs.v1_0_0_Plus.ExceptionReport;
import thredds.wcs.v1_0_0_Plus.GetCapabilities;
import thredds.wcs.v1_0_0_Plus.GetCoverage;
import thredds.wcs.v1_0_0_Plus.WcsCoverage;
import thredds.wcs.v1_0_0_Plus.WcsException;
import thredds.wcs.v1_0_0_Plus.WcsRequest;
import ucar.nc2.util.DiskCache2;

public class WcsHandler
implements VersionHandler {
    private static Logger log = LoggerFactory.getLogger(WcsHandler.class);
    private Version version;
    private boolean deleteImmediately = true;

    public WcsHandler(String versionString) {
        this.version = new Version(versionString);
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public VersionHandler setDiskCache(DiskCache2 diskCache) {
        WcsCoverage.setDiskCache((DiskCache2)diskCache);
        return this;
    }

    @Override
    public VersionHandler setDeleteImmediately(boolean deleteImmediately) {
        this.deleteImmediately = deleteImmediately;
        return this;
    }

    @Override
    public void handleKVP(HttpServlet servlet, HttpServletRequest req, HttpServletResponse res) throws IOException {
        block9: {
            try {
                URI serverURI = new URI(req.getRequestURL().toString());
                WcsRequest request = WcsRequestParser.parseRequest(this.getVersion().getVersionString(), serverURI, req, res);
                if (request.getOperation().equals((Object)WcsRequest.Operation.GetCapabilities)) {
                    res.setContentType("text/xml");
                    res.setStatus(200);
                    log.info(UsageLog.closingMessageForRequestContext(200, -1L));
                    PrintWriter pw = res.getWriter();
                    ((GetCapabilities)request).writeCapabilitiesReport(pw);
                    pw.flush();
                    break block9;
                }
                if (request.getOperation().equals((Object)WcsRequest.Operation.DescribeCoverage)) {
                    res.setContentType("text/xml");
                    res.setStatus(200);
                    log.info(UsageLog.closingMessageForRequestContext(200, -1L));
                    PrintWriter pw = res.getWriter();
                    ((DescribeCoverage)request).writeDescribeCoverageDoc(pw);
                    pw.flush();
                    break block9;
                }
                if (!request.getOperation().equals((Object)WcsRequest.Operation.GetCoverage)) break block9;
                File covFile = ((GetCoverage)request).writeCoverageDataToFile();
                if (covFile != null && covFile.exists()) {
                    int pos = covFile.getPath().lastIndexOf(".");
                    String suffix = covFile.getPath().substring(pos);
                    String resultFilename = request.getDataset().getDatasetName();
                    if (!resultFilename.endsWith(suffix)) {
                        resultFilename = resultFilename + suffix;
                    }
                    res.setHeader("Content-Disposition", "attachment; filename=\"" + resultFilename + "\"");
                    ServletUtil.returnFile(servlet, "", covFile.getPath(), req, res, ((GetCoverage)request).getFormat().getMimeType());
                    if (this.deleteImmediately) {
                        covFile.delete();
                    }
                    break block9;
                }
                log.error("handleKVP(): Failed to create coverage file" + (covFile == null ? "" : ": " + covFile.getAbsolutePath()));
                throw new WcsException("Problem creating requested coverage.");
            }
            catch (WcsException e) {
                this.handleExceptionReport(res, e);
            }
            catch (URISyntaxException e) {
                this.handleExceptionReport(res, new WcsException("Bad URI: " + e.getMessage()));
            }
            catch (Throwable t) {
                log.error("Unknown problem.", t);
                this.handleExceptionReport(res, new WcsException("Unknown problem", t));
            }
        }
    }

    public GetCapabilities.ServiceInfo getServiceInfo() {
        GetCapabilities.ResponsibleParty.ContactInfo contactInfo = new GetCapabilities.ResponsibleParty.ContactInfo(Collections.singletonList("voice phone"), Collections.singletonList("voice phone"), new GetCapabilities.ResponsibleParty.Address(Collections.singletonList("address"), "city", "admin area", "postal code", "country", Collections.singletonList("email")), new GetCapabilities.ResponsibleParty.OnlineResource(null, "title"));
        GetCapabilities.ResponsibleParty respParty = new GetCapabilities.ResponsibleParty("indiv name", "org name", "position", contactInfo);
        GetCapabilities.ServiceInfo sid = new GetCapabilities.ServiceInfo("name", "label", "description", Collections.singletonList("keyword"), respParty, "no fees", Collections.singletonList("no access constraints"));
        return sid;
    }

    public void handleExceptionReport(HttpServletResponse res, WcsException exception) throws IOException {
        res.setContentType("application/vnd.ogc.se_xml");
        res.setStatus(400);
        log.info(UsageLog.closingMessageForRequestContext(400, -1L));
        ExceptionReport exceptionReport = new ExceptionReport(exception);
        PrintWriter pw = res.getWriter();
        exceptionReport.writeExceptionReport(pw);
        pw.flush();
    }

    @Override
    public void handleExceptionReport(HttpServletResponse res, String code, String locator, String message) throws IOException {
        WcsException exception;
        try {
            WcsException.Code c = WcsException.Code.valueOf((String)code);
            exception = new WcsException(c, locator, message);
        }
        catch (IllegalArgumentException e) {
            exception = new WcsException(message);
            log.debug("handleExceptionReport(): bad code given <" + code + ">.");
        }
        this.handleExceptionReport(res, exception);
    }

    @Override
    public void handleExceptionReport(HttpServletResponse res, String code, String locator, Throwable t) throws IOException {
        this.handleExceptionReport(res, code, locator, t.getMessage());
        if (t instanceof FileNotFoundException) {
            log.info("handleExceptionReport", (Object)t.getMessage());
        } else {
            log.info("handleExceptionReport", t);
        }
    }
}

