/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wms;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.config.TdsContext;
import thredds.servlet.UsageLog;
import uk.ac.rdg.resc.ncwms.controller.ServerConfig;

public class ThreddsServerConfig
implements ServerConfig {
    private Logger logServerStartup = LoggerFactory.getLogger((String)"serverStartup");
    private TdsContext tdsContext;
    private String defaultPaletteLocation;

    private ThreddsServerConfig() {
    }

    public void setTdsContext(TdsContext tdsContext) {
        this.tdsContext = tdsContext;
    }

    public void setDefaultPaletteLocation(String defaultPaletteDirectory) {
        this.defaultPaletteLocation = defaultPaletteDirectory;
    }

    public File getPaletteFilesLocation(ServletContext context) {
        File defaultPaletteDir;
        if (this.getUserConfigPaletteLocationDir() != null && !this.getUserConfigPaletteLocationDir().trim().equals("")) {
            File userConfigPaletteDir = new File(this.getUserConfigPaletteLocationDir());
            if (userConfigPaletteDir.isAbsolute() ? userConfigPaletteDir.exists() && userConfigPaletteDir.isDirectory() : (userConfigPaletteDir = this.tdsContext.getConfigFileSource().getFile(this.getUserConfigPaletteLocationDir())) != null && userConfigPaletteDir.exists() && userConfigPaletteDir.isDirectory()) {
                return userConfigPaletteDir;
            }
            String msg = "User configured palette files location [" + this.getUserConfigPaletteLocationDir() + "] not available. Using default location [" + this.defaultPaletteLocation + "].";
            this.logServerStartup.warn(msg.toString());
        } else {
            String msg = "No user configured palette files location. Using default location [" + this.defaultPaletteLocation + "].";
            this.logServerStartup.debug(msg.toString());
        }
        if (this.defaultPaletteLocation != null && !this.defaultPaletteLocation.trim().equals("") && (defaultPaletteDir = new File(context.getRealPath(this.defaultPaletteLocation))) != null && defaultPaletteDir.exists() && defaultPaletteDir.isDirectory()) {
            return defaultPaletteDir;
        }
        this.setAllow(false);
        this.setAllowRemote(false);
        this.logServerStartup.error("Default palette location not available.\n**** Disabling WMS - Check palette configuration: " + UsageLog.closingMessageNonRequestContext());
        return null;
    }

    public boolean isAllow() {
        return this.tdsContext.getWmsConfig().isAllow();
    }

    public void setAllow(boolean allow) {
        this.tdsContext.getWmsConfig().setAllow(allow);
    }

    public boolean isAllowRemote() {
        return this.tdsContext.getWmsConfig().isAllowRemote();
    }

    public void setAllowRemote(boolean allowRemote) {
        this.tdsContext.getWmsConfig().setAllowRemote(allowRemote);
    }

    private String getUserConfigPaletteLocationDir() {
        return this.tdsContext.getWmsConfig().getPaletteLocationDir();
    }

    public TdsContext getTdsContext() {
        return this.tdsContext;
    }

    public DateTime getLastUpdateTime() {
        return new DateTime();
    }

    public String getTitle() {
        return this.tdsContext.getServerInfo().getName();
    }

    public int getMaxImageWidth() {
        return this.tdsContext.getWmsConfig().getMaxImageWidth();
    }

    public int getMaxImageHeight() {
        return this.tdsContext.getWmsConfig().getMaxImageHeight();
    }

    public String getServerAbstract() {
        return this.tdsContext.getServerInfo().getSummary();
    }

    public Set<String> getKeywords() {
        String[] keysArray = this.tdsContext.getServerInfo().getKeywords().split(",\\s*");
        LinkedHashSet<String> keywords = new LinkedHashSet<String>(keysArray.length);
        keywords.addAll(Arrays.asList(keysArray));
        return keywords;
    }

    public String getServiceProviderUrl() {
        return this.tdsContext.getServerInfo().getHostInstitutionWebSite();
    }

    public String getContactName() {
        return this.tdsContext.getServerInfo().getContactName();
    }

    public String getContactOrganization() {
        return this.tdsContext.getServerInfo().getContactOrganization();
    }

    public String getContactTelephone() {
        return this.tdsContext.getServerInfo().getContactPhone();
    }

    public String getContactEmail() {
        return this.tdsContext.getServerInfo().getContactEmail();
    }
}

