/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.dl.ADNWriter;
import thredds.catalog.dl.DIFWriter;
import thredds.servlet.AbstractServlet;
import thredds.servlet.HtmlWriter;
import thredds.servlet.ServletUtil;
import thredds.servlet.ThreddsConfig;
import thredds.servlet.UsageLog;
import ucar.nc2.util.IO;
import ucar.unidata.util.StringUtil2;

public class DLwriterServlet
extends AbstractServlet {
    private String adnDir;
    private String difDir;
    private boolean allow;
    private boolean allowRemote;

    @Override
    public void init() throws ServletException {
        super.init();
        this.allow = ThreddsConfig.getBoolean("DLwriter.allow", false);
        if (!this.allow) {
            this.logServerStartup.info("DLwriterServlet.init(): DLwriter service not enabled in threddsConfig.xml: " + UsageLog.closingMessageNonRequestContext());
            return;
        }
        this.allowRemote = ThreddsConfig.getBoolean("DLwriter.allowRemote", false);
        this.adnDir = this.contentPath + "/adn/";
        this.difDir = this.contentPath + "/dif/";
        File file = new File(this.adnDir);
        file.mkdirs();
        file = new File(this.difDir);
        file.mkdirs();
        this.logServerStartup.info("DLwriterServlet.init() - done: " + UsageLog.closingMessageNonRequestContext());
    }

    @Override
    protected String getPath() {
        return "DLwriter/";
    }

    @Override
    protected void makeDebugActions() {
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.log.info(UsageLog.setupRequestContext(req));
        if (!this.allow) {
            res.sendError(403, "DLwriter service not supported");
            this.log.debug("doGet(): DLwriter service not enabled in threddsConfig.xml.");
            this.log.info("doGet(): " + UsageLog.closingMessageForRequestContext(403, -1L));
            return;
        }
        try {
            String type = req.getParameter("type");
            String catURL = req.getParameter("catalog");
            if (catURL == null || catURL.length() == 0) {
                catURL = ServletUtil.getContextPath() + "/idd/models.xml";
            }
            URI catUri = null;
            try {
                catUri = new URI(catURL);
            }
            catch (URISyntaxException e) {
                res.sendError(403, "Given catalog URL not a URL.");
                this.log.debug("doGet(): Given catalog URL not a URL", (Throwable)e);
                this.log.info("doGet(): " + UsageLog.closingMessageForRequestContext(403, -1L));
                return;
            }
            if (catUri.isAbsolute() && !this.allowRemote) {
                res.sendError(403, "Given catalog URL not allowed (remote).");
                this.log.debug("doGet(): Given catalog URL was absolute, remote catalog handling not enabled.");
                this.log.info("doGet(): " + UsageLog.closingMessageForRequestContext(403, -1L));
                return;
            }
            boolean isDIF = type == null ? true : type.equals("DIF");
            this.doit(req, res, catURL, isDIF);
            this.log.info(UsageLog.closingMessageForRequestContext(403, -1L));
        }
        catch (Throwable t) {
            this.log.error("doGet(): req= " + ServletUtil.getRequest(req) + " got Exception", t);
            ServletUtil.handleException(t, res);
        }
    }

    private void doit(HttpServletRequest req, HttpServletResponse res, String catURL, boolean isDIF) throws IOException {
        DIFWriter writer;
        InvCatalogImpl catalog;
        URI catURI;
        try {
            URI reqURI = new URI(req.getRequestURL().toString());
            catURI = reqURI.resolve(catURL);
        }
        catch (URISyntaxException e) {
            res.sendError(403, "Given catalog URL not a URL.");
            this.log.debug("doGet(): Given catalog URL not a URL", (Throwable)e);
            this.log.info("doGet(): " + UsageLog.closingMessageForRequestContext(403, -1L));
            return;
        }
        InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory((boolean)false);
        try {
            catalog = catFactory.readXML(catURI);
        }
        catch (Exception e) {
            ServletUtil.handleException(e, res);
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (!catalog.check(sb, false)) {
            this.log.info(UsageLog.closingMessageForRequestContext(400, -1L));
            res.setContentType("text/html");
            res.setHeader("Validate", "FAIL");
            PrintWriter pw = new PrintWriter((OutputStream)res.getOutputStream());
            this.showValidationMesssage(catURI.toString(), sb.toString(), pw);
            pw.flush();
            return;
        }
        StringBuffer mess = new StringBuffer();
        mess.append("Catalog " + catURI.toString() + "\n\n");
        if (isDIF) {
            mess.append("DIF records:\n");
            writer = new DIFWriter();
            writer.writeDatasetEntries(catalog, this.difDir, mess);
        } else {
            mess.append("ADN records:\n");
            writer = new ADNWriter();
            mess.setLength(0);
            writer.writeDatasetEntries(catalog, this.adnDir, mess);
        }
        res.setContentType("text/plain");
        ServletOutputStream out = res.getOutputStream();
        out.write(mess.toString().getBytes());
        out.flush();
        this.log.info(UsageLog.closingMessageForRequestContext(200, mess.length()));
    }

    private void showValidationMesssage(String catURL, String mess, PrintWriter pw) {
        pw.println(HtmlWriter.getInstance().getHtmlDoctypeAndOpenTag());
        pw.println("<head>");
        pw.println("<title> Catalog Validation</title>");
        pw.println("<meta http-equiv=\"Content-Type\" content=\"text/html\">");
        pw.println("</head>");
        pw.println("<body bgcolor=\"#FFF0FF\">");
        pw.println("<h2> Catalog " + catURL + " has validation errors:</h2>");
        pw.println("<b>");
        pw.println(StringUtil2.quoteHtmlContent((String)mess));
        pw.println("</b>");
        pw.println("<hr><pre>");
        String catString = IO.readURLcontents((String)catURL);
        pw.println(StringUtil2.quoteHtmlContent((String)catString));
        pw.println("</pre>");
        pw.println("</body>");
        pw.println("</html>");
    }
}

