/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.servlet.HtmlWriter;
import thredds.servlet.UsageLog;

public class DebugHandler {
    private static Logger log = LoggerFactory.getLogger(DebugHandler.class);
    private static List<DebugHandler> dhList = new ArrayList<DebugHandler>();
    private Map<String, Action> actions = new LinkedHashMap<String, Action>();
    private String name;

    public static DebugHandler get(String name) {
        for (DebugHandler dh : dhList) {
            if (!name.equals(dh.name)) continue;
            return dh;
        }
        return new DebugHandler(name);
    }

    public static void doDebug(HttpServlet thisServlet, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/html");
        response.setHeader("Content-Description", "thredds_debug");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream pw = new PrintStream(bos);
        pw.println(HtmlWriter.getInstance().getHtmlDoctypeAndOpenTag());
        pw.println("<head>");
        pw.println("<title> THREDDS Debug</title>");
        pw.println("<meta http-equiv=\"Content-Type\" content=\"text/html\">");
        pw.println(HtmlWriter.getInstance().getTdsPageCssLink());
        pw.println("</head>");
        pw.println("<body>");
        pw.println(HtmlWriter.getInstance().getOldStyleHeader());
        pw.println("<br><a href='content/logs/'>Show TDS Logs</a>");
        pw.println("<br><a href='logs/'>Show Tomcat Logs</a>");
        pw.println("<h2>Debug Actions</h2>");
        pw.println("<pre>");
        String cmds = request.getQueryString();
        if (cmds == null || cmds.length() == 0) {
            DebugHandler.showDebugActions(request, response, pw);
        } else {
            StringTokenizer tz = new StringTokenizer(cmds, ";");
            while (tz.hasMoreTokens()) {
                DebugHandler dh;
                String cmd = tz.nextToken();
                String target = null;
                pw.println("Cmd= " + cmd);
                int pos = cmd.indexOf(47);
                String dhName = "General";
                if (pos > 0) {
                    dhName = cmd.substring(0, pos);
                    cmd = cmd.substring(pos + 1);
                }
                if ((pos = cmd.indexOf(61)) >= 0) {
                    target = cmd.substring(pos + 1);
                    cmd = cmd.substring(0, pos);
                }
                if ((dh = DebugHandler.find(dhName)) == null) {
                    pw.println(" Unknown DebugHandler=" + dhName + "=");
                    continue;
                }
                Action action = dh.actions.get(cmd);
                if (action == null) {
                    pw.println(" Unknown action=" + cmd + "=");
                    continue;
                }
                action.doAction(new Event(request, response, pw, bos, target));
            }
        }
        pw.println("</pre></body></html>");
        response.setStatus(200);
        byte[] result = bos.toByteArray();
        PrintStream responsePS = new PrintStream((OutputStream)response.getOutputStream());
        responsePS.write(result);
        responsePS.flush();
        log.info(UsageLog.closingMessageForRequestContext(200, result.length));
    }

    private static void showDebugActions(HttpServletRequest req, HttpServletResponse res, PrintStream pw) {
        for (DebugHandler dh : dhList) {
            pw.println("<h2>" + dh.name + "</h2>");
            for (Action act : dh.actions.values()) {
                if (act.desc == null) continue;
                String url = req.getRequestURI() + "?" + dh.name + "/" + act.name;
                pw.println("   <a href='" + url + "'>" + act.desc + "</a>");
            }
        }
    }

    private static DebugHandler find(String name) {
        for (DebugHandler dh : dhList) {
            if (!dh.name.equals(name)) continue;
            return dh;
        }
        return null;
    }

    private DebugHandler(String name) {
        this.name = name;
        dhList.add(this);
    }

    public void addAction(Action act) {
        this.actions.put(act.name, act);
    }

    public static class Event {
        public HttpServletRequest req;
        public HttpServletResponse res;
        public PrintStream pw;
        public ByteArrayOutputStream bos;
        public String target;

        public Event(HttpServletRequest req, HttpServletResponse res, PrintStream pw, ByteArrayOutputStream bos, String target) {
            this.req = req;
            this.res = res;
            this.pw = pw;
            this.bos = bos;
            this.target = target;
        }
    }

    public static abstract class Action {
        public String name;
        public String desc;
        public Object userObject;

        public Action(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        public Action(String name, String desc, Object userObject) {
            this.name = name;
            this.desc = desc;
            this.userObject = userObject;
        }

        public abstract void doAction(Event var1);
    }
}

