/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet.filter;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.servlet.UsageLog;
import thredds.util.StringValidateEncodeUtils;

public class ParameterValidationUtils {
    private static Logger log = LoggerFactory.getLogger(ParameterValidationUtils.class);

    private ParameterValidationUtils() {
    }

    public static boolean validateParameterAsSingleValueSingleLineString(HttpServletRequest request, HttpServletResponse response, String parameterName) throws IOException, ServletException {
        String[] parameterValues = request.getParameterValues(parameterName);
        if (parameterValues != null) {
            ParameterValidationUtils.validParameterAsSingleValue(response, parameterName, parameterValues);
            if (!StringValidateEncodeUtils.validSingleLineString(parameterValues[0])) {
                String msg = "Invalid parameter [" + parameterName + "] value [" + StringValidateEncodeUtils.encodeLogMessages(parameterValues[0]) + "].";
                log.error("validateParameterAsSingleValueSingleLineString(): " + msg);
                response.sendError(400, msg);
                log.info(UsageLog.closingMessageForRequestContext(400, msg.length()));
                return false;
            }
        }
        return true;
    }

    public static boolean validateParameterAsSingleValuePathString(HttpServletRequest request, HttpServletResponse response, String parameterName) throws IOException, ServletException {
        String[] parameterValues = request.getParameterValues(parameterName);
        if (parameterValues != null) {
            ParameterValidationUtils.validParameterAsSingleValue(response, parameterName, parameterValues);
            if (!StringValidateEncodeUtils.validPath(parameterValues[0]) || StringValidateEncodeUtils.containsAngleBracketCharacters(parameterValues[0]) || StringValidateEncodeUtils.containsBackslashCharacters(parameterValues[0])) {
                String msg = "Invalid parameter [" + parameterName + "] value [" + StringValidateEncodeUtils.encodeLogMessages(parameterValues[0]) + "].";
                log.error("validateParameterAsSingleValuePathString(): " + msg);
                response.sendError(400, msg);
                log.info(UsageLog.closingMessageForRequestContext(400, msg.length()));
                return false;
            }
        }
        return true;
    }

    public static boolean validateParameterAsSingleValueFilePathString(HttpServletRequest request, HttpServletResponse response, String parameterName) throws IOException, ServletException {
        String[] parameterValues = request.getParameterValues(parameterName);
        if (parameterValues != null) {
            ParameterValidationUtils.validParameterAsSingleValue(response, parameterName, parameterValues);
            if (!StringValidateEncodeUtils.validFilePath(parameterValues[0]) || StringValidateEncodeUtils.containsAngleBracketCharacters(parameterValues[0]) || StringValidateEncodeUtils.containsBackslashCharacters(parameterValues[0])) {
                String msg = "Invalid parameter [" + parameterName + "] value [" + StringValidateEncodeUtils.encodeLogMessages(parameterValues[0]) + "].";
                log.error("validateParameterAsSingleValueFilePathString(): " + msg);
                response.sendError(400, msg);
                log.info(UsageLog.closingMessageForRequestContext(400, msg.length()));
                return false;
            }
        }
        return true;
    }

    public static boolean validateParameterAsSingleValueAlphanumericString(HttpServletRequest request, HttpServletResponse response, String parameterName) throws IOException, ServletException {
        String[] parameterValues = request.getParameterValues(parameterName);
        if (parameterValues != null) {
            ParameterValidationUtils.validParameterAsSingleValue(response, parameterName, parameterValues);
            if (!StringValidateEncodeUtils.validAlphanumericString(parameterValues[0])) {
                String msg = "Invalid parameter [" + parameterName + "] value [" + StringValidateEncodeUtils.encodeLogMessages(parameterValues[0]) + "].";
                log.error("validateParameterAsSingleValueAlphanumericString(): " + msg);
                response.sendError(400, msg);
                log.info(UsageLog.closingMessageForRequestContext(400, msg.length()));
                return false;
            }
        }
        return true;
    }

    public static boolean validateParameterAsSingleValueAlphanumericStringConstrained(HttpServletRequest request, HttpServletResponse response, String parameterName, String[] constrainedSet, boolean ignoreCase) throws IOException, ServletException {
        String[] parameterValues = request.getParameterValues(parameterName);
        if (parameterValues != null) {
            ParameterValidationUtils.validParameterAsSingleValue(response, parameterName, parameterValues);
            if (!StringValidateEncodeUtils.validAlphanumericStringConstrainedSet(parameterValues[0], constrainedSet, ignoreCase)) {
                String msg = "Invalid parameter [" + parameterName + "] value [" + StringValidateEncodeUtils.encodeLogMessages(parameterValues[0]) + "].";
                log.error("validateParameterAsSingleValueAlphanumericStringConstrained(): " + msg);
                response.sendError(400, msg);
                log.info(UsageLog.closingMessageForRequestContext(400, msg.length()));
                return false;
            }
        }
        return true;
    }

    public static boolean validateParameterAsSingleValueUriString(HttpServletRequest request, HttpServletResponse response, String parameterName) throws IOException, ServletException {
        String[] parameterValues = request.getParameterValues(parameterName);
        if (parameterValues != null) {
            ParameterValidationUtils.validParameterAsSingleValue(response, parameterName, parameterValues);
            if (!StringValidateEncodeUtils.validPath(parameterValues[0]) || StringValidateEncodeUtils.containsAngleBracketCharacters(parameterValues[0]) || StringValidateEncodeUtils.containsBackslashCharacters(parameterValues[0])) {
                String msg = "Invalid parameter [" + parameterName + "] value [" + StringValidateEncodeUtils.encodeLogMessages(parameterValues[0]) + "].";
                log.error("validateParameterAsSingleValueUriString(): " + msg);
                response.sendError(400, msg);
                log.info(UsageLog.closingMessageForRequestContext(400, msg.length()));
                return false;
            }
        }
        return true;
    }

    public static boolean validateParameterAsSingleValueIdString(HttpServletRequest request, HttpServletResponse response, String parameterName) throws IOException, ServletException {
        String[] parameterValues = request.getParameterValues(parameterName);
        if (parameterValues != null) {
            ParameterValidationUtils.validParameterAsSingleValue(response, parameterName, parameterValues);
            if (!StringValidateEncodeUtils.validIdString(parameterValues[0]) || StringValidateEncodeUtils.containsAngleBracketCharacters(parameterValues[0]) || StringValidateEncodeUtils.containsBackslashCharacters(parameterValues[0])) {
                String msg = "Invalid parameter [" + parameterName + "] value [" + StringValidateEncodeUtils.encodeLogMessages(parameterValues[0]) + "].";
                log.error("validateParameterAsSingleValueIdString(): " + msg);
                response.sendError(400, msg);
                log.info(UsageLog.closingMessageForRequestContext(400, msg.length()));
                return false;
            }
        }
        return true;
    }

    public static boolean validateParameterAsSingleValueBooleanString(HttpServletRequest request, HttpServletResponse response, String parameterName) throws IOException, ServletException {
        String[] parameterValues = request.getParameterValues(parameterName);
        if (parameterValues != null) {
            ParameterValidationUtils.validParameterAsSingleValue(response, parameterName, parameterValues);
            if (!StringValidateEncodeUtils.validBooleanString(parameterValues[0])) {
                String msg = "Invalid parameter [" + parameterName + "] value [" + StringValidateEncodeUtils.encodeLogMessages(parameterValues[0]) + "].";
                log.error("validateParameterAsSingleValueBooleanString(): " + msg);
                response.sendError(400, msg);
                log.info(UsageLog.closingMessageForRequestContext(400, msg.length()));
                return false;
            }
        }
        return true;
    }

    public static boolean validateParameterAsSingleValueDecimalNumber(HttpServletRequest request, HttpServletResponse response, String parameterName) throws IOException, ServletException {
        String[] parameterValues = request.getParameterValues(parameterName);
        if (parameterValues != null) {
            ParameterValidationUtils.validParameterAsSingleValue(response, parameterName, parameterValues);
            if (!StringValidateEncodeUtils.validDecimalNumber(parameterValues[0])) {
                String msg = "Invalid parameter [" + parameterName + "] value [" + StringValidateEncodeUtils.encodeLogMessages(parameterValues[0]) + "].";
                log.error("validateParameterAsSingleValueDecimalNumber(): " + msg);
                response.sendError(400, msg);
                log.info(UsageLog.closingMessageForRequestContext(400, msg.length()));
                return false;
            }
        }
        return true;
    }

    private static boolean validParameterAsSingleValue(HttpServletResponse response, String parameterName, String[] parameterValues) throws IOException, ServletException {
        if (parameterValues != null && parameterValues.length > 1) {
            String msg = "Multi-valued parameter [" + parameterName + "].";
            log.error("validParameterAsSingleValue(): " + msg);
            response.sendError(400, msg);
            log.info(UsageLog.closingMessageForRequestContext(400, msg.length()));
            return false;
        }
        return true;
    }
}

