/*
 * Decompiled with CFR 0.152.
 */
package thredds.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.HtmlUtils;

public class StringValidateEncodeUtils {
    private static Logger log = LoggerFactory.getLogger(StringValidateEncodeUtils.class);
    public static final String CHARACTER_ENCODING_UTF_8 = "UTF-8";
    private static final Pattern INVALID_CHARACTERS_FOR_SINGLE_LINE_STRING_PATTERN = Pattern.compile("[\\p{Zl}\\p{Zp}\\p{C}]");
    private static final Pattern INVALID_CHARACTERS_FOR_ID_STRING_PATTERN = Pattern.compile("[\\p{Zs}]");
    private static final Pattern VALID_DECIMAL_DIGITS_PATTERN = Pattern.compile("[\\+\\-]?[0-9]+");
    private static final Pattern VALID_CHARACTERS_FOR_BOOLEAN_STRING_PATTERN = Pattern.compile("[trueTRUEfalsFALS]*");
    private static final Pattern VALID_CHARACTERS_FOR_ALPHANUMERIC_STRING_PATTERN = Pattern.compile("[a-zA-Z0-9]*");
    private static final Pattern VALID_PERCENT_HEX_OCTETS_PATTERN = Pattern.compile("(?:%[0-9a-fA-F]{2})*");

    private StringValidateEncodeUtils() {
    }

    public static boolean validSingleLineString(String singleLineString) {
        if (singleLineString == null) {
            return false;
        }
        Matcher m = INVALID_CHARACTERS_FOR_SINGLE_LINE_STRING_PATTERN.matcher(singleLineString);
        return !m.find();
    }

    public static boolean validPath(String path) {
        if (path == null) {
            return false;
        }
        if (path.indexOf("/../") != -1 || path.equals("..") || path.startsWith("../") || path.endsWith("/..")) {
            return false;
        }
        return StringValidateEncodeUtils.validSingleLineString(path);
    }

    public static boolean validFilePath(String path) {
        if (path == null) {
            return false;
        }
        if (path.indexOf(File.pathSeparatorChar) != -1) {
            return false;
        }
        return StringValidateEncodeUtils.validPath(path);
    }

    public static boolean validUriString(String uri) {
        if (uri == null) {
            return false;
        }
        return StringValidateEncodeUtils.validPath(uri);
    }

    public static boolean validIdString(String id) {
        if (id == null) {
            return false;
        }
        Matcher m = INVALID_CHARACTERS_FOR_ID_STRING_PATTERN.matcher(id);
        return !m.find() && StringValidateEncodeUtils.validSingleLineString(id);
    }

    public static boolean containsAngleBracketCharacters(String string) {
        if (string == null) {
            return false;
        }
        return string.indexOf("<") != -1 || string.indexOf(">") != -1;
    }

    public static boolean containsAmpersandCharacters(String string) {
        if (string == null) {
            return false;
        }
        return string.indexOf("&") != -1;
    }

    public static boolean containsBackslashCharacters(String string) {
        if (string == null) {
            return false;
        }
        return string.indexOf("\\") != -1;
    }

    public static boolean validDecimalNumber(String number) {
        if (number == null) {
            return false;
        }
        Matcher m = VALID_DECIMAL_DIGITS_PATTERN.matcher(number);
        return m.matches();
    }

    public static boolean validBooleanString(String boolString) {
        if (boolString == null) {
            return false;
        }
        Matcher m = VALID_CHARACTERS_FOR_BOOLEAN_STRING_PATTERN.matcher(boolString);
        if (!m.matches()) {
            return false;
        }
        return boolString.equalsIgnoreCase("true") || boolString.equalsIgnoreCase("false");
    }

    public static boolean validAlphanumericString(String alphNumString) {
        if (alphNumString == null) {
            return false;
        }
        Matcher m = VALID_CHARACTERS_FOR_ALPHANUMERIC_STRING_PATTERN.matcher(alphNumString);
        return m.matches();
    }

    public static boolean validAlphanumericStringConstrainedSet(String alphNumString, String[] constrainedSet, boolean ignoreCase) {
        if (alphNumString == null || constrainedSet == null || constrainedSet.length == 0) {
            return false;
        }
        Matcher m = VALID_CHARACTERS_FOR_ALPHANUMERIC_STRING_PATTERN.matcher(alphNumString);
        if (!m.matches()) {
            return false;
        }
        for (String s : constrainedSet) {
            if (!(ignoreCase ? alphNumString.equalsIgnoreCase(s) : alphNumString.equals(s))) continue;
            return true;
        }
        return false;
    }

    public static boolean descendOnlyFilePath(String path) {
        String[] pathSegments = path.split("/");
        int i = 0;
        for (int indxOrigSegs = 0; indxOrigSegs < pathSegments.length; ++indxOrigSegs) {
            String s = pathSegments[indxOrigSegs];
            if (s.equals(".")) continue;
            if (s.equals("..")) {
                if (i == 0) {
                    return false;
                }
                --i;
                continue;
            }
            ++i;
        }
        return true;
    }

    public static String encodeLogMessages(String msg) {
        try {
            return URLEncoder.encode(msg, CHARACTER_ENCODING_UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            log.error("UnsupportedEncodingException for \"UTF-8\": " + e.getMessage());
            throw new IllegalStateException("UnsupportedEncodingException for \"UTF-8\".");
        }
    }

    public static String encodeContentForHtml(String content) {
        return HtmlUtils.htmlEscape((String)content);
    }

    public static int percentHexString2unicodeCodePoint(String percentHexString, String charsetName) {
        Charset charset = (Charset)Charset.availableCharsets().get(charsetName);
        if (charset == null) {
            throw new IllegalArgumentException("Unsupported charset [" + charsetName + "].");
        }
        if (!StringValidateEncodeUtils.validPercentHexOctetsString(percentHexString)) {
            throw new IllegalArgumentException("Invalid percentHexOctets string [" + percentHexString + "].");
        }
        String[] hexOctets = percentHexString.split("%");
        ByteBuffer bb = ByteBuffer.allocate(hexOctets.length);
        bb.putInt(Integer.valueOf(hexOctets[0], 16));
        CharBuffer cb = charset.decode(bb);
        cb.hasArray();
        return -1;
    }

    public static boolean validPercentHexOctetsString(String percentHexOctetsString) {
        if (percentHexOctetsString == null) {
            return false;
        }
        Matcher m = VALID_PERCENT_HEX_OCTETS_PATTERN.matcher(percentHexOctetsString);
        return m.matches();
    }

    public static String unicodeCodePoint2PercentHexString(int codePoint, String charsetName) {
        if (!Character.isDefined(codePoint)) {
            throw new IllegalArgumentException("Not a valid Unicode code point [" + codePoint + "].");
        }
        Charset charset = (Charset)Charset.availableCharsets().get(charsetName);
        if (charset == null) {
            throw new IllegalArgumentException("Unsupported charset [" + charsetName + "].");
        }
        char[] chars = Character.toChars(codePoint);
        ByteBuffer byteBuffer = null;
        try {
            byteBuffer = charset.newEncoder().encode(CharBuffer.wrap(chars));
        }
        catch (CharacterCodingException e) {
            return null;
        }
        byteBuffer.rewind();
        StringBuilder encodedString = new StringBuilder();
        for (int i = 0; i < byteBuffer.limit(); ++i) {
            String asHex = Integer.toHexString(byteBuffer.get() & 0xFF);
            encodedString.append("%").append(asHex.length() == 1 ? "0" : "").append(asHex);
        }
        return encodedString.toString();
    }
}

