/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.cdmremote;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractCommandController;
import org.springframework.web.servlet.mvc.LastModified;
import thredds.server.cdmremote.CdmRemoteQueryBean;
import thredds.server.config.TdsContext;
import thredds.servlet.DataRootHandler;
import thredds.servlet.DatasetHandler;
import thredds.servlet.ServletUtil;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ParsedSectionSpec;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.stream.NcStreamWriter;
import ucar.nc2.util.net.EscapeStrings;

public class CdmRemoteController
extends AbstractCommandController
implements LastModified {
    private static final Logger log = LoggerFactory.getLogger(CdmRemoteController.class);
    private static boolean debug = false;
    private static boolean showTime = false;
    private static boolean showReq = false;
    private TdsContext tdsContext;
    private boolean allow = true;

    public CdmRemoteController() {
        this.setCommandClass(CdmRemoteQueryBean.class);
        this.setCommandName("PointQueryBean");
    }

    public void setTdsContext(TdsContext tdsContext) {
        this.tdsContext = tdsContext;
    }

    public void setAllow(boolean allow) {
        this.allow = allow;
    }

    public long getLastModified(HttpServletRequest req) {
        File file = DataRootHandler.getInstance().getCrawlableDatasetAsFile(req.getPathInfo());
        if (file != null && file.exists()) {
            return file.lastModified();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelAndView handle(HttpServletRequest req, HttpServletResponse res, Object command, BindException errors) throws Exception {
        CdmRemoteQueryBean qb;
        if (!this.allow) {
            res.sendError(403, "Service not supported");
            return null;
        }
        String absPath = ServletUtil.getRequestServer(req) + req.getContextPath() + req.getServletPath() + req.getPathInfo();
        String path = req.getPathInfo();
        if (showReq) {
            System.out.printf("CdmRemoteController req=%s%n", absPath + "?" + req.getQueryString());
        }
        if (debug) {
            System.out.printf(" path=%s%n query=%s%n", path, req.getQueryString());
        }
        if (!(qb = (CdmRemoteQueryBean)command).validate()) {
            res.sendError(400, qb.getErrorMessage());
            if (debug) {
                System.out.printf(" query error= %s %n", qb.getErrorMessage());
            }
            return null;
        }
        if (debug) {
            System.out.printf(" %s%n", qb);
        }
        NetcdfFile ncfile = null;
        try {
            ncfile = DatasetHandler.getNetcdfFile(req, res, path);
            if (ncfile == null) {
                res.setStatus(404);
                log.debug("DatasetHandler.FAIL path={}", (Object)path);
                ModelAndView modelAndView = null;
                return modelAndView;
            }
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)res.getOutputStream(), 10000);
            long size = -1L;
            switch (qb.getRequestType()) {
                case capabilities: {
                    this.sendCapabilities(out, FeatureType.GRID, absPath);
                    res.flushBuffer();
                    ModelAndView modelAndView = null;
                    return modelAndView;
                }
                case form: 
                case cdl: {
                    res.setContentType("text/plain");
                    String cdl = ncfile.toString();
                    res.setContentLength(cdl.length());
                    byte[] b = cdl.getBytes("UTF-8");
                    ((OutputStream)out).write(b);
                    size = b.length;
                    break;
                }
                case ncml: {
                    res.setContentType("application/xml");
                    ncfile.writeNcML((OutputStream)out, absPath);
                    break;
                }
                case header: {
                    res.setContentType("application/octet-stream");
                    res.setHeader("Content-Description", "ncstream");
                    NcStreamWriter ncWriter = new NcStreamWriter(ncfile, ServletUtil.getRequestBase(req));
                    size = ncWriter.sendHeader((OutputStream)out);
                    break;
                }
                default: {
                    res.setContentType("application/octet-stream");
                    res.setHeader("Content-Description", "ncstream");
                    size = 0L;
                    NcStreamWriter ncWriter = new NcStreamWriter(ncfile, ServletUtil.getRequestBase(req));
                    String query = qb.getVar() != null ? qb.getVar() : req.getQueryString();
                    if (query == null || query.length() == 0) {
                        res.sendError(400, "must have query string");
                        ModelAndView modelAndView = null;
                        return modelAndView;
                    }
                    query = EscapeStrings.unescapeURLQuery((String)query);
                    StringTokenizer stoke = new StringTokenizer(query, ";");
                    while (stoke.hasMoreTokens()) {
                        ParsedSectionSpec cer = ParsedSectionSpec.parseVariableSection((NetcdfFile)ncfile, (String)stoke.nextToken());
                        size += ncWriter.sendData(cer.v, cer.section, (OutputStream)out, false);
                    }
                    break block17;
                }
            }
            ((OutputStream)out).flush();
            res.flushBuffer();
            if (showReq) {
                System.out.printf("CdmRemoteController ok, size=%s%n", size);
            }
        }
        catch (FileNotFoundException e) {
            log.debug("FAIL", (Throwable)e);
            res.sendError(404, e.getMessage());
        }
        catch (IllegalArgumentException e) {
            res.sendError(400, e.getMessage());
        }
        catch (InvalidRangeException e) {
            res.sendError(400, e.getMessage());
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            res.sendError(500, e.getMessage());
        }
        finally {
            if (null != ncfile) {
                try {
                    ncfile.close();
                }
                catch (IOException ioe) {
                    log.error("Failed to close = " + path);
                }
            }
        }
        return null;
    }

    private void sendCapabilities(OutputStream os, FeatureType ft, String absPath) throws IOException {
        Element rootElem = new Element("cdmRemoteCapabilities");
        Document doc = new Document(rootElem);
        rootElem.setAttribute("location", absPath);
        Element elem = new Element("featureDataset");
        elem.setAttribute("type", ft.toString());
        elem.setAttribute("url", absPath);
        rootElem.addContent((Content)elem);
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        fmt.output(doc, os);
    }
}

