/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset.controller;

import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import thredds.server.ncSubset.controller.AbstratNcssDataRequestController;
import thredds.server.ncSubset.controller.SupportedFormat;
import thredds.server.ncSubset.controller.SupportedOperation;
import thredds.server.ncSubset.exception.NcssException;
import thredds.server.ncSubset.exception.OutOfBoundariesException;
import thredds.server.ncSubset.exception.UnsupportedOperationException;
import thredds.server.ncSubset.exception.VariableNotContainedInDatasetException;
import thredds.server.ncSubset.params.PointDataRequestParamsBean;
import thredds.server.ncSubset.params.RequestParamsBean;
import thredds.server.ncSubset.util.NcssRequestUtils;
import thredds.server.ncSubset.view.PointDataStream;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.time.CalendarDate;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.ProjectionPoint;

@Controller
@RequestMapping(value={"/ncss/grid/**"})
class PointDataController
extends AbstratNcssDataRequestController {
    private static final Logger log = LoggerFactory.getLogger(PointDataController.class);

    PointDataController() {
    }

    @RequestMapping(value={"**"}, params={"latitude", "longitude", "var"})
    void getPointData(@Valid PointDataRequestParamsBean params, BindingResult validationResult, HttpServletResponse response) throws ParseException, NcssException, IOException {
        if (validationResult.hasErrors()) {
            this.handleValidationErrorsResponse(response, 400, validationResult);
        } else {
            SupportedFormat sf = this.getSupportedFormat(params, SupportedOperation.POINT_REQUEST);
            LatLonPoint point = params.getLatLonPoint();
            this.checkRequestedVars(this.gridDataset, params);
            Map<String, List<String>> groupVars = this.groupVarsByVertLevels(this.gridDataset, params);
            if (!this.isPointWithinBoundaries(params.getLatLonPoint(), groupVars)) {
                throw new OutOfBoundariesException("Requested Lat/Lon Point (+" + point + ") is not contained in the Data. " + "Data Bounding Box = " + this.getGridDataset().getBoundingBox().toString2());
            }
            List<CalendarDate> wantedDates = this.getRequestedDates(this.gridDataset, params);
            response.setContentType(sf.getResponseContentType());
            PointDataStream pds = PointDataStream.createPointDataStream(sf, (OutputStream)response.getOutputStream());
            boolean allWritten = false;
            this.setResponseHeaders(response, pds.getHttpHeaders(this.getGridDataset()));
            allWritten = pds.stream(this.getGridDataset(), point, wantedDates, groupVars, params.getVertCoord());
            if (allWritten) {
                response.flushBuffer();
                response.getOutputStream().close();
                response.setStatus(200);
            } else {
                response.sendError(500);
            }
        }
    }

    @Override
    protected void checkRequestedVars(GridDataset gds, RequestParamsBean params) throws VariableNotContainedInDatasetException, UnsupportedOperationException {
        Iterator<String> it;
        String varName;
        GridDatatype grid;
        if (params.getVar().get(0).equals("all")) {
            params.setVar(NcssRequestUtils.getAllVarsAsList(this.getGridDataset()));
        }
        if ((grid = gds.findGridByShortName(varName = (it = params.getVar().iterator()).next())) == null) {
            throw new VariableNotContainedInDatasetException("Variable: " + varName + " is not contained in the requested dataset");
        }
        CoordinateAxis1D vertAxis = grid.getCoordinateSystem().getVerticalAxis();
        CoordinateAxis1D newVertAxis = null;
        boolean sameVertCoord = true;
        while (sameVertCoord && it.hasNext()) {
            varName = it.next();
            grid = gds.findGridByShortName(varName);
            if (grid == null) {
                throw new VariableNotContainedInDatasetException("Variable: " + varName + " is not contained in the requested dataset");
            }
            newVertAxis = grid.getCoordinateSystem().getVerticalAxis();
            if (vertAxis != null) {
                if (vertAxis.equals((Object)newVertAxis)) {
                    vertAxis = newVertAxis;
                    continue;
                }
                sameVertCoord = false;
                continue;
            }
            if (newVertAxis == null) continue;
            sameVertCoord = false;
        }
        if (!sameVertCoord) {
            throw new UnsupportedOperationException("The variables requested: " + params.getVar() + " have different vertical levels. Only Grid as point requests on variables with same vertical levels are supported.");
        }
    }

    private boolean isPointWithinBoundaries(LatLonPoint point, Map<String, List<String>> groupVars) {
        boolean isInData = true;
        ArrayList<String> keys = new ArrayList<String>(groupVars.keySet());
        int[] xy = new int[2];
        Iterator it = keys.iterator();
        while (it.hasNext() && isInData) {
            ProjectionPoint p;
            String key = (String)it.next();
            GridDatatype grid = this.gridDataset.findGridDatatype(groupVars.get(key).get(0));
            GridCoordSystem coordSys = grid.getCoordinateSystem();
            xy = coordSys.findXYindexFromCoord((p = coordSys.getProjection().latLonToProj(point)).getX(), p.getY(), null);
            if (xy[0] >= 0 && xy[1] >= 0) continue;
            isInData = false;
        }
        return isInData;
    }

    private Map<String, List<String>> groupVarsByVertLevels(GridDataset gds, PointDataRequestParamsBean params) throws VariableNotContainedInDatasetException {
        String no_vert_levels = "no_vert_level";
        List<String> vars = params.getVar();
        HashMap<String, List<String>> varsGroupsByLevels = new HashMap<String, List<String>>();
        for (String var : vars) {
            GridDatatype grid = gds.findGridDatatype(var);
            if (grid == null) {
                throw new VariableNotContainedInDatasetException("Variable: " + var + " is not contained in the requested dataset");
            }
            CoordinateAxis1D axis = grid.getCoordinateSystem().getVerticalAxis();
            String axisKey = null;
            axisKey = axis == null ? no_vert_levels : axis.getShortName();
            if (varsGroupsByLevels.containsKey(axisKey)) {
                ((List)varsGroupsByLevels.get(axisKey)).add(var);
                continue;
            }
            ArrayList<String> varListForVerlLevel = new ArrayList<String>();
            varListForVerlLevel.add(var);
            varsGroupsByLevels.put(axisKey, varListForVerlLevel);
        }
        return varsGroupsByLevels;
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public String handle(NcssException ncsse) {
        return "NetCDF Subset Service exception handled : " + ncsse.getMessage();
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public String handle(ParseException pe) {
        return "Parse exception handled: " + pe.getMessage();
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public String handle(IOException ioe) {
        return "IO exception handled: " + ioe.getMessage();
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public String handleValidationException(MethodArgumentNotValidException ve) {
        return "Bad request: " + ve.getMessage();
    }
}

