/*
 * Decompiled with CFR 0.152.
 */
package thredds.util.filesource;

import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.util.filesource.DescendantFileSource;
import thredds.util.filesource.FileSource;

public class ChainedFileSource
implements FileSource {
    private static Logger log = LoggerFactory.getLogger(ChainedFileSource.class);
    private final List<DescendantFileSource> chain;

    public ChainedFileSource(List<DescendantFileSource> chain) {
        if (chain == null || chain.isEmpty()) {
            throw new IllegalArgumentException("Locator chain must not be null or empty.");
        }
        for (DescendantFileSource dfs : chain) {
            if (dfs != null) continue;
            throw new IllegalArgumentException("Locator chain must not contain null items.");
        }
        this.chain = chain;
    }

    @Override
    public File getFile(String path) {
        for (DescendantFileSource curLocator : this.chain) {
            File file = curLocator.getFile(path);
            if (file == null) continue;
            return file;
        }
        return null;
    }
}

