/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset.view.netcdf;

import java.io.IOException;
import java.util.List;
import thredds.server.ncSubset.view.netcdf.CFPointWriterWrapper;
import thredds.server.ncSubset.view.netcdf.WriterCFPointCollectionWrapper;
import thredds.server.ncSubset.view.netcdf.WriterCFProfileCollectionWrapper;
import thredds.server.ncSubset.view.netcdf.WriterCFStationCollectionWrapper;
import ucar.nc2.Attribute;
import ucar.nc2.constants.CF;

public final class CFPointWriterWrapperFactory {
    private CFPointWriterWrapperFactory() {
    }

    public static final CFPointWriterWrapper getWriterForFeatureType(CF.FeatureType featureType, String filePath, List<Attribute> atts) throws IOException {
        if (featureType == CF.FeatureType.timeSeries) {
            return WriterCFStationCollectionWrapper.createWrapper(filePath, atts);
        }
        if (featureType == CF.FeatureType.point) {
            return WriterCFPointCollectionWrapper.createWrapper(filePath, atts);
        }
        if (featureType == CF.FeatureType.profile) {
            return WriterCFProfileCollectionWrapper.createWrapper(filePath, atts);
        }
        throw new UnsupportedOperationException("Unsupported FeatureType: " + featureType.name());
    }
}

