/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvAccess;
import thredds.catalog.InvDatasetFeatureCollection;
import thredds.catalog.InvDatasetFmrc;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDatasetScan;
import thredds.servlet.DataRootHandler;
import thredds.servlet.DatasetSource;
import thredds.servlet.DebugHandler;
import thredds.servlet.PathMatcher;
import thredds.servlet.restrict.RestrictedDatasetServlet;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.cache.FileFactory;

public class DatasetHandler {
    private static final Logger log = LoggerFactory.getLogger(DatasetHandler.class);
    private static final boolean debugResourceControl = false;
    private static HashMap<String, InvDatasetImpl> ncmlDatasetHash = new HashMap();
    private static ArrayList<DatasetSource> sourceList = new ArrayList();
    private static HashMap<String, String> resourceControlHash = new HashMap();
    private static volatile PathMatcher resourceControlMatcher = new PathMatcher();
    private static boolean hasResourceControl = false;

    static void reinit() {
        ncmlDatasetHash = new HashMap();
        resourceControlHash = new HashMap();
        resourceControlMatcher = new PathMatcher();
        sourceList = new ArrayList();
        hasResourceControl = false;
    }

    public static void makeDebugActions() {
        DebugHandler debugHandler = DebugHandler.get("catalogs");
        DebugHandler.Action act = new DebugHandler.Action("showNcml", "Show ncml datasets"){

            @Override
            public void doAction(DebugHandler.Event e) {
                for (Object key : ncmlDatasetHash.keySet()) {
                    e.pw.println(" url=" + key);
                }
            }
        };
        debugHandler.addAction(act);
    }

    public static void registerDatasetSource(String className) {
        Object instance;
        Class<?> vClass;
        try {
            vClass = DatasetHandler.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            log.error("Attempt to load DatasetSource class " + className + " not found");
            return;
        }
        if (!DatasetSource.class.isAssignableFrom(vClass)) {
            log.error("Attempt to load class " + className + " does not implement " + DatasetSource.class.getName());
            return;
        }
        try {
            instance = vClass.newInstance();
        }
        catch (InstantiationException e) {
            log.error("Attempt to load Viewer class " + className + " cannot instantiate, probably need default Constructor.");
            return;
        }
        catch (IllegalAccessException e) {
            log.error("Attempt to load Viewer class " + className + " is not accessible.");
            return;
        }
        DatasetHandler.registerDatasetSource((DatasetSource)instance);
    }

    public static void registerDatasetSource(DatasetSource v) {
        sourceList.add(v);
    }

    public static NetcdfFile getNetcdfFile(HttpServletRequest req, HttpServletResponse res) throws IOException {
        return DatasetHandler.getNetcdfFile(req, res, req.getPathInfo());
    }

    public static NetcdfFile getNetcdfFile(HttpServletRequest req, HttpServletResponse res, String reqPath) throws IOException {
        Element netcdfElem;
        if (log.isDebugEnabled()) {
            log.debug("DatasetHandler wants " + reqPath);
        }
        if (reqPath == null) {
            return null;
        }
        if (reqPath.startsWith("/")) {
            reqPath = reqPath.substring(1);
        }
        if (!DatasetHandler.resourceControlOk(req, res, reqPath)) {
            return null;
        }
        InvDatasetImpl ds = ncmlDatasetHash.get(reqPath);
        if (ds != null) {
            NetcdfFile ncfile;
            if (log.isDebugEnabled()) {
                log.debug("  -- DatasetHandler found NcmlDataset= " + ds);
            }
            if ((ncfile = NetcdfDataset.acquireFile((FileFactory)new NcmlFileFactory(ds), null, (String)reqPath, (int)-1, null, null)) == null) {
                throw new FileNotFoundException(reqPath);
            }
            return ncfile;
        }
        DataRootHandler.DataRootMatch match = DataRootHandler.getInstance().findDataRootMatch(reqPath);
        if (match != null && match.dataRoot.fmrc != null) {
            NetcdfDataset ncfile;
            InvDatasetFmrc fmrc = match.dataRoot.fmrc;
            if (log.isDebugEnabled()) {
                log.debug("  -- DatasetHandler found InvDatasetFmrc= " + fmrc);
            }
            if ((ncfile = fmrc.getDataset(match.remaining)) == null) {
                throw new FileNotFoundException(reqPath);
            }
            return ncfile;
        }
        if (match != null && match.dataRoot.featCollection != null) {
            NetcdfDataset ncfile;
            InvDatasetFeatureCollection featCollection = match.dataRoot.featCollection;
            if (log.isDebugEnabled()) {
                log.debug("  -- DatasetHandler found InvDatasetFeatureCollection= " + featCollection);
            }
            if ((ncfile = featCollection.getNetcdfDataset(match.remaining)) == null) {
                throw new FileNotFoundException(reqPath);
            }
            return ncfile;
        }
        NetcdfFile ncfile = null;
        for (DatasetSource datasetSource : sourceList) {
            if (!datasetSource.isMine(req) || (ncfile = datasetSource.getNetcdfFile(req, res)) != null) continue;
            return null;
        }
        if (ncfile == null) {
            File file;
            boolean cache = true;
            if (match != null && match.dataRoot != null) {
                cache = match.dataRoot.cache;
            }
            if ((file = DataRootHandler.getInstance().getCrawlableDatasetAsFile(reqPath)) == null) {
                throw new FileNotFoundException(reqPath);
            }
            ncfile = cache ? NetcdfDataset.acquireFile((String)file.getPath(), null) : NetcdfDataset.openFile((String)file.getPath(), null);
            if (ncfile == null) {
                throw new FileNotFoundException(reqPath);
            }
        }
        if ((netcdfElem = DataRootHandler.getInstance().getNcML(reqPath)) != null) {
            NetcdfDataset ncd = NetcdfDataset.wrap(ncfile, null);
            new NcMLReader().readNetcdf(reqPath, ncd, (NetcdfFile)ncd, netcdfElem, null);
            if (log.isDebugEnabled()) {
                log.debug("  -- DatasetHandler found DataRoot NcML = " + ds);
            }
            return ncd;
        }
        return ncfile;
    }

    public static InvDatasetFeatureCollection getFeatureCollection(HttpServletRequest req, HttpServletResponse res) throws IOException {
        return DatasetHandler.getFeatureCollection(req, res, req.getPathInfo());
    }

    public static InvDatasetFeatureCollection getFeatureCollection(HttpServletRequest req, HttpServletResponse res, String reqPath) throws IOException {
        if (reqPath == null) {
            return null;
        }
        if (reqPath.startsWith("/")) {
            reqPath = reqPath.substring(1);
        }
        if (!DatasetHandler.resourceControlOk(req, res, reqPath)) {
            return null;
        }
        DataRootHandler.DataRootMatch match = DataRootHandler.getInstance().findDataRootMatch(reqPath);
        if (match != null && match.dataRoot.featCollection != null) {
            return match.dataRoot.featCollection;
        }
        return null;
    }

    public static ucar.nc2.dt.GridDataset openGridDataset(HttpServletRequest req, HttpServletResponse res, String reqPath) throws IOException {
        return DatasetHandler.openGridDataset(req, res, reqPath, NetcdfDataset.getDefaultEnhanceMode());
    }

    public static ucar.nc2.dt.GridDataset openGridDataset(HttpServletRequest req, HttpServletResponse res, String reqPath, Set<NetcdfDataset.Enhance> enhanceMode) throws IOException {
        DataRootHandler.DataRootMatch match = DataRootHandler.getInstance().findDataRootMatch(reqPath);
        if (match != null && match.dataRoot.featCollection != null) {
            ucar.nc2.dt.GridDataset gds;
            InvDatasetFeatureCollection featCollection = match.dataRoot.featCollection;
            if (log.isDebugEnabled()) {
                log.debug("  -- DatasetHandler found InvDatasetFeatureCollection= " + featCollection);
            }
            if ((gds = featCollection.getGridDataset(match.remaining)) == null) {
                throw new FileNotFoundException(reqPath);
            }
            return gds;
        }
        NetcdfFile ncfile = DatasetHandler.getNetcdfFile(req, res, reqPath);
        if (ncfile == null) {
            return null;
        }
        NetcdfDataset ncd = null;
        try {
            ncd = NetcdfDataset.wrap((NetcdfFile)ncfile, enhanceMode);
            return new GridDataset(ncd);
        }
        catch (Throwable t) {
            if (ncd == null) {
                ncfile.close();
            } else {
                ncd.close();
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            String msg = ncd == null ? "Problem wrapping NetcdfFile in NetcdfDataset" : "Problem creating GridDataset from NetcdfDataset";
            log.error("openGridDataset(): " + msg, t);
            throw new IOException(msg + t.getMessage());
        }
    }

    public static String findResourceControl(String path) {
        String rc;
        if (!hasResourceControl) {
            return null;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (null == (rc = resourceControlHash.get(path))) {
            rc = (String)resourceControlMatcher.match(path);
        }
        return rc;
    }

    public static boolean resourceControlOk(HttpServletRequest req, HttpServletResponse res, String reqPath) throws IOException {
        String rc;
        if (null == reqPath) {
            reqPath = req.getPathInfo();
        }
        if (reqPath.startsWith("/")) {
            reqPath = reqPath.substring(1);
        }
        if ((rc = DatasetHandler.findResourceControl(reqPath)) != null) {
            try {
                if (!RestrictedDatasetServlet.authorize(req, res, rc)) {
                    return false;
                }
            }
            catch (ServletException e) {
                throw new IOException(e.getMessage());
            }
        }
        return true;
    }

    static void putResourceControl(InvDatasetImpl ds) {
        if (log.isDebugEnabled()) {
            log.debug("putResourceControl " + ds.getRestrictAccess() + " for " + ds.getName());
        }
        if (ds instanceof InvDatasetScan) {
            InvDatasetScan scan = (InvDatasetScan)ds;
            resourceControlMatcher.put(scan.getPath(), ds.getRestrictAccess());
        } else if (ds instanceof InvDatasetFmrc) {
            InvDatasetFmrc fmrc = (InvDatasetFmrc)ds;
            resourceControlMatcher.put(fmrc.getPath(), ds.getRestrictAccess());
        } else {
            for (InvAccess access : ds.getAccess()) {
                if (!access.getService().isRelativeBase()) continue;
                resourceControlHash.put(access.getUrlPath(), ds.getRestrictAccess());
            }
        }
        hasResourceControl = true;
    }

    static void putNcmlDataset(String path, InvDatasetImpl ds) {
        if (log.isDebugEnabled()) {
            log.debug("putNcmlDataset " + path + " for " + ds.getName());
        }
        ncmlDatasetHash.put(path, ds);
    }

    private static class NcmlFileFactory
    implements FileFactory {
        private InvDatasetImpl ds;

        NcmlFileFactory(InvDatasetImpl ds) {
            this.ds = ds;
        }

        public NetcdfFile open(String cacheName, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
            Element netcdfElem = this.ds.getNcmlElement();
            return NcMLReader.readNcML((String)cacheName, (Element)netcdfElem, (CancelTask)cancelTask);
        }
    }
}

