/*
 * Decompiled with CFR 0.152.
 */
package thredds.dqc.server;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.servlet.ServletUtil;
import thredds.util.RequestForwardUtils;

public class DqcServletRedirect
extends HttpServlet {
    private static Logger log = LoggerFactory.getLogger(DqcServletRedirect.class);
    private String targetContextPath = "/thredds";
    private String targetServletPath = "/dqc";
    private String testTargetContextPath = "/dqcServlet";
    private String testRedirectPath = "/redirect-test";
    private String testRedirectStopPath = "/redirect-stop-test";

    public void init() throws ServletException {
        this.getServletConfig();
        ServletUtil.setContextPath(this.testTargetContextPath);
        ServletUtil.initContext(this.getServletContext());
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        boolean enableTestRedirect = false;
        String reqPath = req.getPathInfo();
        if (reqPath == null) {
            this.doDispatch(req, res, false);
        } else if (reqPath.equals(this.testRedirectPath + "/index.html")) {
            ServletUtil.handleRequestForRawFile("index.html", this, req, res);
        } else if (reqPath.equals(this.testRedirectPath + "/301.html")) {
            this.handleGetRequestForRedirectTest(res, req, StatusCode.SC_301, BodyType.HTML);
        } else if (reqPath.equals(this.testRedirectPath + "/302.html")) {
            this.handleGetRequestForRedirectTest(res, req, StatusCode.SC_302, BodyType.HTML);
        } else if (reqPath.equals(this.testRedirectPath + "/305.html")) {
            this.handleGetRequestForRedirectTest(res, req, StatusCode.SC_305, BodyType.HTML);
        } else if (reqPath.equals(this.testRedirectPath + "/307.html")) {
            this.handleGetRequestForRedirectTest(res, req, StatusCode.SC_307, BodyType.HTML);
        } else if (reqPath.equals(this.testRedirectPath + "/301.xml")) {
            this.handleGetRequestForRedirectTest(res, req, StatusCode.SC_301, BodyType.XML);
        } else if (reqPath.equals(this.testRedirectPath + "/302.xml")) {
            this.handleGetRequestForRedirectTest(res, req, StatusCode.SC_302, BodyType.XML);
        } else if (reqPath.equals(this.testRedirectPath + "/305.xml")) {
            this.handleGetRequestForRedirectTest(res, req, StatusCode.SC_305, BodyType.XML);
        } else if (reqPath.equals(this.testRedirectPath + "/307.xml")) {
            this.handleGetRequestForRedirectTest(res, req, StatusCode.SC_307, BodyType.XML);
        } else if (reqPath.startsWith(this.testRedirectPath + "/301.dods.nc")) {
            this.handleGetRequestForRedirectTest(res, req, StatusCode.SC_301, BodyType.DAP);
        } else if (reqPath.startsWith(this.testRedirectPath + "/302.dods.nc")) {
            this.handleGetRequestForRedirectTest(res, req, StatusCode.SC_302, BodyType.DAP);
        } else if (reqPath.startsWith(this.testRedirectPath + "/305.dods.nc")) {
            this.handleGetRequestForRedirectTest(res, req, StatusCode.SC_305, BodyType.DAP);
        } else if (reqPath.startsWith(this.testRedirectPath + "/307.dods.nc")) {
            this.handleGetRequestForRedirectTest(res, req, StatusCode.SC_307, BodyType.DAP);
        } else if (reqPath.startsWith(this.testRedirectStopPath) && enableTestRedirect) {
            this.handleGetRequestForRedirectStopTest(res, req);
        } else {
            this.doDispatch(req, res, false);
        }
    }

    private void handleGetRequestForRedirectTest(HttpServletResponse res, HttpServletRequest req, StatusCode sc, BodyType desiredBodyType) throws IOException {
        String urlSuffix = null;
        BodyType respBodyType = null;
        if (desiredBodyType.equals((Object)BodyType.HTML)) {
            urlSuffix = ".html";
            respBodyType = BodyType.HTML;
        } else if (desiredBodyType.equals((Object)BodyType.XML)) {
            urlSuffix = ".xml";
            respBodyType = BodyType.XML;
        } else if (desiredBodyType.equals((Object)BodyType.DAP)) {
            urlSuffix = ".dods.nc";
            respBodyType = BodyType.HTML;
        }
        String requestUrlString = req.getRequestURL().toString();
        String reqPath = req.getPathInfo();
        String expectedPath = this.testRedirectPath + "/" + sc.toString() + urlSuffix;
        if (!reqPath.startsWith(expectedPath)) {
            throw new IllegalStateException("Request [" + reqPath + "] not as expected [" + expectedPath + "].");
        }
        if ((desiredBodyType.equals((Object)BodyType.HTML) || desiredBodyType.equals((Object)BodyType.XML)) && !reqPath.equals(expectedPath)) {
            throw new IllegalStateException("Request [" + reqPath + "] not as expected [" + expectedPath + "].");
        }
        String queryString = req.getQueryString();
        String targetUrlString = null;
        if (desiredBodyType.equals((Object)BodyType.DAP)) {
            String remainingPath = reqPath.substring(expectedPath.length());
            targetUrlString = "http://motherlode.ucar.edu:8080/thredds/dodsC/public/dataset/testData.nc" + remainingPath + (queryString != null ? "?" + queryString : "");
        } else {
            StringBuffer targetUrlStringBuffer = new StringBuffer(requestUrlString);
            int start = targetUrlStringBuffer.indexOf(this.testRedirectPath);
            targetUrlStringBuffer.replace(start, start + this.testRedirectPath.length(), this.testRedirectStopPath);
            if (queryString != null) {
                targetUrlStringBuffer.append("?").append(queryString);
            }
            targetUrlString = targetUrlStringBuffer.toString();
        }
        String title = "Redirection: " + sc.toString() + "(" + sc.getMessage() + ")" + " to " + targetUrlString;
        StringBuilder response = null;
        if (desiredBodyType.equals((Object)BodyType.HTML) || desiredBodyType.equals((Object)BodyType.DAP)) {
            StringBuilder htmlBody = new StringBuilder().append("<p>").append("The requested URL [").append(requestUrlString).append("] has been redirected [").append(sc.toString()).append(" (").append(sc.getMessage()).append(")].").append(" Instead, please use the following URL: <a href='").append(targetUrlString).append("'>").append(targetUrlString).append("</a>.").append("</p>");
            response = this.generateHtmlResponse(title, htmlBody.toString());
        } else if (desiredBodyType.equals((Object)BodyType.XML)) {
            response = this.generateCatalogResponse(title, targetUrlString, title);
        }
        this.sendResponse(res, targetUrlString, sc, response.toString(), respBodyType);
    }

    private void handleGetRequestForRedirectStopTest(HttpServletResponse res, HttpServletRequest req) throws IOException {
        String requestUrlString = req.getRequestURL().toString();
        String reqPath = req.getPathInfo();
        String queryString = req.getQueryString();
        log.debug("handleGetRequestForRedirectStopTest(): handle GET path \"" + reqPath + "\") with query \"" + queryString + "\">.");
        String title = "Redirected: " + requestUrlString;
        StringBuilder response = null;
        BodyType responseBodyType = null;
        if (reqPath.endsWith(".xml")) {
            responseBodyType = BodyType.XML;
            response = this.generateCatalogResponse(title, "/thredds/catalog.xml", "main catalog");
        } else {
            responseBodyType = BodyType.HTML;
            StringBuilder body = new StringBuilder().append("<p>").append(requestUrlString).append("</p>");
            response = this.generateHtmlResponse(title, body.toString());
        }
        this.sendResponse(res, null, StatusCode.SC_200, response.toString(), responseBodyType);
    }

    private void sendResponse(HttpServletResponse response, String targetUrlString, StatusCode sc, String body, BodyType bodyType) throws IOException {
        if (sc.equals((Object)StatusCode.SC_200)) {
            response.setStatus(200);
        }
        if (sc.equals((Object)StatusCode.SC_301)) {
            response.setStatus(301);
            response.addHeader("Location", targetUrlString);
        } else if (sc.equals((Object)StatusCode.SC_305)) {
            response.setStatus(305);
            response.addHeader("Location", targetUrlString);
        } else if (sc.equals((Object)StatusCode.SC_307)) {
            response.setStatus(307);
            response.addHeader("Location", targetUrlString);
        }
        PrintWriter out = response.getWriter();
        if (bodyType.equals((Object)BodyType.XML)) {
            response.setContentType("application/xml");
        } else if (bodyType.equals((Object)BodyType.HTML)) {
            response.setContentType("text/html");
        }
        out.print(body);
        if (sc.equals((Object)StatusCode.SC_302)) {
            response.sendRedirect(targetUrlString);
        }
    }

    public void doPut(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doDispatch(req, res, false);
    }

    private void doDispatch(HttpServletRequest req, HttpServletResponse res, boolean useTestContext) throws IOException, ServletException {
        String requestURIPath = new StringBuffer().append(req.getContextPath()).append(req.getServletPath()).append(req.getPathInfo()).toString();
        String targetURIPath = this.convertRequestURLToResponseURL(requestURIPath, req, useTestContext);
        String targetURIPathNoContext = targetURIPath.substring(useTestContext ? this.testTargetContextPath.length() : this.targetContextPath.length());
        String queryString = req.getQueryString();
        String reqURL = requestURIPath;
        String targetURL = targetURIPath;
        if (queryString != null) {
            reqURL = reqURL + "?" + queryString;
        }
        if (queryString != null) {
            targetURL = targetURL + "?" + queryString;
        }
        log.info("doDispatch(): " + req.getRemoteHost() + " - dispatching request for URL \"" + reqURL + "\" to \"" + targetURL + "\".");
        ServletContext context = this.getServletContext();
        ServletContext targetContext = context.getContext(useTestContext ? this.testTargetContextPath : this.targetContextPath);
        if (targetContext == null) {
            String tmpMsg = "Null ServletContext for \"" + (useTestContext ? this.testTargetContextPath : this.targetContextPath) + "\"";
            res.sendError(404, tmpMsg);
            return;
        }
        RequestForwardUtils.forwardRequestRelativeToGivenContext(targetURIPathNoContext, targetContext, req, res);
    }

    private String convertRequestURLToResponseURL(String reqURL, HttpServletRequest req, boolean useTestContext) {
        StringBuffer reqURLBuffer = new StringBuffer(reqURL);
        String strToReplace = useTestContext ? (req.getPathInfo().length() > this.testRedirectPath.length() ? this.testRedirectPath : req.getPathInfo()) : req.getContextPath() + req.getServletPath();
        int strToReplaceStart = reqURL.indexOf(strToReplace);
        int strToReplaceEnd = strToReplaceStart + strToReplace.length();
        reqURLBuffer.replace(strToReplaceStart, strToReplaceEnd, useTestContext ? this.testRedirectStopPath : this.targetContextPath + this.targetServletPath);
        return reqURLBuffer.toString();
    }

    private StringBuilder generateCatalogResponse(String title, String catLink, String catName) {
        StringBuilder response = new StringBuilder().append("<?xml version='1.0' encoding='UTF-8'?>\n").append("<catalog xmlns='http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0'\n").append("         xmlns:xlink='http://www.w3.org/1999/xlink' name='").append(title).append("' version='1.0.3'>\n").append("  <dataset name='").append(title).append("'>\n").append("    <catalogRef xlink:href='").append(catLink).append("' xlink:title='").append(catName).append("' name='' />\n").append("  </dataset>\n").append("</catalog>\n");
        return response;
    }

    private StringBuilder generateHtmlResponse(String title, String body) {
        StringBuilder response = new StringBuilder().append(this.getHtmlDoctypeAndOpenTag()).append("<head><title>").append(title).append("</title></head>").append("<body>").append("<h1>").append(title).append("</h1>").append(body).append("</body></html>");
        return response;
    }

    private String getHtmlDoctypeAndOpenTag() {
        return "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n" + "        \"http://www.w3.org/TR/html4/loose.dtd\">\n" + "<html>\n";
    }

    static enum StatusCode {
        SC_200("200", "OK"),
        SC_301("301", "Moved Permanently"),
        SC_302("302", "Found"),
        SC_305("305", "Use Proxy"),
        SC_307("307", "Temporary Redirect");

        private String scId;
        private String scMsg;

        private StatusCode(String id, String msg) {
            this.scId = id;
            this.scMsg = msg;
        }

        public String toString() {
            return this.scId;
        }

        public String getMessage() {
            return this.scMsg;
        }
    }

    static enum BodyType {
        HTML,
        XML,
        DAP;

    }
}

