/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.metadata;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Formatter;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import thredds.catalog.DataFormatType;
import thredds.catalog.ThreddsMetadata;
import thredds.catalog.parser.jdom.InvCatalogFactory10;
import thredds.server.metadata.MetadataRequestParameterBean;
import thredds.servlet.DatasetHandler;
import thredds.servlet.ServletUtil;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.thredds.MetadataExtractor;
import ucar.unidata.util.StringUtil2;

@Controller
@RequestMapping(value={"/metadata"})
public class MetadataController {
    private static Logger log = LoggerFactory.getLogger(MetadataController.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"**"})
    public void getMetadata(@Valid MetadataRequestParameterBean params, BindingResult result, HttpServletResponse res, HttpServletRequest req) throws IOException {
        if (result.hasErrors()) {
            res.sendError(400);
            return;
        }
        String path = ServletUtil.getRequestPath(req);
        path = path.substring(10);
        GridDataset gridDataset = null;
        try {
            String strResponse;
            boolean wantXML;
            gridDataset = DatasetHandler.openGridDataset(req, res, path);
            if (gridDataset == null) {
                res.setStatus(404);
                log.debug("DatasetHandler.FAIL path={}", (Object)path);
                return;
            }
            NetcdfFile ncfile = gridDataset.getNetcdfFile();
            String fileType = ncfile.getFileTypeId();
            DataFormatType fileFormat = DataFormatType.findType((String)fileType);
            ThreddsMetadata.Variables vars = MetadataExtractor.extractVariables((DataFormatType)fileFormat, (GridDataset)gridDataset);
            boolean bl = wantXML = params.getAccept() != null && params.getAccept().equalsIgnoreCase("XML");
            if (wantXML) {
                strResponse = this.writeXML(vars);
                res.setContentType("text/xml; charset=iso-8859-1");
            } else {
                strResponse = this.writeHTML(vars);
                res.setContentType("text/html; charset=iso-8859-1");
            }
            res.setContentLength(strResponse.length());
            PrintWriter pw = res.getWriter();
            pw.write(strResponse);
            pw.flush();
            res.flushBuffer();
        }
        catch (Throwable t) {
            log.error("Error", t);
            res.setStatus(500);
        }
        finally {
            if (gridDataset != null) {
                gridDataset.close();
            }
        }
    }

    public String writeHTML(ThreddsMetadata.Variables vars) {
        Formatter f = new Formatter();
        f.format("<h3>Variables:</h3>%n<ul>%n", new Object[0]);
        f.format("<em>Vocabulary</em> [", new Object[0]);
        if (vars.getVocabUri() != null) {
            URI uri = vars.getVocabUri();
            f.format(" %s", uri.toString());
        }
        f.format(" %s ]%n<ul>%n", StringUtil2.quoteHtmlContent((String)vars.getVocabulary()));
        List vlist = vars.getVariableList();
        if (vlist.size() > 0) {
            for (ThreddsMetadata.Variable v : vlist) {
                String units = v.getUnits() == null || v.getUnits().length() == 0 ? "" : " (" + v.getUnits() + ") ";
                f.format(" <li><strong>%s</strong>", StringUtil2.quoteHtmlContent((String)(v.getName() + units)));
                if (v.getDescription() != null) {
                    f.format(" = <i>%s</i>", StringUtil2.quoteHtmlContent((String)v.getDescription()));
                }
                if (v.getVocabularyName() != null && v.getVocabularyName().length() > 0) {
                    f.format(" = %s", StringUtil2.quoteHtmlContent((String)v.getVocabularyName()));
                }
                f.format("%n", new Object[0]);
            }
        }
        f.format("</ul>%n", new Object[0]);
        return f.toString();
    }

    private String writeXML(ThreddsMetadata.Variables vars) {
        Document doc = new Document();
        Element elem = new Element("variables", InvCatalogFactory10.defNS);
        doc.setRootElement(elem);
        if (vars.getVocabulary() != null) {
            elem.setAttribute("vocabulary", vars.getVocabulary());
        }
        if (vars.getVocabHref() != null) {
            elem.setAttribute("href", vars.getVocabHref(), InvCatalogFactory10.xlinkNS);
        }
        List varList = vars.getVariableList();
        for (ThreddsMetadata.Variable v : varList) {
            elem.addContent((Content)this.writeVariable(v));
        }
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        return fmt.outputString(doc);
    }

    private Element writeVariable(ThreddsMetadata.Variable v) {
        String id;
        String desc;
        Element elem = new Element("variable", InvCatalogFactory10.defNS);
        if (v.getName() != null) {
            elem.setAttribute("name", v.getName());
        }
        if (v.getDescription() != null && (desc = v.getDescription().trim()).length() > 0) {
            elem.setText(v.getDescription());
        }
        if (v.getVocabularyName() != null) {
            elem.setAttribute("vocabulary_name", v.getVocabularyName());
        }
        if (v.getUnits() != null) {
            elem.setAttribute("units", v.getUnits());
        }
        if ((id = v.getVocabularyId()) != null) {
            elem.setAttribute("vocabulary_id", id);
        }
        return elem;
    }
}

