/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset.controller;

import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import thredds.server.ncSubset.controller.AbstractNcssController;
import thredds.server.ncSubset.dataservice.NcssShowDatasetInfo;
import thredds.server.ncSubset.util.NcssRequestUtils;

@Controller
class DatasetInfoController
extends AbstractNcssController {
    private static final Logger log = LoggerFactory.getLogger(DatasetInfoController.class);
    @Autowired
    private NcssShowDatasetInfo ncssShowDatasetInfo;

    DatasetInfoController() {
    }

    @RequestMapping(value={"/ncss/grid/**/dataset.html", "/ncss/grid/**/dataset.xml", "/ncss/grid/**/pointDataset.html"})
    void getDatasetDescription(HttpServletRequest req, HttpServletResponse res) throws Exception {
        String pathInfo = this.requestPathInfo;
        boolean wantXML = pathInfo.endsWith("/dataset.xml");
        boolean showForm = pathInfo.endsWith("/dataset.html");
        boolean showPointForm = pathInfo.endsWith("/pointDataset.html");
        if (wantXML || showForm || showPointForm) {
            int len = pathInfo.length();
            if (wantXML) {
                pathInfo = pathInfo.substring(0, len - 12);
            } else if (showForm) {
                pathInfo = pathInfo.substring(0, len - 13);
            } else if (showPointForm) {
                pathInfo = pathInfo.substring(0, len - 18);
            }
            if (pathInfo.startsWith("/")) {
                pathInfo = pathInfo.substring(1);
            }
        }
        String strResponse = this.ncssShowDatasetInfo.showForm(this.getGridDataset(), this.buildDatasetUrl(pathInfo), wantXML, showPointForm);
        res.setContentLength(strResponse.length());
        if (wantXML) {
            res.setContentType("text/xml; charset=iso-8859-1");
        } else {
            res.setContentType("text/html; charset=UTF-8");
        }
        PrintWriter pw = res.getWriter();
        pw.write(strResponse);
        pw.flush();
        res.flushBuffer();
    }

    private String buildDatasetUrl(String path) {
        return NcssRequestUtils.getTdsContext().getContextPath() + "/ncss/grid" + "/" + path;
    }
}

