/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset.view.netcdf;

import java.io.IOException;
import java.util.List;
import thredds.server.ncSubset.view.netcdf.CFPointWriterWrapper;
import thredds.server.ncSubset.view.netcdf.WriterCFProfileCollectionWrapper;
import thredds.server.ncSubset.view.netcdf.WriterCFStationCollectionWrapper;
import thredds.server.ncSubset.view.netcdf.WriterCFTimeSeriesProfileCollectionWrapper;
import thredds.server.ncSubset.view.netcdf.WriterPointCollectionNoTimeWrapper;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.constants.CF;

public final class CFPointWriterWrapperFactory {
    private CFPointWriterWrapperFactory() {
    }

    public static final CFPointWriterWrapper getWriterForFeatureType(NetcdfFileWriter.Version version, CF.FeatureType featureType, String filePath, List<Attribute> atts) throws IOException {
        if (featureType == CF.FeatureType.timeSeries) {
            return WriterCFStationCollectionWrapper.createWrapper(version, filePath, atts);
        }
        if (featureType == CF.FeatureType.point) {
            return WriterPointCollectionNoTimeWrapper.createWrapper(version, filePath, atts);
        }
        if (featureType == CF.FeatureType.profile) {
            return WriterCFProfileCollectionWrapper.createWrapper(version, filePath, atts);
        }
        if (featureType == CF.FeatureType.timeSeriesProfile) {
            return WriterCFTimeSeriesProfileCollectionWrapper.createWrapper(version, filePath, atts);
        }
        throw new UnsupportedOperationException("Unsupported FeatureType: " + featureType.name());
    }
}

