/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.radarServer;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import thredds.server.config.TdsContext;
import thredds.server.ncSubset.QueryParams;
import thredds.server.radarServer.DatasetRepository;
import thredds.server.radarServer.RadarDatasetCollection;
import thredds.server.radarServer.RadarServerException;
import thredds.server.radarServer.RadarServerUtil;
import thredds.server.radarServer.RadarStationCollection;
import thredds.servlet.HtmlWriter;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;

public class QueryRadarServerController
extends AbstractController {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private TdsContext tdsContext;
    private HtmlWriter htmlWriter;
    private boolean htmlView;
    private boolean releaseDataset = false;
    private static final String CREATE_VIEW = "forward:badquery.htm";
    private static final String MODEL_KEY = "message";
    private static final String MSG_CODE = "message.bad.query";
    private static DateType epicDateType;
    static SimpleDateFormat dateFormat;

    public void setTdsContext(TdsContext tdsContext) {
        this.tdsContext = tdsContext;
    }

    public void setHtmlWriter(HtmlWriter htmlWriter) {
        this.htmlWriter = htmlWriter;
    }

    public boolean isHtmlView() {
        return this.htmlView;
    }

    public void setHtmlView(boolean htmlView) {
        this.htmlView = htmlView;
    }

    public boolean isReleaseDataset() {
        return this.releaseDataset;
    }

    public void setReleaseDataset(boolean releaseDataset) {
        this.releaseDataset = releaseDataset;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            if (request.getQueryString() == null) {
                this.log.info("Invalid dataset url reference " + request.getPathInfo());
                throw new RadarServerException("Invalid dataset url reference " + request.getPathInfo());
            }
            HashMap<String, Object> model = new HashMap<String, Object>();
            this.radarQuery(request, response, model);
            if (model == null || model.size() == 0) {
                ModelAndView mav = new ModelAndView(CREATE_VIEW);
                mav.addObject(MODEL_KEY, (Object)MSG_CODE);
                return mav;
            }
            return new ModelAndView("queryXml", model);
        }
        catch (RadarServerException e) {
            throw e;
        }
        catch (Throwable e) {
            this.log.error("handleRequestInternal(): Problem handling request.", e);
            throw new RadarServerException("handleRequestInternal(): Problem handling request.", e);
        }
    }

    public void radarQuery(HttpServletRequest req, HttpServletResponse res, Map<String, Object> model) throws ServletException, IOException, RadarServerException {
        DatasetRepository.RadarType radarType = DatasetRepository.RadarType.nexrad;
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            pathInfo = "";
        }
        if (pathInfo.startsWith("/")) {
            pathInfo = pathInfo.substring(1);
        }
        try {
            String rt = pathInfo.substring(0, pathInfo.indexOf(47, 1));
            radarType = DatasetRepository.RadarType.valueOf(rt);
        }
        catch (Exception e) {
            this.log.info("Invalid dataset url reference " + pathInfo);
            throw new RadarServerException("Invalid dataset url reference " + pathInfo, e);
        }
        Boolean level2 = pathInfo.contains("level2");
        QueryParams qp = new QueryParams();
        if (!qp.parseQuery(req, res, new String[]{"application/xml", "text/html", "text/plain", "application/x-netcdf"})) {
            return;
        }
        if (!this.checkQueryParms(radarType, qp, level2).booleanValue()) {
            this.log.error("checkQueryParms Failed " + qp.errs.toString() + req.getQueryString());
            throw new RadarServerException(qp.errs.toString());
        }
        qp.acceptType = qp.acceptType.replaceFirst(".*/", "");
        if (!this.createHeader(radarType, qp, pathInfo, model).booleanValue()) {
            this.log.error("Write Header Failed " + qp.errs.toString() + req.getQueryString());
            throw new RadarServerException(qp.errs.toString());
        }
        boolean dataFound = false;
        ArrayList<DatasetEntry> entries = new ArrayList<DatasetEntry>();
        if (qp.vars == null) {
            dataFound = this.processQuery(pathInfo, qp, null, entries);
            if (this.releaseDataset) {
                DatasetRepository.removeRadarDatasetCollection(pathInfo, null);
            }
        } else {
            int count = 0;
            for (String var : qp.vars) {
                dataFound = this.processQuery(pathInfo, qp, var, entries);
                if (dataFound) {
                    ++count;
                }
                if (!this.releaseDataset) continue;
                DatasetRepository.removeRadarDatasetCollection(pathInfo, var);
            }
            if (count > 0) {
                dataFound = true;
            }
        }
        model.put("datasets", entries);
        if (dataFound) {
            model.put("documentation", Integer.toString(entries.size()) + " datasets found for query");
        } else if (qp.errs.length() > 0) {
            model.put("documentation", qp.errs.toString());
        } else {
            model.put("documentation", "No data available for station(s) and time range");
        }
    }

    private Boolean checkQueryParms(DatasetRepository.RadarType radarType, QueryParams qp, Boolean level2) throws IOException {
        if (qp.hasBB) {
            qp.stns = radarType.equals((Object)DatasetRepository.RadarType.nexrad) ? RadarServerUtil.getStationNames(qp.getBB(), DatasetRepository.nexradList) : RadarServerUtil.getStationNames(qp.getBB(), DatasetRepository.terminalList);
            if (qp.stns.size() == 0) {
                qp.errs.append("Bounding Box contains no stations ");
                return false;
            }
            if (!level2.booleanValue()) {
                qp.stns = RadarServerUtil.convert4to3stations(qp.stns);
            }
        }
        if (qp.hasStns) {
            if (RadarServerUtil.isStationListEmpty(qp.stns, radarType)) {
                qp.errs.append("No valid stations specified, need 1 ");
                return false;
            }
            if (level2.booleanValue()) {
                for (String stn : qp.stns) {
                    if (stn.length() != 3) continue;
                    qp.errs.append("Need 4 character station names ");
                    return false;
                }
            } else if (!level2.booleanValue()) {
                qp.stns = RadarServerUtil.convert4to3stations(qp.stns);
            }
        }
        if (qp.hasLatlonPoint) {
            qp.stns = new ArrayList<String>();
            if (radarType.equals((Object)DatasetRepository.RadarType.nexrad)) {
                qp.stns.add(RadarServerUtil.findClosestStation(qp.lat, qp.lon, DatasetRepository.nexradList));
            } else {
                qp.stns.add(RadarServerUtil.findClosestStation(qp.lat, qp.lon, DatasetRepository.terminalList));
            }
            if (!level2.booleanValue()) {
                qp.stns = RadarServerUtil.convert4to3stations(qp.stns);
            }
        } else if (qp.fatal) {
            qp.errs.append("No valid stations specified 2 ");
            return false;
        }
        if (qp.stns == null || qp.stns.size() == 0) {
            qp.errs.append("No valid stations specified, need 1 ");
            return false;
        }
        boolean useAllStations = qp.stns.get(0).toUpperCase().equals("ALL");
        if (useAllStations) {
            qp.stns = radarType.equals((Object)DatasetRepository.RadarType.nexrad) ? RadarServerUtil.getStationNames(DatasetRepository.nexradList) : RadarServerUtil.getStationNames(DatasetRepository.terminalList);
            if (!level2.booleanValue()) {
                qp.stns = RadarServerUtil.convert4to3stations(qp.stns);
            }
        }
        if (qp.hasTimePoint) {
            if (qp.time.isPresent()) {
                try {
                    qp.time_end = new DateType("present", null, null);
                    qp.time_start = epicDateType;
                }
                catch (ParseException e) {
                    qp.errs.append("Illegal param= 'time' must be valid ISO Duration");
                    return false;
                }
            } else {
                qp.time_end = qp.time;
                qp.time_start = qp.time;
            }
        } else if (qp.hasDateRange) {
            DateRange dr = qp.getCalendarDateRange().toDateRange();
            qp.time_start = dr.getStart();
            qp.time_end = dr.getEnd();
        } else {
            qp.time_latest = 1;
            try {
                qp.time = new DateType("present", null, null);
                qp.time_end = new DateType("present", null, null);
                qp.time_start = epicDateType;
            }
            catch (ParseException e) {
                qp.errs.append("Illegal param= 'time' must be valid ISO Duration ");
                return false;
            }
        }
        if (level2.booleanValue()) {
            qp.vars = null;
        } else {
            if (qp.vars == null) {
                qp.errs.append("No vars selected ");
                return false;
            }
            if (qp.vars.get(0).contains("/")) {
                ArrayList<String> tmp = new ArrayList<String>();
                for (String var : qp.vars) {
                    tmp.add(var.replaceFirst("/.*", ""));
                }
                qp.vars = tmp;
            }
        }
        return true;
    }

    private Boolean createHeader(DatasetRepository.RadarType radarType, QueryParams qp, String pathInfo, Map<String, Object> model) throws IOException {
        Boolean level2 = pathInfo.contains("level2");
        int level = level2 != false ? 2 : 3;
        StringBuffer str = new StringBuffer();
        str.append("Radar Level").append(level).append(" datasets in near real time");
        model.put("name", str.toString());
        str.setLength(0);
        str.append("/thredds/dodsC/").append(pathInfo).append("/");
        model.put("base", str.toString());
        str.setLength(0);
        str.append("RadarLevel").append(level).append(" datasets for available stations and times");
        model.put("dname", str.toString());
        str.setLength(0);
        str.append("accept=").append(qp.acceptType).append("&");
        if (!level2.booleanValue() && qp.vars != null) {
            str.append("var=");
            for (int i = 0; i < qp.vars.size(); ++i) {
                str.append(qp.vars.get(i));
                if (i >= qp.vars.size() - 1) continue;
                str.append(",");
            }
            str.append("&");
        }
        if (qp.stns.get(0).toUpperCase().equals("ALL")) {
            str.append("stn=ALL&");
        } else if (qp.hasStns) {
            for (String station : qp.stns) {
                str.append("stn=").append(station).append("&");
            }
        } else if (qp.hasBB) {
            str.append("south=").append(qp.south).append("&north=").append(qp.north).append("&");
            str.append("west=").append(qp.west).append("&east=").append(qp.east).append("&");
        }
        if (qp.time_latest == 1) {
            str.append("time=present");
        } else if (qp.hasDateRange) {
            if (qp.time_start.getDate() == null || qp.time_start.isBlank() || qp.time_end.getDate() == null || qp.time_end.isBlank()) {
                str.append("time_start=").append(qp.time_start.toString());
                str.append("&time_end=").append(qp.time_end.toString());
                qp.errs.append("need ISO time format ");
                return false;
            }
            str.append("time_start=").append(qp.time_start.toDateTimeStringISO());
            str.append("&time_end=").append(qp.time_end.toDateTimeStringISO());
        } else if (qp.time.isPresent()) {
            str.append("time=present");
        } else if (qp.hasTimePoint) {
            if (qp.time.getDate() == null || qp.time.isBlank()) {
                str.append("time=").append(qp.time.toString());
                qp.errs.append("need ISO time format ");
                return false;
            }
            str.append("time=").append(qp.time.toDateTimeStringISO());
        }
        model.put("ID", str.toString());
        if (level2.booleanValue()) {
            model.put("type", "NEXRAD2");
        } else if (radarType.equals((Object)DatasetRepository.RadarType.nexrad)) {
            model.put("type", "NIDS");
        } else {
            model.put("type", "TDWR");
        }
        if (RadarServerUtil.isStationListEmpty(qp.stns, radarType)) {
            qp.errs.append("No station(s) meet query criteria ");
            return false;
        }
        return true;
    }

    private Boolean processQuery(String dataset, QueryParams qp, String var, List<DatasetEntry> entries) throws RadarServerException {
        Boolean getAllTimes = true;
        String yyyymmddStart = null;
        String yyyymmddEnd = null;
        String dateStart = null;
        String dateEnd = null;
        try {
            RadarDatasetCollection rdc;
            if (!qp.time_start.equals((Object)epicDateType)) {
                getAllTimes = false;
                yyyymmddStart = qp.time_start.toDateString();
                yyyymmddStart = yyyymmddStart.replace("-", "");
                yyyymmddEnd = qp.time_end.toDateString();
                yyyymmddEnd = yyyymmddEnd.replace("-", "");
                dateStart = yyyymmddStart + "_" + RadarServerUtil.hhmm(qp.time_start.toDateTimeString());
                dateEnd = yyyymmddEnd + "_" + RadarServerUtil.hhmm(qp.time_end.toDateTimeString());
            }
            if ((rdc = DatasetRepository.getRadarDatasetCollection(dataset, var)) == null) {
                qp.errs.append("Invalid dataset =").append(dataset);
                qp.errs.append(" or var =").append(var);
                return false;
            }
            StringBuffer time = new StringBuffer();
            StringBuffer product = new StringBuffer();
            StringBuffer url = new StringBuffer();
            boolean isLevel2 = dataset.contains("level2");
            String type = isLevel2 ? "Level2" : "Level3";
            String suffix = isLevel2 ? ".ar2v" : ".nids";
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            Date now = cal.getTime();
            String currentDay = dateFormat.format(now);
            block2: for (String stn : qp.stns) {
                RadarStationCollection rsc = rdc.queryStation(stn, currentDay);
                if (rsc == null) continue;
                for (String day : rsc.getDays()) {
                    DatasetEntry de;
                    ArrayList<String> tal;
                    if (!getAllTimes.booleanValue() && !RadarServerUtil.isValidDay(day, yyyymmddStart, yyyymmddEnd)) continue;
                    if (rdc.isCaseStudy()) {
                        tal = rsc.getHourMinute("all");
                        for (String prod : tal) {
                            if (!getAllTimes.booleanValue() && !RadarServerUtil.isValidDate(prod, dateStart, dateEnd)) continue;
                            de = new DatasetEntry();
                            int idx = prod.indexOf(47);
                            if (idx > 0) {
                                de.setName(prod.substring(idx + 1));
                            } else {
                                de.setName(prod);
                            }
                            de.setID(Integer.toString(prod.hashCode()));
                            url.setLength(0);
                            url.append(stn).append("/");
                            if (var != null) {
                                url.append(var).append("/");
                            }
                            url.append(prod);
                            de.setUrlPath(url.toString());
                            de.setDate(RadarServerUtil.getObTimeISO(prod));
                            entries.add(de);
                        }
                        continue;
                    }
                    tal = rsc.getHourMinute(day);
                    if (tal == null) continue;
                    for (String hm : tal) {
                        time.setLength(0);
                        time.append(day).append("_").append(hm);
                        if (!getAllTimes.booleanValue() && !RadarServerUtil.isValidDate(time.toString(), dateStart, dateEnd)) continue;
                        de = new DatasetEntry();
                        product.setLength(0);
                        product.append(type).append("_").append(rsc.getStnName()).append("_");
                        if (!isLevel2) {
                            product.append(var).append("_");
                        }
                        product.append(day).append("_").append(hm).append(suffix);
                        de.setName(product.toString());
                        de.setID(Integer.toString(product.toString().hashCode()));
                        url.setLength(0);
                        if (!isLevel2) {
                            url.append(var).append("/");
                        }
                        url.append(rsc.getStnName()).append("/").append(day).append("/").append(product.toString());
                        de.setUrlPath(url.toString());
                        de.setDate(RadarServerUtil.getObTimeISO(product.toString()));
                        entries.add(de);
                        if (!qp.hasTimePoint) continue;
                        break;
                    }
                    if (!qp.hasTimePoint) continue;
                    continue block2;
                }
            }
            return true;
        }
        catch (Throwable e) {
            this.log.error("Invalid dataset =" + dataset + " or var =" + var, e);
            throw new RadarServerException("Invalid dataset =" + dataset + " or var =" + var, e);
        }
    }

    static {
        try {
            epicDateType = new DateType("1970-01-01T00:00:00", null, null);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        dateFormat = new SimpleDateFormat("yyyyMMdd", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public class DatasetEntry {
        private String name;
        private String ID;
        private String urlPath;
        private String date;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getID() {
            return this.ID;
        }

        public void setID(String ID) {
            this.ID = ID;
        }

        public String getUrlPath() {
            return this.urlPath;
        }

        public void setUrlPath(String urlPath) {
            this.urlPath = urlPath;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }
    }
}

