/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wms;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import thredds.catalog.InvAccess;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.ServiceType;
import thredds.servlet.ServletUtil;
import thredds.servlet.ThreddsConfig;
import thredds.servlet.Viewer;

public class Godiva2Viewer
implements Viewer {
    @Override
    public boolean isViewable(InvDatasetImpl ds) {
        InvAccess access = ds.getAccess(ServiceType.WMS);
        return access != null && ThreddsConfig.getBoolean("WMS.allow", false);
    }

    @Override
    public String getViewerLinkHtml(InvDatasetImpl ds, HttpServletRequest req) {
        InvAccess access = ds.getAccess(ServiceType.WMS);
        URI dataURI = access.getStandardUri();
        try {
            URI base = new URI(req.getRequestURL().toString());
            dataURI = base.resolve(dataURI);
        }
        catch (URISyntaxException e) {
            return "Error generating viewer link";
        }
        return "<a href='" + ServletUtil.getContextPath() + "/godiva2/godiva2.html?server=" + dataURI.toString() + "'>Godiva2 (browser-based)</a>";
    }
}

