/*
 * Decompiled with CFR 0.152.
 */
package thredds.dqc.server.latest;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvService;
import thredds.catalog.parser.jdom.InvCatalogFactory10;
import thredds.catalog.query.DqcFactory;
import thredds.catalog.query.ListChoice;
import thredds.catalog.query.Query;
import thredds.catalog.query.QueryCapability;
import thredds.catalog.query.SelectList;
import thredds.catalog.query.SelectService;
import thredds.catalog.query.Selector;
import thredds.dqc.server.DqcHandler;
import thredds.dqc.server.latest.LatestConfig;
import thredds.dqc.server.latest.LatestConfigFactory;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.util.net.EscapeStrings;

public class LatestDqcHandler
extends DqcHandler {
    private static Logger log = LoggerFactory.getLogger(LatestDqcHandler.class);
    protected LatestConfig config;

    @Override
    public void handleRequest(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String reqPath = req.getPathInfo();
        String extraPath = reqPath.substring(this.getHandlerInfo().getName().length() + 1);
        if (extraPath.equals(".xml")) {
            QueryCapability dqc = this.createDqcDocument(req.getContextPath() + req.getServletPath() + "/" + this.getHandlerInfo().getName());
            DqcFactory dqcFactory = new DqcFactory(false);
            String dqcAsString = dqcFactory.writeXML(dqc);
            PrintWriter out = res.getWriter();
            res.setContentType("text/xml");
            res.setStatus(200);
            out.print(dqcAsString);
            return;
        }
        if (extraPath.length() > 0) {
            String tmpMsg = "Extra path information <" + extraPath + "> not understood.";
            res.sendError(400, tmpMsg);
            return;
        }
        String reqItemId = EscapeStrings.unescapeOGC((String)req.getQueryString());
        if (reqItemId == null) {
            String tmpMsg = "No latest request ID given.";
            res.sendError(404, "LatestDqcHandler.handleRequest(): " + tmpMsg);
            return;
        }
        log.debug("Request for the latest \"" + reqItemId + "\".");
        LatestConfig.Item reqItem = this.config.getItem(reqItemId);
        if (reqItem == null) {
            String tmpMsg = "The Item requested, " + reqItemId + ", is not supported.";
            res.sendError(404, "LatestDqcHandler.handleRequest(): " + tmpMsg);
            return;
        }
        String reqItemName = reqItem.getName();
        File dir = new File(reqItem.getDirLocation());
        log.debug("handleRequest(): requested Item <id=" + reqItemId + ", name=" + reqItemName + ", dir=" + dir.getPath() + "> is supported.");
        if (!dir.isDirectory()) {
            log.error("handleRequest(): Directory <" + dir.getPath() + "> given by configuration item <id=" + reqItemId + "> is not a directory.");
            res.sendError(500, "Directory given by config item <id=" + reqItemId + "> is not a directory.");
            return;
        }
        File mostRecentDs = this.findLatestDataset(reqItem, dir.listFiles());
        if (mostRecentDs != null) {
            String catalogAsString = this.createCatalog(mostRecentDs, reqItem);
            if (catalogAsString == null) {
                String tmpMsg = "Could not generate a catalog, unsupported InvCat spec version <" + reqItem.getInvCatSpecVersion() + ">.";
                log.error("handleRequest(): " + tmpMsg);
                res.sendError(500, tmpMsg);
                return;
            }
            PrintWriter out = res.getWriter();
            res.setContentType("text/xml");
            res.setStatus(200);
            out.print(catalogAsString);
            return;
        }
        String tmpMsg = "No latest dataset found for request<" + reqItemId + ">.";
        res.sendError(404, tmpMsg);
    }

    @Override
    public void initWithHandlerConfigDoc(URL configDocURL) throws IOException {
        log.debug("initWithHandlerConfigDoc(): open config document <" + configDocURL.toString() + "> and read config information.");
        InputStream is = configDocURL.openStream();
        this.config = LatestConfigFactory.parseXML(is, configDocURL.toString());
        if (this.config == null) {
            String tmpMsg = "Failed to parse config doc <" + configDocURL.toString() + ">.";
            log.error("initWithHandlerConfigDoc(): " + tmpMsg);
            throw new IOException(tmpMsg);
        }
        ArrayList<String> badDirItemIDs = new ArrayList<String>();
        Iterator it = this.config.getIds().iterator();
        while (it.hasNext()) {
            LatestConfig.Item curItem = this.config.getItem((String)it.next());
            File dir = new File(curItem.getDirLocation());
            if (dir.isDirectory()) continue;
            log.warn("initWithHandlerConfigDoc(): Directory <" + dir.getAbsolutePath() + "> is not a directory; config item<id=" + curItem.getId() + "> being removed.");
            badDirItemIDs.add(curItem.getId());
        }
        for (String curItemID : badDirItemIDs) {
            if (this.config.removeItem(curItemID)) continue;
            log.warn("initWithHandlerConfigDoc(): Bad Item <id=" + curItemID + "> not removed.");
        }
        if (this.config.isEmpty()) {
            String tmpMsg = "No configuration info.";
            log.error("initWithHandlerConfigDoc(): " + tmpMsg);
            throw new IOException(tmpMsg);
        }
    }

    protected File findLatestDataset(LatestConfig.Item reqItem, File[] allFiles) {
        File mostRecentDs = null;
        Date mostRecentDsDate = null;
        File curDs = null;
        Date curDsDate = null;
        log.debug("findLatestDataset(): getting dir listing.");
        for (int i = 0; i < allFiles.length; ++i) {
            curDs = allFiles[i];
            curDsDate = this.getDatasetDate(curDs, reqItem);
            log.debug("findLatestDataset(): current dataset is <" + curDs.getName() + ">.");
            if (curDsDate == null) continue;
            if (mostRecentDs == null) {
                mostRecentDs = curDs;
                mostRecentDsDate = curDsDate;
            } else if (mostRecentDsDate.before(curDsDate)) {
                mostRecentDs = curDs;
                mostRecentDsDate = curDsDate;
            }
            log.debug("findLatestDataset(): the most recent dataset <" + mostRecentDs.getName() + "> has date <" + mostRecentDsDate + ">.");
        }
        return mostRecentDs;
    }

    protected QueryCapability createDqcDocument(String baseURI) {
        QueryCapability dqc = new QueryCapability(null, this.getHandlerInfo().getName() + " DQC Document", "0.3");
        Query query = new Query(baseURI, null, null);
        dqc.setQuery(query);
        SelectService selectService = new SelectService("service", "Select service type.");
        selectService.addServiceChoice("OpenDAP", "OPeNDAP/DODS", null, null, null);
        selectService.setRequired("false");
        dqc.addUniqueSelector((Selector)selectService);
        dqc.setServiceSelector((Selector)selectService);
        SelectList selectList = new SelectList("Model name", "models", null, "true", "false");
        Iterator it = this.config.getIds().iterator();
        while (it.hasNext()) {
            LatestConfig.Item curConfigItem = this.config.getItem((String)it.next());
            ListChoice curChoice = new ListChoice((Selector)selectList, curConfigItem.getId(), curConfigItem.getName(), null);
            selectList.addChoice(curChoice);
        }
        dqc.addUniqueSelector((Selector)selectList);
        return dqc;
    }

    protected InvCatalogImpl createCatalog(String catName, String dsName, FeatureType dsType, String serviceType, String serviceName, String serviceBaseURL, String urlPath) {
        log.debug("createCatalog(): creating createCatalog/dataset.");
        InvCatalogImpl catalog = new InvCatalogImpl(catName, null, null);
        InvService myService = new InvService(serviceName, serviceType, serviceBaseURL, null, null);
        InvDatasetImpl topDs = new InvDatasetImpl(null, dsName, dsType, serviceName, urlPath);
        catalog.addService(myService);
        catalog.addDataset(topDs);
        catalog.finish();
        log.debug("createCatalog(): createCatalog/dataset created.");
        return catalog;
    }

    protected String createCatalog(File mostRecentDs, LatestConfig.Item reqItem) throws IOException {
        String urlPath = mostRecentDs.getName();
        Date mostRecentDsDate = this.getDatasetDate(mostRecentDs, reqItem);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH'Z'", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String mostRecentDsName = "Latest " + reqItem.getName() + " (" + dateFormat.format(mostRecentDsDate) + ")";
        log.debug("handleRequest(): Latest dataset <" + mostRecentDs.getAbsolutePath() + "> named \"" + mostRecentDsName + "\".");
        String catalogName = null;
        if (reqItem.getInvCatSpecVersion().equals("0.6")) {
            catalogName = mostRecentDsName;
        }
        InvCatalogImpl catalog = this.createCatalog(catalogName, mostRecentDsName, FeatureType.GRID, "DODS", "mlode", reqItem.getServiceBaseURL(), urlPath);
        InvCatalogFactory fac = InvCatalogFactory.getDefaultFactory((boolean)true);
        String catalogAsString = null;
        if (reqItem.getInvCatSpecVersion().equals("0.6")) {
            log.warn("createCatalog(): LatestDqcHandler configured to generate \"0.6\" InvCatalogs. Version \"0.6\" no longer supported.");
        } else if (reqItem.getInvCatSpecVersion().startsWith("1.0")) {
            InvCatalogFactory10 fac10 = (InvCatalogFactory10)fac.getCatalogConverter("http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0");
            fac10.setVersion(reqItem.getInvCatSpecVersion());
            ByteArrayOutputStream osCat = new ByteArrayOutputStream(10000);
            fac10.writeXML(catalog, (OutputStream)osCat);
            catalogAsString = osCat.toString();
        }
        return catalogAsString;
    }

    protected Date getDatasetDate(File theFile, LatestConfig.Item reqItem) {
        Pattern pattern = Pattern.compile(reqItem.getDatasetNameMatchPattern());
        Matcher matcher = pattern.matcher(theFile.getName());
        if (!matcher.find()) {
            log.warn("getDatasetDate(): File name <" + theFile.getName() + "> didn't match pattern <" + reqItem.getDatasetNameMatchPattern() + ">.");
            return null;
        }
        StringBuffer dateString = new StringBuffer();
        matcher.appendReplacement(dateString, reqItem.getDatasetTimeSubstitutionPattern());
        dateString.delete(0, matcher.start());
        if (dateString.length() > 0) {
            Date theDate;
            String dateFormatString = "yyyy-MM-dd'T'HH:mm:ss";
            String dateFormatAltString = "yyyy/MM/dd HH:mm";
            SimpleDateFormat dateFormat = new SimpleDateFormat(dateFormatString, Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            try {
                theDate = dateFormat.parse(dateString.toString());
            }
            catch (ParseException e) {
                log.debug("getDatasetDate(): Failed to parse date with format \"" + dateFormatString + "\": " + e.getMessage());
                dateFormat = new SimpleDateFormat(dateFormatAltString, Locale.US);
                dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                try {
                    theDate = dateFormat.parse(dateString.toString());
                }
                catch (ParseException e1) {
                    log.warn("getDatasetDate(): Failed to parse date with either format \"" + dateFormatString + "\" or \"" + dateFormatAltString + "\": " + e.getMessage());
                    return null;
                }
            }
            log.debug("getDatasetDate(): Got date <" + dateString + " - " + theDate.toString() + "> from file name <" + theFile.getName() + ">.");
            return theDate;
        }
        log.warn("getDatasetDate(): File name <" + theFile.getName() + ">, match pattern <" + reqItem.getDatasetNameMatchPattern() + ">, and sub pattern <" + reqItem.getDatasetTimeSubstitutionPattern() + "> produced a zero length date string.");
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("LatestDqcHandler[");
        buf.append(this.config.toString());
        buf.append("\n]");
        return buf.toString();
    }
}

