/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset.format;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum SupportedFormat {
    CSV("CSV", "text/plain", "text/csv", "csv"),
    XML("XML", "application/xml", "text/xml", "xml"),
    NETCDF3("NETCDF3", "application/x-netcdf", "netcdf"),
    NETCDF4("NETCDF4", "application/x-netcdf4", "netcdf4");

    private final List<String> aliases;
    private final String formatName;

    private SupportedFormat(String formatName, String ... aliases) {
        this.formatName = formatName;
        ArrayList<String> aliasesList = new ArrayList<String>();
        for (String alias : aliases) {
            aliasesList.add(alias);
        }
        this.aliases = Collections.unmodifiableList(aliasesList);
    }

    public String getFormatName() {
        return this.formatName;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public String getResponseContentType() {
        return this.aliases.get(0);
    }
}

