/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset.view.netcdf;

import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.ncSubset.view.netcdf.CFPointWriterUtils;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.ft.point.writer.CFPointWriter;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.LatLonRect;

class WriterPointCollectionNoTime
extends CFPointWriter {
    private Variable lat;
    private Variable lon;
    private Variable alt;
    private Variable record;
    private int recno = 0;
    private ArrayDouble.D1 latArray = new ArrayDouble.D1(1);
    private ArrayDouble.D1 lonArray = new ArrayDouble.D1(1);
    private ArrayDouble.D1 altArray = new ArrayDouble.D1(1);
    private int[] origin = new int[1];
    private static Logger log = LoggerFactory.getLogger(WriterPointCollectionNoTime.class);

    protected WriterPointCollectionNoTime(NetcdfFileWriter.Version version, String fileOut, List<Attribute> atts) throws IOException {
        super(fileOut, atts, version);
    }

    public void writeHeader(List<VariableSimpleIF> vars, String altUnits) throws IOException {
        this.altUnits = altUnits;
        this.createCoordinates();
        this.createDataVariables(vars);
        this.writer.create();
        this.record = this.writer.addRecordStructure();
    }

    public void writeRecord(EarthLocation loc, StructureData sdata) throws IOException {
        ArrayStructureW sArray = new ArrayStructureW(sdata.getStructureMembers(), new int[]{1});
        sArray.setStructureData(sdata, 0);
        this.latArray.set(0, loc.getLatitude());
        this.lonArray.set(0, loc.getLongitude());
        if (this.altUnits != null) {
            this.altArray.set(0, loc.getAltitude());
        }
        this.origin[0] = this.recno;
        try {
            for (StructureMembers.Member m : sdata.getMembers()) {
                if (this.writer.findVariable(m.getName()) == null) continue;
                Array arr = CFPointWriterUtils.getArrayFromMember(this.writer.findVariable(m.getName()), m);
                this.writer.write(this.writer.findVariable(m.getName()), this.origin, arr);
            }
            this.writer.write(this.lat, this.origin, (Array)this.latArray);
            this.writer.write(this.lon, this.origin, (Array)this.lonArray);
            if (this.altUnits != null) {
                this.writer.write(this.alt, this.origin, (Array)this.altArray);
            }
            this.trackBB(loc);
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        ++this.recno;
    }

    private void createCoordinates() {
        this.writer.addUnlimitedDimension("obs");
        this.lat = this.writer.addVariable(null, "latitude", DataType.DOUBLE, "obs");
        this.writer.addVariableAttribute(this.lat, new Attribute("units", "degrees_north"));
        this.writer.addVariableAttribute(this.lat, new Attribute("long_name", "station latitude"));
        this.lon = this.writer.addVariable(null, "longitude", DataType.DOUBLE, "obs");
        this.writer.addVariableAttribute(this.lon, new Attribute("units", "degrees_east"));
        this.writer.addVariableAttribute(this.lon, new Attribute("long_name", "station longitude"));
        if (this.altUnits != null) {
            this.alt = this.writer.addVariable(null, "altitude", DataType.DOUBLE, "obs");
            this.writer.addVariableAttribute(this.alt, new Attribute("units", this.altUnits));
            this.writer.addVariableAttribute(this.alt, new Attribute("long_name", "altitude"));
        }
    }

    private void createDataVariables(List<VariableSimpleIF> dataVars) throws IOException {
        List dims;
        String coordNames = "latitude longitude";
        if (this.altUnits != null) {
            coordNames = coordNames + " " + "altitude";
        }
        for (VariableSimpleIF var : dataVars) {
            dims = var.getDimensions();
            this.dimSet.addAll(dims);
        }
        for (Dimension d : this.dimSet) {
            if (d.isUnlimited()) continue;
            this.writer.addDimension(null, d.getName(), d.getLength(), d.isShared(), false, d.isVariableLength());
        }
        for (VariableSimpleIF oldVar : dataVars) {
            dims = oldVar.getDimensions();
            StringBuilder dimNames = new StringBuilder("obs");
            for (Dimension d : dims) {
                if (d.isUnlimited()) continue;
                dimNames.append(" ").append(d.getName());
            }
            Variable newVar = this.writer.addVariable(null, oldVar.getShortName(), oldVar.getDataType(), dimNames.toString());
            List atts = oldVar.getAttributes();
            for (Attribute att : atts) {
                newVar.addAttribute(att);
            }
            newVar.addAttribute(new Attribute("coordinates", coordNames));
        }
    }

    protected void trackBB(EarthLocation loc) {
        if (loc != null) {
            if (this.llbb == null) {
                this.llbb = new LatLonRect(loc.getLatLon(), 0.001, 0.001);
                return;
            }
            this.llbb.extend(loc.getLatLon());
        }
    }
}

