/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.radarServer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDatasetScan;
import thredds.catalog.ThreddsMetadata;
import thredds.server.config.TdsContext;
import thredds.server.radarServer.DatasetRepository;
import thredds.server.radarServer.RadarServerException;
import thredds.servlet.HtmlWriter;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.geoloc.LatLonRect;

public class CatalogRadarServerController
extends AbstractController {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private TdsContext tdsContext;
    private HtmlWriter htmlWriter;
    private boolean htmlView;
    private static final String CREATE_VIEW = "forward:createdataset.htm";
    private static final String MODEL_KEY = "message";
    private static final String MSG_CODE = "message.create.dataset";

    public void setTdsContext(TdsContext tdsContext) {
        this.tdsContext = tdsContext;
    }

    public void setHtmlWriter(HtmlWriter htmlWriter) {
        this.htmlWriter = htmlWriter;
    }

    public boolean isHtmlView() {
        return this.htmlView;
    }

    public void setHtmlView(boolean htmlView) {
        this.htmlView = htmlView;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String pathInfo = request.getPathInfo();
            if (pathInfo == null) {
                pathInfo = "";
            }
            if (pathInfo.startsWith("/")) {
                pathInfo = pathInfo.substring(1);
            }
            InvCatalogImpl catalog = DatasetRepository.cat;
            if (!pathInfo.startsWith("dataset.xml") && !pathInfo.startsWith("catalog.xml")) {
                if (pathInfo.contains("level2/catalog.") || pathInfo.contains("level3/catalog.") || pathInfo.contains("level2/dataset.") || pathInfo.contains("level3/dataset.")) {
                    catalog = this.level2level3catalog(catalog, pathInfo);
                } else if (pathInfo.endsWith("dataset.xml") || pathInfo.endsWith("catalog.xml")) {
                    Map<String, Object> model = this.datasetInfoXml(catalog, pathInfo);
                    if (model != null) {
                        return new ModelAndView("datasetXml", model);
                    }
                    this.log.info("Dataset problem");
                    throw new RadarServerException("Dataset problem");
                }
            }
            if (catalog == null) {
                ModelAndView mav = new ModelAndView(CREATE_VIEW);
                mav.addObject(MODEL_KEY, (Object)MSG_CODE);
                return mav;
            }
            if (this.htmlView) {
                int i = HtmlWriter.getInstance().writeCatalog(request, response, catalog, true);
                return null;
            }
            return new ModelAndView("threddsInvCatXmlView", "catalog", (Object)catalog);
        }
        catch (RadarServerException e) {
            throw e;
        }
        catch (Throwable e) {
            this.log.error("handleRequestInternal(): Problem handling request.", e);
            throw new RadarServerException("handleRequestInternal(): Problem handling request.", e);
        }
    }

    private InvCatalogImpl level2level3catalog(InvCatalogImpl cat, String pathInfo) throws RadarServerException, IOException {
        InvCatalogImpl tCat = null;
        try {
            String dsPath;
            if (pathInfo.indexOf("/dataset") > 0) {
                dsPath = pathInfo.substring(0, pathInfo.indexOf("/dataset"));
            } else if (pathInfo.indexOf("/catalog") > 0) {
                dsPath = pathInfo.substring(0, pathInfo.indexOf("/catalog"));
            } else {
                this.log.error("RadarServer.datasetInfoXml", (Object)"Invalid url request");
                throw new RadarServerException("Invalid url request");
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream(10000);
            InvCatalogFactory factory = InvCatalogFactory.getDefaultFactory((boolean)false);
            factory.writeXML(cat, (OutputStream)os, true);
            tCat = factory.readXML((InputStream)new ByteArrayInputStream(os.toByteArray()), DatasetRepository.catURI);
            Iterator parents = tCat.getDatasets().iterator();
            while (parents.hasNext()) {
                ArrayList<InvDatasetImpl> delete = new ArrayList<InvDatasetImpl>();
                InvDatasetImpl top = (InvDatasetImpl)parents.next();
                for (InvDatasetImpl ds : top.getDatasets()) {
                    InvDatasetScan ids;
                    if (!(ds instanceof InvDatasetScan) || (ids = (InvDatasetScan)ds).getPath() == null) continue;
                    if (ids.getPath().contains(dsPath)) {
                        ids.setXlinkHref(ids.getPath() + "/dataset.xml");
                        continue;
                    }
                    delete.add(ds);
                }
                for (InvDatasetImpl idi : delete) {
                    top.removeDataset(idi);
                }
            }
        }
        catch (Throwable e) {
            this.log.error("RadarServer.level2level3catalog", (Object)"Invalid url request");
            throw new RadarServerException("Invalid catalog request", e);
        }
        return tCat;
    }

    private Map<String, Object> datasetInfoXml(InvCatalogImpl cat, String pathInfo) throws RadarServerException, IOException {
        HashMap<String, Object> model = new HashMap<String, Object>();
        InvDatasetScan ds = null;
        boolean found = false;
        try {
            String dsPath;
            if (pathInfo.indexOf("/dataset") > 0) {
                dsPath = pathInfo.substring(0, pathInfo.indexOf("/dataset"));
            } else if (pathInfo.indexOf("/catalog") > 0) {
                dsPath = pathInfo.substring(0, pathInfo.indexOf("/catalog"));
            } else {
                this.log.error("RadarServer.datasetInfoXml", (Object)"Invalid url request");
                throw new RadarServerException("Invalid url request");
            }
            Iterator parents = cat.getDatasets().iterator();
            InvDatasetImpl top = (InvDatasetImpl)parents.next();
            for (InvDatasetImpl idsi : top.getDatasets()) {
                if (!(idsi instanceof InvDatasetScan) || (ds = (InvDatasetScan)idsi).getPath() == null || !ds.getPath().contains(dsPath)) continue;
                found = true;
                break;
            }
        }
        catch (Throwable e) {
            this.log.error("RadarServer.datasetInfoXml", e);
            throw new RadarServerException("CatalogRadarServerController.datasetInfoXml", e);
        }
        if (!found) {
            this.log.error("RadarServer.datasetInfoXml", (Object)"Invalid url request");
            throw new RadarServerException("Invalid url request");
        }
        model.put("ID", ds.getID());
        model.put("urlPath", ds.getPath());
        model.put("dataFormat", ds.getDataFormatType());
        model.put("documentation", ds.getSummary());
        CalendarDateRange dr = ds.getCalendarDateCoverage();
        model.put("tstart", dr.getStart().toString());
        model.put("tend", dr.getEnd().toString());
        ThreddsMetadata.GeospatialCoverage gc = ds.getGeospatialCoverage();
        LatLonRect bb = new LatLonRect();
        gc.setBoundingBox(bb);
        model.put("north", gc.getLatNorth());
        model.put("south", gc.getLatSouth());
        model.put("east", gc.getLonEast());
        model.put("west", gc.getLonWest());
        ThreddsMetadata.Variables cvs = (ThreddsMetadata.Variables)ds.getVariables().get(0);
        List vl = cvs.getVariableList();
        ArrayList<RsVar> variables = new ArrayList<RsVar>();
        for (int j = 0; j < vl.size(); ++j) {
            ThreddsMetadata.Variable v = (ThreddsMetadata.Variable)vl.get(j);
            RsVar rsv = new RsVar();
            rsv.setName(v.getName());
            rsv.setVname(v.getVocabularyName());
            rsv.setUnits(v.getUnits());
            variables.add(rsv);
        }
        model.put("variables", variables);
        return model;
    }

    public class RsVar {
        private String name;
        private String vname;
        private String units;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVname() {
            return this.vname;
        }

        public void setVname(String vname) {
            this.vname = vname;
        }

        public String getUnits() {
            return this.units;
        }

        public void setUnits(String units) {
            this.units = units;
        }
    }
}

