/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wms;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import thredds.server.wms.ThreddsLayer;
import thredds.server.wms.ThreddsScalarLayer;
import thredds.server.wms.ThreddsVectorLayer;
import thredds.server.wms.config.WmsDetailedConfig;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import uk.ac.rdg.resc.edal.cdm.CdmUtils;
import uk.ac.rdg.resc.edal.cdm.DataReadingStrategy;
import uk.ac.rdg.resc.edal.coverage.CoverageMetadata;
import uk.ac.rdg.resc.ncwms.util.WmsUtils;
import uk.ac.rdg.resc.ncwms.wms.Dataset;
import uk.ac.rdg.resc.ncwms.wms.Layer;
import uk.ac.rdg.resc.ncwms.wms.VectorLayer;

public class ThreddsDataset
implements Dataset {
    private final String urlPath;
    private final String title;
    private final Map<String, ThreddsScalarLayer> scalarLayers = new LinkedHashMap<String, ThreddsScalarLayer>();
    private final Map<String, ThreddsVectorLayer> vectorLayers = new LinkedHashMap<String, ThreddsVectorLayer>();

    public ThreddsDataset(String urlPath, GridDataset gridDataset, WmsDetailedConfig wmsConfig) throws IOException {
        this.urlPath = urlPath;
        this.title = gridDataset.getTitle();
        NetcdfDataset ncDataset = (NetcdfDataset)gridDataset.getNetcdfFile();
        DataReadingStrategy drStrategy = CdmUtils.getOptimumDataReadingStrategy((NetcdfDataset)ncDataset);
        Collection ccm = CdmUtils.readCoverageMetadata((GridDataset)gridDataset);
        for (CoverageMetadata cm : ccm) {
            GridDatatype gdt = gridDataset.findGridDatatype(cm.getId());
            ThreddsScalarLayer tsl = ThreddsScalarLayer.getNewLayer(cm, gdt, drStrategy, this, wmsConfig);
            this.scalarLayers.put(tsl.getName(), tsl);
        }
        List vectorLayersColl = WmsUtils.findVectorLayers(this.scalarLayers.values());
        for (VectorLayer vecLayer : vectorLayersColl) {
            ThreddsVectorLayer tdsVecLayer = new ThreddsVectorLayer(vecLayer);
            tdsVecLayer.setLayerSettings(wmsConfig.getSettings(tdsVecLayer));
            this.vectorLayers.put(vecLayer.getId(), tdsVecLayer);
        }
    }

    public String getId() {
        return this.urlPath;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDatasetPath() {
        return this.urlPath;
    }

    public DateTime getLastUpdateTime() {
        return new DateTime();
    }

    public ThreddsLayer getLayerById(String layerId) {
        ThreddsLayer layer = this.scalarLayers.get(layerId);
        if (layer == null) {
            layer = this.vectorLayers.get(layerId);
        }
        return layer;
    }

    public Set<Layer> getLayers() {
        LinkedHashSet<Layer> layerSet = new LinkedHashSet<Layer>();
        layerSet.addAll(this.scalarLayers.values());
        layerSet.addAll(this.vectorLayers.values());
        return layerSet;
    }

    public String getCopyrightStatement() {
        return "";
    }

    public String getMoreInfoUrl() {
        return "";
    }

    public boolean isReady() {
        return true;
    }

    public boolean isLoading() {
        return false;
    }

    public boolean isError() {
        return false;
    }

    public Exception getException() {
        return null;
    }

    public boolean isDisabled() {
        return false;
    }
}

