/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import thredds.catalog.DataRootConfig;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetFeatureCollection;
import thredds.catalog.InvDatasetFmrc;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDatasetScan;
import thredds.catalog.InvProperty;
import thredds.catalog.InvService;
import thredds.cataloggen.ProxyDatasetHandler;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetDods;
import thredds.crawlabledataset.CrawlableDatasetFile;
import thredds.inventory.bdb.MetadataManager;
import thredds.server.config.AllowableService;
import thredds.server.config.TdsContext;
import thredds.servlet.DataServiceProvider;
import thredds.servlet.DatasetHandler;
import thredds.servlet.DebugHandler;
import thredds.servlet.PathMatcher;
import thredds.servlet.RestrictedAccessConfigListener;
import thredds.servlet.ServletUtil;
import thredds.servlet.ThreddsConfig;
import thredds.util.PathAliasReplacement;
import thredds.util.RequestForwardUtils;
import thredds.util.StartsWithPathAliasReplacement;
import thredds.util.TdsPathUtils;
import ucar.nc2.constants.CDM;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.DateType;
import ucar.unidata.util.StringUtil2;

@Component
public final class DataRootHandler
implements InitializingBean {
    private static Logger log = LoggerFactory.getLogger(DataRootHandler.class);
    private static Logger logCatalogInit = LoggerFactory.getLogger((String)(DataRootHandler.class.getName() + ".catalogInit"));
    private static Logger startupLog = LoggerFactory.getLogger((String)"serverStartup");
    private static DataRootHandler singleton = null;
    @Autowired
    private TdsContext tdsContext;
    private boolean staticCache;
    private HashMap<String, InvCatalogImpl> staticCatalogHash;
    private Set<String> staticCatalogNames;
    private HashSet<String> idHash = new HashSet();
    private volatile PathMatcher pathMatcher = new PathMatcher();
    private List<ConfigListener> configListeners = new ArrayList<ConfigListener>();
    private List<PathAliasReplacement> dataRootLocationAliasExpanders = new ArrayList<PathAliasReplacement>();
    volatile boolean isReinit = false;

    public static void setInstance(DataRootHandler drh) {
        if (singleton != null) {
            log.warn("setInstance(): Singleton already set: ignoring call.");
            return;
        }
        singleton = drh;
    }

    public static DataRootHandler getInstance() {
        if (singleton == null) {
            logCatalogInit.error("getInstance(): Called without setInstance() having been called.");
            throw new IllegalStateException("setInstance() must be called first.");
        }
        return singleton;
    }

    private DataRootHandler(TdsContext tdsContext) {
        this.tdsContext = tdsContext;
    }

    private DataRootHandler() {
    }

    @Resource(name="dataRootLocationAliasExpanders")
    public void setDataRootLocationAliasExpanders(Map<String, String> aliases) {
        for (String key : aliases.keySet()) {
            String value = aliases.get(key);
            if (value == null || value.isEmpty()) continue;
            this.dataRootLocationAliasExpanders.add(new StartsWithPathAliasReplacement("${" + key + "}", value));
        }
    }

    public void afterPropertiesSet() {
        this.registerConfigListener(new RestrictedAccessConfigListener());
        String contentReplacementPath = StringUtils.cleanPath((String)this.tdsContext.getPublicDocFileSource().getFile("").getPath());
        this.dataRootLocationAliasExpanders.add(new StartsWithPathAliasReplacement("content", contentReplacementPath));
        this.initCatalogs();
        this.makeDebugActions();
        DatasetHandler.makeDebugActions();
        DataRootHandler.setInstance(this);
    }

    private void getExtraCatalogs(List<String> extraList) {
        ThreddsConfig.getCatalogRoots(extraList);
        if (extraList.size() > 0) {
            return;
        }
        File file = this.tdsContext.getConfigFileSource().getFile("extraCatalogs.txt");
        if (file != null && file.exists()) {
            try {
                String line;
                FileInputStream fin = new FileInputStream(file);
                BufferedReader reader = new BufferedReader(new InputStreamReader(fin));
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                    extraList.add(line);
                }
                fin.close();
            }
            catch (IOException e) {
                logCatalogInit.error("Error on getExtraCatalogs ", (Throwable)e);
            }
        }
    }

    public boolean registerConfigListener(ConfigListener cl) {
        if (cl == null) {
            return false;
        }
        if (this.configListeners.contains(cl)) {
            return false;
        }
        return this.configListeners.add(cl);
    }

    public boolean unregisterConfigListener(ConfigListener cl) {
        if (cl == null) {
            return false;
        }
        return this.configListeners.remove(cl);
    }

    public synchronized void reinit() {
        this.isReinit = true;
        for (ConfigListener cl : this.configListeners) {
            cl.configStart();
        }
        logCatalogInit.info("\n**************************************\n**************************************\nStarting TDS config catalog reinitialization\n[" + CalendarDate.present() + "]");
        MetadataManager.closeAll();
        this.pathMatcher = new PathMatcher();
        this.idHash = new HashSet();
        DatasetHandler.reinit();
        this.initCatalogs();
        this.isReinit = false;
        logCatalogInit.info("\n**************************************\n**************************************\nDone with TDS config catalog reinitialization\n[" + CalendarDate.present() + "]");
    }

    void initCatalogs() {
        ArrayList<String> catList = new ArrayList<String>();
        catList.add("catalog.xml");
        ThreddsConfig.getCatalogRoots(catList);
        logCatalogInit.info("initCatalogs(): initializing " + catList.size() + " root catalogs.");
        this.initCatalogs(catList);
    }

    public synchronized void initCatalogs(List<String> configCatalogRoots) {
        if (!this.isReinit) {
            for (ConfigListener cl : this.configListeners) {
                cl.configStart();
            }
        }
        this.isReinit = false;
        this.staticCache = ThreddsConfig.getBoolean("Catalog.cache", true);
        startupLog.info("DataRootHandler: staticCache= " + this.staticCache);
        this.staticCatalogNames = new HashSet<String>();
        this.staticCatalogHash = new HashMap();
        for (String path : configCatalogRoots) {
            try {
                path = StringUtils.cleanPath((String)path);
                logCatalogInit.info("\n**************************************\nCatalog init " + path + "\n[" + CalendarDate.present() + "]");
                this.initCatalog(path, true, true);
            }
            catch (Throwable e) {
                logCatalogInit.error("initCatalogs(): Error initializing catalog " + path + "; " + e.getMessage(), e);
            }
        }
        for (ConfigListener cl : this.configListeners) {
            cl.configEnd();
        }
    }

    private void initCatalog(String path, boolean recurse, boolean cache) throws IOException {
        path = StringUtils.cleanPath((String)path);
        File f = this.tdsContext.getConfigFileSource().getFile(path);
        if (f == null) {
            logCatalogInit.error("initCatalog(): Catalog [" + path + "] does not exist in config directory.");
            return;
        }
        if (this.staticCatalogNames.contains(path)) {
            logCatalogInit.warn("initCatalog(): Catalog [" + path + "] already seen, possible loop (skip).");
            return;
        }
        this.staticCatalogNames.add(path);
        InvCatalogFactory factory = this.getCatalogFactory(true);
        InvCatalogImpl cat = this.readCatalog(factory, path, f.getPath());
        if (cat == null) {
            logCatalogInit.warn("initCatalog(): failed to read catalog <" + f.getPath() + ">.");
            return;
        }
        for (ConfigListener cl : this.configListeners) {
            cl.configCatalog((InvCatalog)cat);
        }
        for (DataRootConfig p : cat.getDatasetRoots()) {
            this.addRoot(p, true);
        }
        List<String> disallowedServices = AllowableService.checkCatalogServices((InvCatalog)cat);
        if (!disallowedServices.isEmpty()) {
            logCatalogInit.warn("initCatalog(): declared services: " + disallowedServices.toString() + " in catalog: " + f.getPath() + " are disallowed in threddsConfig file");
        }
        for (InvService s : cat.getServices()) {
            for (InvProperty p : s.getDatasetRoots()) {
                this.addRoot(p.getName(), p.getValue(), true);
            }
        }
        int pos = path.lastIndexOf("/");
        String dirPath = pos > 0 ? path.substring(0, pos + 1) : "";
        boolean needsCache = this.initSpecialDatasets(cat.getDatasets());
        if (this.staticCache || cache || needsCache) {
            cat.setStatic(true);
            this.staticCatalogHash.put(path, cat);
            if (logCatalogInit.isDebugEnabled()) {
                logCatalogInit.debug("  add static catalog to hash=" + path);
            }
        }
        if (recurse) {
            this.initFollowCatrefs(dirPath, cat.getDatasets());
        }
    }

    private InvCatalogFactory getCatalogFactory(boolean validate) {
        InvCatalogFactory factory = InvCatalogFactory.getDefaultFactory((boolean)validate);
        if (!this.dataRootLocationAliasExpanders.isEmpty()) {
            factory.setDataRootLocationAliasExpanders(this.dataRootLocationAliasExpanders);
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InvCatalogImpl readCatalog(InvCatalogFactory factory, String path, String catalogFullPath) {
        URI uri;
        try {
            uri = new URI("file:" + StringUtil2.escape((String)catalogFullPath, (String)"/:-_."));
        }
        catch (URISyntaxException e) {
            logCatalogInit.error("readCatalog(): URISyntaxException=" + e.getMessage());
            return null;
        }
        logCatalogInit.info("readCatalog(): full path=" + catalogFullPath + "; path=" + path);
        InvCatalogImpl cat = null;
        FileInputStream ios = null;
        try {
            ios = new FileInputStream(catalogFullPath);
            cat = factory.readXML((InputStream)ios, uri);
            StringBuilder sbuff = new StringBuilder();
            if (!cat.check(sbuff)) {
                logCatalogInit.error("   invalid catalog -- " + sbuff.toString());
                InvCatalogImpl invCatalogImpl = null;
                return invCatalogImpl;
            }
            logCatalogInit.info("   valid catalog -- " + sbuff.toString());
        }
        catch (Throwable t) {
            String msg = cat == null ? "null catalog" : cat.getLog();
            logCatalogInit.error("  Exception on catalog=" + catalogFullPath + " " + t.getMessage() + "\n log=" + msg, t);
            InvCatalogImpl invCatalogImpl = null;
            return invCatalogImpl;
        }
        finally {
            if (ios != null) {
                try {
                    ios.close();
                }
                catch (IOException e) {
                    logCatalogInit.error("  error closing" + catalogFullPath);
                }
            }
        }
        return cat;
    }

    private boolean initSpecialDatasets(List<InvDataset> dsList) {
        boolean needsCache = false;
        Iterator<InvDataset> iter = dsList.iterator();
        while (iter.hasNext()) {
            InvDatasetImpl invDataset = (InvDatasetImpl)iter.next();
            String id = invDataset.getUniqueID();
            if (id != null) {
                if (this.idHash.contains(id)) {
                    logCatalogInit.warn("Duplicate id on  '" + invDataset.getFullName() + "' id= '" + id + "'");
                } else {
                    this.idHash.add(id);
                }
            }
            for (ConfigListener cl : this.configListeners) {
                cl.configDataset((InvDataset)invDataset);
            }
            if (invDataset instanceof InvDatasetScan) {
                InvDatasetScan ds = (InvDatasetScan)invDataset;
                InvService service = ds.getServiceDefault();
                if (service == null) {
                    logCatalogInit.error("InvDatasetScan " + ds.getFullName() + " has no default Service - skipping");
                    continue;
                }
                if (!this.addRoot(ds)) {
                    iter.remove();
                }
            } else if (invDataset instanceof InvDatasetFmrc) {
                InvDatasetFmrc fmrc = (InvDatasetFmrc)invDataset;
                this.addRoot(fmrc);
                needsCache = true;
            } else if (invDataset instanceof InvDatasetFeatureCollection) {
                InvDatasetFeatureCollection fc = (InvDatasetFeatureCollection)invDataset;
                this.addRoot(fc);
                needsCache = true;
            } else if (invDataset.getNcmlElement() != null) {
                DatasetHandler.putNcmlDataset(invDataset.getUrlPath(), invDataset);
            }
            if (invDataset instanceof InvCatalogRef) continue;
            this.initSpecialDatasets(invDataset.getDatasets());
        }
        return needsCache;
    }

    private void initFollowCatrefs(String dirPath, List<InvDataset> datasets) throws IOException {
        for (InvDataset invDataset : datasets) {
            if (invDataset instanceof InvCatalogRef && !(invDataset instanceof InvDatasetScan) && !(invDataset instanceof InvDatasetFmrc) && !(invDataset instanceof InvDatasetFeatureCollection)) {
                String path;
                String contextPathPlus;
                InvCatalogRef catref = (InvCatalogRef)invDataset;
                String href = catref.getXlinkHref();
                if (logCatalogInit.isDebugEnabled()) {
                    logCatalogInit.debug("  catref.getXlinkHref=" + href);
                }
                if (href.startsWith("http:")) continue;
                if (href.startsWith("./")) {
                    href = href.substring(2);
                }
                if (href.startsWith(contextPathPlus = this.tdsContext.getContextPath() + "/")) {
                    path = href.substring(contextPathPlus.length());
                } else {
                    if (href.startsWith("/")) {
                        logCatalogInit.warn("**Warning: Skipping catalogRef <xlink:href=" + href + ">. Reference is relative to the server outside the context path [" + contextPathPlus + "]. " + "Parent catalog info: Name=\"" + catref.getParentCatalog().getName() + "\"; Base URI=\"" + catref.getParentCatalog().getUriString() + "\"; dirPath=\"" + dirPath + "\".");
                        continue;
                    }
                    path = dirPath + href;
                }
                this.initCatalog(path, true, false);
                continue;
            }
            if (invDataset instanceof InvDatasetScan || invDataset instanceof InvDatasetFmrc || invDataset instanceof InvDatasetFeatureCollection) continue;
            this.initFollowCatrefs(dirPath, invDataset.getDatasets());
        }
    }

    private boolean addRoot(InvDatasetScan dscan) {
        String path = dscan.getPath();
        if (path == null) {
            logCatalogInit.error("**Error: " + dscan.getFullName() + " missing a path attribute.");
            return false;
        }
        DataRoot droot = (DataRoot)this.pathMatcher.get(path);
        if (droot != null) {
            if (!droot.dirLocation.equals(dscan.getScanLocation())) {
                logCatalogInit.error("**Error: already have dataRoot =<" + path + ">  mapped to directory= <" + droot.dirLocation + ">" + " wanted to map to fmrc=<" + dscan.getScanLocation() + "> in catalog " + dscan.getParentCatalog().getUriString());
            }
            return false;
        }
        if (!dscan.isValid()) {
            logCatalogInit.error(dscan.getInvalidMessage() + "\n... Dropping this datasetScan [" + path + "].");
            return false;
        }
        droot = new DataRoot(dscan);
        this.pathMatcher.put(path, droot);
        logCatalogInit.debug(" added rootPath=<" + path + ">  for directory= <" + dscan.getScanLocation() + ">");
        return true;
    }

    private boolean addRoot(InvDatasetFmrc fmrc) {
        File file;
        String path = fmrc.getPath();
        if (path == null) {
            logCatalogInit.error(fmrc.getFullName() + " missing a path attribute.");
            return false;
        }
        DataRoot droot = (DataRoot)this.pathMatcher.get(path);
        if (droot != null) {
            logCatalogInit.error("**Error: already have dataRoot =<" + path + ">  mapped to directory= <" + droot.dirLocation + ">" + " wanted to use by FMRC Dataset =<" + fmrc.getFullName() + ">");
            return false;
        }
        droot = new DataRoot(fmrc);
        if (droot.dirLocation != null && !(file = new File(droot.dirLocation)).exists()) {
            logCatalogInit.error("**Error: DatasetFmrc =" + droot.path + " directory= <" + droot.dirLocation + "> does not exist");
            return false;
        }
        this.pathMatcher.put(path, droot);
        logCatalogInit.debug(" added rootPath=<" + path + ">  for fmrc= <" + fmrc.getFullName() + ">");
        return true;
    }

    public List<InvDatasetFeatureCollection> getFeatureCollections() {
        ArrayList<InvDatasetFeatureCollection> result = new ArrayList<InvDatasetFeatureCollection>();
        Iterator iter = this.pathMatcher.iterator();
        while (iter.hasNext()) {
            DataRoot droot = (DataRoot)iter.next();
            if (droot.featCollection == null) continue;
            result.add(droot.featCollection);
        }
        return result;
    }

    public InvDatasetFeatureCollection getFeatureCollection(String want) {
        Iterator iter = this.pathMatcher.iterator();
        while (iter.hasNext()) {
            DataRoot droot = (DataRoot)iter.next();
            if (droot.featCollection == null || !droot.featCollection.getName().equals(want)) continue;
            return droot.featCollection;
        }
        return null;
    }

    private boolean addRoot(InvDatasetFeatureCollection fc) {
        File file;
        String path = fc.getPath();
        if (path == null) {
            logCatalogInit.error(fc.getFullName() + " missing a path attribute.");
            return false;
        }
        DataRoot droot = (DataRoot)this.pathMatcher.get(path);
        if (droot != null) {
            logCatalogInit.error("**Error: already have dataRoot =<" + path + ">  mapped to directory= <" + droot.dirLocation + ">" + " wanted to use by FeatureCollection Dataset =<" + fc.getFullName() + ">");
            return false;
        }
        droot = new DataRoot(fc);
        if (droot.dirLocation != null && !(file = new File(droot.dirLocation)).exists()) {
            logCatalogInit.error("**Error: DatasetFmrc =" + droot.path + " directory= <" + droot.dirLocation + "> does not exist");
            return false;
        }
        this.pathMatcher.put(path, droot);
        logCatalogInit.debug(" added rootPath=<" + path + ">  for feature collection= <" + fc.getFullName() + ">");
        return true;
    }

    private boolean addRoot(String path, String dirLocation, boolean wantErr) {
        DataRoot droot = (DataRoot)this.pathMatcher.get(path);
        if (droot != null) {
            if (wantErr) {
                logCatalogInit.error("**Error: already have dataRoot =<" + path + ">  mapped to directory= <" + droot.dirLocation + ">" + " wanted to map to <" + dirLocation + ">");
            }
            return false;
        }
        File file = new File(dirLocation);
        if (!file.exists()) {
            logCatalogInit.error("**Error: Data Root =" + path + " directory= <" + dirLocation + "> does not exist");
            return false;
        }
        droot = new DataRoot(path, dirLocation, true);
        this.pathMatcher.put(path, droot);
        logCatalogInit.debug(" added rootPath=<" + path + ">  for directory= <" + dirLocation + ">");
        return true;
    }

    private boolean addRoot(DataRootConfig config, boolean wantErr) {
        String path = config.getName();
        String location = config.getValue();
        DataRoot droot = (DataRoot)this.pathMatcher.get(path);
        if (droot != null) {
            if (wantErr) {
                logCatalogInit.error("**Error: already have dataRoot =<" + path + ">  mapped to directory= <" + droot.dirLocation + ">" + " wanted to map to <" + location + ">");
            }
            return false;
        }
        File file = new File(location);
        if (!file.exists()) {
            logCatalogInit.error("**Error: Data Root =" + path + " directory= <" + location + "> does not exist");
            return false;
        }
        droot = new DataRoot(path, location, config.isCache());
        this.pathMatcher.put(path, droot);
        logCatalogInit.debug(" added rootPath=<" + path + ">  for directory= <" + location + ">");
        return true;
    }

    private DataRoot findDataRoot(String fullpath) {
        if (fullpath.length() > 0 && fullpath.charAt(0) == '/') {
            fullpath = fullpath.substring(1);
        }
        return (DataRoot)this.pathMatcher.match(fullpath);
    }

    public DataRootMatch findDataRootMatch(HttpServletRequest req) {
        String spath = req.getPathInfo();
        if (spath.length() > 0 && spath.startsWith("/")) {
            spath = spath.substring(1);
        }
        return this.findDataRootMatch(spath);
    }

    public DataRootMatch findDataRootMatch(String spath) {
        DataRoot dataRoot;
        if (spath.startsWith("/")) {
            spath = spath.substring(1);
        }
        if ((dataRoot = this.findDataRoot(spath)) == null) {
            return null;
        }
        DataRootMatch match = new DataRootMatch();
        match.rootPath = dataRoot.path;
        match.remaining = spath.substring(match.rootPath.length());
        if (match.remaining.startsWith("/")) {
            match.remaining = match.remaining.substring(1);
        }
        match.dirLocation = dataRoot.dirLocation;
        match.dataRoot = dataRoot;
        return match;
    }

    public boolean hasDataRootMatch(String path) {
        DataRoot dataRoot;
        if (path.length() > 0 && path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((dataRoot = this.findDataRoot(path)) == null) {
            if (log.isDebugEnabled()) {
                log.debug("hasDataRootMatch(): no InvDatasetScan for " + path);
            }
            return false;
        }
        return true;
    }

    public CrawlableDataset getCrawlableDataset(String path) throws IOException {
        DataRoot reqDataRoot;
        if (path.length() > 0 && path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((reqDataRoot = this.findDataRoot(path)) == null) {
            return null;
        }
        if (reqDataRoot.scan != null) {
            return reqDataRoot.scan.requestCrawlableDataset(path);
        }
        if (reqDataRoot.fmrc != null) {
            return null;
        }
        if (reqDataRoot.featCollection != null) {
            return null;
        }
        if (reqDataRoot.dirLocation != null) {
            if (reqDataRoot.datasetRootProxy == null) {
                reqDataRoot.makeProxy();
            }
            return reqDataRoot.datasetRootProxy.requestCrawlableDataset(path);
        }
        return null;
    }

    public File getCrawlableDatasetAsFile(String path) {
        CrawlableDataset crDs;
        DataRootMatch match;
        if (path.length() > 0 && path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((match = this.findDataRootMatch(path)) == null) {
            return null;
        }
        if (match.dataRoot.fmrc != null) {
            return match.dataRoot.fmrc.getFile(match.remaining);
        }
        if (match.dataRoot.featCollection != null) {
            return match.dataRoot.featCollection.getFile(match.remaining);
        }
        try {
            crDs = this.getCrawlableDataset(path);
        }
        catch (IOException e) {
            return null;
        }
        if (crDs == null) {
            return null;
        }
        File retFile = null;
        if (crDs instanceof CrawlableDatasetFile) {
            retFile = ((CrawlableDatasetFile)crDs).getFile();
        }
        return retFile;
    }

    public URI getCrawlableDatasetAsOpendapUri(String path) {
        CrawlableDataset crDs;
        if (path.length() > 0 && path.startsWith("/")) {
            path = path.substring(1);
        }
        try {
            crDs = this.getCrawlableDataset(path);
        }
        catch (IOException e) {
            return null;
        }
        if (crDs == null) {
            return null;
        }
        URI retUri = null;
        if (crDs instanceof CrawlableDatasetDods) {
            retUri = ((CrawlableDatasetDods)crDs).getUri();
        }
        return retUri;
    }

    public boolean isProxyDataset(String path) {
        ProxyDatasetHandler pdh = this.getMatchingProxyDataset(path);
        return pdh != null;
    }

    public boolean isProxyDatasetResolver(String path) {
        ProxyDatasetHandler pdh = this.getMatchingProxyDataset(path);
        if (pdh == null) {
            return false;
        }
        return pdh.isProxyDatasetResolver();
    }

    private ProxyDatasetHandler getMatchingProxyDataset(String path) {
        InvDatasetScan scan = this.getMatchingScan(path);
        if (null == scan) {
            return null;
        }
        int index = path.lastIndexOf("/");
        String proxyName = path.substring(index + 1);
        Map pdhMap = scan.getProxyDatasetHandlers();
        if (pdhMap == null) {
            return null;
        }
        return (ProxyDatasetHandler)pdhMap.get(proxyName);
    }

    private InvDatasetScan getMatchingScan(String path) {
        DataRoot reqDataRoot = this.findDataRoot(path);
        if (reqDataRoot == null) {
            return null;
        }
        InvDatasetScan scan = null;
        if (reqDataRoot.scan != null) {
            scan = reqDataRoot.scan;
        } else if (reqDataRoot.fmrc != null) {
            scan = reqDataRoot.fmrc.getRawFileScan();
        }
        return scan;
    }

    public InvCatalog getProxyDatasetResolverCatalog(String path, URI baseURI) {
        if (!this.isProxyDatasetResolver(path)) {
            throw new IllegalArgumentException("Not a proxy dataset resolver path <" + path + ">.");
        }
        InvDatasetScan scan = this.getMatchingScan(path);
        InvCatalogImpl cat = scan.makeProxyDsResolverCatalog(path, baseURI);
        return cat;
    }

    public void handleRequestForProxyDatasetResolverCatalog(HttpServletRequest req, HttpServletResponse res) throws IOException {
        URI baseURI;
        String path = req.getPathInfo();
        if (!this.isProxyDatasetResolver(path)) {
            String resMsg = "Request <" + path + "> not for proxy dataset resolver.";
            log.error("handleRequestForProxyDatasetResolverCatalog(): " + resMsg);
            res.sendError(500, resMsg);
            return;
        }
        String baseUriString = req.getRequestURL().toString();
        try {
            baseURI = new URI(baseUriString);
        }
        catch (URISyntaxException e) {
            String resMsg = "Request URL <" + baseUriString + "> not a valid URI: " + e.getMessage();
            log.error("handleRequestForProxyDatasetResolverCatalog(): " + resMsg);
            res.sendError(500, resMsg);
            return;
        }
        InvCatalogImpl cat = (InvCatalogImpl)this.getProxyDatasetResolverCatalog(path, baseURI);
        if (cat == null) {
            String resMsg = "Could not generate proxy dataset resolver catalog <" + path + ">.";
            log.error("handleRequestForProxyDatasetResolverCatalog(): " + resMsg);
            res.sendError(500, resMsg);
            return;
        }
        InvCatalogFactory catFactory = this.getCatalogFactory(false);
        String result = catFactory.writeXML(cat);
        res.setContentLength(result.length());
        res.setContentType("text/xml");
        res.getOutputStream().write(result.getBytes(CDM.utf8Charset));
    }

    public void handleRequestForDataset(String path, DataServiceProvider dsp, HttpServletRequest req, HttpServletResponse res) throws IOException {
        String crDsPath;
        DataServiceProvider.DatasetRequest dsReq = dsp.getRecognizedDatasetRequest(path, req);
        boolean dspCanHandle = false;
        if (dsReq != null) {
            String dsPath = dsReq.getDatasetPath();
            if (dsPath != null) {
                crDsPath = dsPath;
                dspCanHandle = true;
            } else {
                log.warn("handleRequestForDataset(): DataServiceProvider recognized request path <" + path + "> but returned a null dataset path, using request path.");
                crDsPath = path;
            }
        } else {
            crDsPath = path;
        }
        CrawlableDataset crDs = this.getCrawlableDataset(crDsPath);
        if (crDs == null) {
            res.sendError(404);
            return;
        }
        if (dspCanHandle) {
            dsp.handleRequestForDataset(dsReq, crDs, req, res);
            return;
        }
        if (crDs.isCollection()) {
            dsp.handleUnrecognizedRequestForCollection(crDs, req, res);
            return;
        }
        dsp.handleUnrecognizedRequest(crDs, req, res);
    }

    public boolean processReqForCatalog(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String catPath = TdsPathUtils.extractPath(req);
        if (catPath == null) {
            return false;
        }
        if (catPath.equals("")) {
            catPath = "catalog.html";
        }
        if (catPath.endsWith("/")) {
            catPath = catPath + "catalog.html";
        }
        if (!catPath.endsWith(".xml") && !catPath.endsWith(".html")) {
            return false;
        }
        String path = "/catalog/" + catPath;
        if (catPath.equals("catalog.html") || catPath.equals("catalog.xml")) {
            path = "/" + catPath;
        }
        RequestForwardUtils.forwardRequestRelativeToCurrentContext(path, req, res);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvCatalog getCatalog(String path, URI baseURI) {
        if (path == null) {
            return null;
        }
        String workPath = path;
        if (workPath.startsWith("/")) {
            workPath = workPath.substring(1);
        }
        boolean reread = false;
        InvCatalogImpl catalog = this.staticCatalogHash.get(workPath);
        if (catalog != null) {
            DateType expiresDateType = catalog.getExpires();
            if (expiresDateType != null && expiresDateType.getDate().getTime() < System.currentTimeMillis()) {
                reread = true;
            }
        } else if (!this.staticCache) {
            reread = this.staticCatalogNames.contains(workPath);
        }
        if (reread) {
            File catFile = this.tdsContext.getConfigFileSource().getFile(workPath);
            if (catFile != null) {
                String catalogFullPath = catFile.getPath();
                logCatalogInit.info("**********\nReading catalog {} at {}\n", (Object)catalogFullPath, (Object)CalendarDate.present());
                InvCatalogFactory factory = this.getCatalogFactory(true);
                InvCatalogImpl reReadCat = this.readCatalog(factory, workPath, catalogFullPath);
                if (reReadCat != null) {
                    catalog = reReadCat;
                    if (this.staticCache) {
                        DataRootHandler dataRootHandler = this;
                        synchronized (dataRootHandler) {
                            reReadCat.setStatic(true);
                            this.staticCatalogHash.put(workPath, reReadCat);
                        }
                    }
                }
            } else {
                logCatalogInit.error("Static catalog does not exist that we expected = " + workPath);
            }
        }
        if (catalog != null) {
            catalog.setBaseURI(baseURI);
        }
        if (catalog == null) {
            catalog = this.makeDynamicCatalog(workPath, baseURI);
        }
        if (catalog == null && this.isProxyDatasetResolver(workPath)) {
            catalog = (InvCatalogImpl)this.getProxyDatasetResolverCatalog(workPath, baseURI);
        }
        return catalog;
    }

    private InvCatalogImpl makeDynamicCatalog(String path, URI baseURI) {
        InvCatalogImpl cat;
        DataRootMatch match;
        String workPath = path;
        if (!path.endsWith("/catalog.xml") && !path.endsWith("/latest.xml")) {
            return null;
        }
        int pos = workPath.lastIndexOf("/");
        if (pos >= 0) {
            workPath = workPath.substring(0, pos);
        }
        if ((match = this.findDataRootMatch(workPath)) == null) {
            return null;
        }
        if (match.dataRoot.fmrc != null) {
            return match.dataRoot.fmrc.makeCatalog(match.remaining, path, baseURI);
        }
        if (match.dataRoot.featCollection != null) {
            boolean isLatest = path.endsWith("/latest.xml");
            if (isLatest) {
                return match.dataRoot.featCollection.makeLatest(match.remaining, path, baseURI);
            }
            return match.dataRoot.featCollection.makeCatalog(match.remaining, path, baseURI);
        }
        try {
            if (this.getCrawlableDataset(workPath) == null) {
                return null;
            }
        }
        catch (IOException e) {
            log.error("makeDynamicCatalog(): I/O error on request <" + path + ">: " + e.getMessage(), (Throwable)e);
            return null;
        }
        if (match.dataRoot.scan == null) {
            log.warn("makeDynamicCatalog(): No InvDatasetScan for =" + workPath + " request path= " + path);
            return null;
        }
        if (path.endsWith("/latest.xml")) {
            return null;
        }
        InvDatasetScan dscan = match.dataRoot.scan;
        if (log.isDebugEnabled()) {
            log.debug("makeDynamicCatalog(): Calling makeCatalogForDirectory( " + baseURI + ", " + path + ").");
        }
        if (null == (cat = dscan.makeCatalogForDirectory(path, baseURI))) {
            log.error("makeDynamicCatalog(): makeCatalogForDirectory failed = " + workPath);
        }
        return cat;
    }

    private InvCatalogImpl makeTDRDynamicCatalog(String path, URI baseURI) {
        if (!path.startsWith("tdr")) {
            return null;
        }
        File catFile = this.tdsContext.getConfigFileSource().getFile(path);
        if (catFile == null) {
            return null;
        }
        String catalogFullPath = catFile.getPath();
        InvCatalogFactory factory = this.getCatalogFactory(false);
        InvCatalogImpl cat = this.readCatalog(factory, path, catalogFullPath);
        if (cat == null) {
            log.warn("makeTDRDynamicCatalog(): failed to read tdr catalog <" + catalogFullPath + ">.");
            return null;
        }
        cat.setBaseURI(baseURI);
        return cat;
    }

    public boolean processReqForLatestDataset(HttpServlet servlet, HttpServletRequest req, HttpServletResponse res) throws IOException {
        URI reqBaseURI;
        String path;
        int pos;
        String orgPath = req.getPathInfo();
        if (orgPath.startsWith("/")) {
            orgPath = orgPath.substring(1);
        }
        if ((pos = (path = orgPath).lastIndexOf("/")) >= 0) {
            path = path.substring(0, pos);
        }
        if (path.equals("/") || path.equals("")) {
            String resMsg = "No data at root level, \"/latest.xml\" request not available.";
            if (log.isDebugEnabled()) {
                log.debug("processReqForLatestDataset(): " + resMsg);
            }
            res.sendError(404, resMsg);
            return false;
        }
        DataRoot dataRoot = this.findDataRoot(path);
        if (dataRoot == null) {
            String resMsg = "No scan root matches requested path <" + path + ">.";
            log.warn("processReqForLatestDataset(): " + resMsg);
            res.sendError(404, resMsg);
            return false;
        }
        InvDatasetScan dscan = dataRoot.scan;
        if (dscan == null) {
            String resMsg = "Probable conflict between datasetScan and datasetRoot for path <" + path + ">.";
            log.warn("processReqForLatestDataset(): " + resMsg);
            res.sendError(404, resMsg);
            return false;
        }
        if (dscan.getProxyDatasetHandlers() == null) {
            String resMsg = "No \"addProxies\" or \"addLatest\" on matching scan root <" + path + ">.";
            log.warn("processReqForLatestDataset(): " + resMsg);
            res.sendError(404, resMsg);
            return false;
        }
        String reqBase = ServletUtil.getRequestBase(req);
        try {
            reqBaseURI = new URI(reqBase);
        }
        catch (URISyntaxException e) {
            String resMsg = "Request base URL <" + reqBase + "> not valid URI (???): " + e.getMessage();
            log.error("processReqForLatestDataset(): " + resMsg);
            res.sendError(500, resMsg);
            return false;
        }
        InvCatalog cat = dscan.makeLatestCatalogForDirectory(orgPath, reqBaseURI);
        if (null == cat) {
            String resMsg = "Failed to build response catalog <" + path + ">.";
            log.error("processReqForLatestDataset(): " + resMsg);
            res.sendError(404, resMsg);
            return false;
        }
        InvCatalogFactory catFactory = this.getCatalogFactory(false);
        String catAsString = catFactory.writeXML((InvCatalogImpl)cat);
        PrintWriter out = res.getWriter();
        res.setContentType("text/xml");
        res.setStatus(200);
        out.print(catAsString);
        if (log.isDebugEnabled()) {
            log.debug("processReqForLatestDataset(): Finished \"" + orgPath + "\".");
        }
        return true;
    }

    public Element getNcML(String path) {
        DataRoot dataRoot;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((dataRoot = this.findDataRoot(path)) == null) {
            if (log.isDebugEnabled()) {
                log.debug("_getNcML no InvDatasetScan for =" + path);
            }
            return null;
        }
        InvDatasetScan dscan = dataRoot.scan;
        if (dscan == null) {
            dscan = dataRoot.datasetRootProxy;
        }
        if (dscan == null) {
            return null;
        }
        return dscan.getNcmlElement();
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public void makeDebugActions() {
        DebugHandler debugHandler = DebugHandler.get("catalogs");
        DebugHandler.Action act = new DebugHandler.Action("showStatic", "Show static catalogs"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doAction(DebugHandler.Event e) {
                StringBuilder sbuff = new StringBuilder();
                DataRootHandler dataRootHandler = DataRootHandler.this;
                synchronized (dataRootHandler) {
                    ArrayList list = new ArrayList(DataRootHandler.this.staticCatalogHash.keySet());
                    Collections.sort(list);
                    for (String catPath : list) {
                        InvCatalogImpl cat = (InvCatalogImpl)DataRootHandler.this.staticCatalogHash.get(catPath);
                        sbuff.append(" catalog= ").append(catPath).append("; ");
                        String filename = StringUtil2.unescape((String)cat.getCreateFrom());
                        sbuff.append(" from= ").append(filename).append("\n");
                    }
                }
                e.pw.println(StringUtil2.quoteHtmlContent((String)("\n" + sbuff.toString())));
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("showRoots", "Show data roots"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doAction(DebugHandler.Event e) {
                DataRootHandler dataRootHandler = DataRootHandler.this;
                synchronized (dataRootHandler) {
                    Iterator iter = DataRootHandler.this.pathMatcher.iterator();
                    while (iter.hasNext()) {
                        DataRoot ds = (DataRoot)iter.next();
                        e.pw.print(" <b>" + ds.path + "</b>");
                        String url = DataRootHandler.this.tdsContext.getContextPath() + "/admin/dataDir/" + ds.path + "/";
                        if (ds.fmrc == null) {
                            String type = ds.scan == null ? "root" : "scan";
                            e.pw.println(" for " + type + " directory= <a href='" + url + "'>" + ds.dirLocation + "</a> ");
                            continue;
                        }
                        if (ds.dirLocation == null) {
                            e.pw.println("  for fmrc= <a href='" + ds.fmrc.getXlinkHref() + "'>" + ds.fmrc.getXlinkHref() + "</a>");
                            continue;
                        }
                        e.pw.println("  for fmrc= <a href='" + url + "'>" + ds.dirLocation + "</a>");
                    }
                }
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("getRoots", "Check data roots"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doAction(DebugHandler.Event e) {
                DataRootHandler dataRootHandler = DataRootHandler.this;
                synchronized (dataRootHandler) {
                    e.pw.print("<pre>\n");
                    Iterator iter = DataRootHandler.this.pathMatcher.iterator();
                    boolean ok = true;
                    while (iter.hasNext()) {
                        DataRoot ds = (DataRoot)iter.next();
                        if (ds.dirLocation == null && ds.fmrc != null) continue;
                        try {
                            File f = new File(ds.dirLocation);
                            if (f.exists()) continue;
                            e.pw.print("MISSING on dir = " + ds.dirLocation + " for path = " + ds.path + "\n");
                            ok = false;
                        }
                        catch (Throwable t) {
                            e.pw.print("ERROR on dir = " + ds.dirLocation + " for path = " + ds.path + "\n");
                            e.pw.print(t.getMessage() + "\n");
                            ok = false;
                        }
                    }
                    if (ok) {
                        e.pw.print("ALL OK\n");
                    }
                    e.pw.print("</pre>\n");
                }
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("reinit", "Reinitialize"){

            @Override
            public void doAction(DebugHandler.Event e) {
                try {
                    singleton.reinit();
                    e.pw.println("reinit ok");
                }
                catch (Exception e1) {
                    e.pw.println("Error on reinit " + e1.getMessage());
                    log.error("Error on reinit " + e1.getMessage());
                }
            }
        };
        debugHandler.addAction(act);
    }

    public static interface ConfigListener {
        public void configStart();

        public void configEnd();

        public void configCatalog(InvCatalog var1);

        public void configDataset(InvDataset var1);
    }

    public class DataRoot {
        String path;
        String dirLocation;
        InvDatasetScan scan;
        InvDatasetFmrc fmrc;
        InvDatasetFeatureCollection featCollection;
        boolean cache = true;
        InvDatasetScan datasetRootProxy;

        DataRoot(InvDatasetFeatureCollection featCollection) {
            this.path = featCollection.getPath();
            this.featCollection = featCollection;
            this.dirLocation = featCollection.getTopDirectoryLocation();
            logCatalogInit.info(" DataRoot adding featureCollection {}\n", (Object)featCollection.getConfig());
        }

        DataRoot(InvDatasetFmrc fmrc) {
            this.path = fmrc.getPath();
            this.fmrc = fmrc;
            InvDatasetFmrc.InventoryParams params = fmrc.getFmrcInventoryParams();
            if (null != params) {
                this.dirLocation = params.location;
            }
        }

        DataRoot(InvDatasetScan scan) {
            this.path = scan.getPath();
            this.scan = scan;
            this.dirLocation = scan.getScanLocation();
            this.datasetRootProxy = null;
        }

        DataRoot(String path, String dirLocation, boolean cache) {
            this.path = path;
            this.dirLocation = dirLocation;
            this.cache = cache;
            this.scan = null;
            this.makeProxy();
        }

        void makeProxy() {
            this.datasetRootProxy = new InvDatasetScan(null, "", this.path, this.dirLocation, null, null, null, null, null, false, null, null, null, null);
        }

        public String toString() {
            return this.path;
        }

        public String toString2() {
            return this.path + "," + this.dirLocation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataRoot root = (DataRoot)o;
            return this.path.equals(root.path);
        }

        public int hashCode() {
            return this.path.hashCode();
        }
    }

    public class DataRootMatch {
        String rootPath;
        String remaining;
        String dirLocation;
        DataRoot dataRoot;
    }
}

