/*
 * Decompiled with CFR 0.152.
 */
package thredds.dqc.server.jplQuikSCAT;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.Index;
import ucar.ma2.StructureData;

public class JplQuikScatEntry {
    private static Logger log = LoggerFactory.getLogger(JplQuikScatEntry.class);
    private Calendar calendar = null;
    private String dodsUrlVarName = "QuikSCAT_L2B.DODS_URL";
    private String yearVarName = "QuikSCAT_L2B.year";
    private String dayOfYearVarName = "QuikSCAT_L2B.day";
    private String hourVarName = "QuikSCAT_L2B.hours";
    private String minuteVarName = "QuikSCAT_L2B.minutes";
    private String secondVarName = "QuikSCAT_L2B.seconds";
    private String millisecondVarName = "QuikSCAT_L2B.m_seconds";
    private String longitudeVarName = "QuikSCAT_L2B.longitude";
    private String revNumVarName = "QuikSCAT_L2B.rev_num";
    private String wvcRowsVarName = "QuikSCAT_L2B.wvc_rows";
    private String dodsUrl = null;
    private Date date = null;
    private float longitude = 0.0f;
    private int revNum = -999;
    private int wvcRows = -999;
    private StructureData entry = null;

    public JplQuikScatEntry(StructureData entry) {
        if (entry == null) {
            String tmpMsg = "JPlQuikScatEntry(): given DODSStructure backing store is null.";
            throw new IllegalArgumentException(tmpMsg);
        }
        this.entry = entry;
        this.calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.US);
        try {
            this.dodsUrl = this.getCatalogEntryDodsUrl();
            this.date = this.getCatalogEntryDate();
            this.longitude = this.getCatalogEntryLongitude();
            this.revNum = this.getCatalogEntryRevNum();
            this.wvcRows = this.getCatalogEntryWvcRows();
        }
        catch (IOException e) {
            String tmpMsg = "JPlQuikScatEntry(): given DODSStructure did not contain necessary variables.";
            log.debug(tmpMsg);
            throw new IllegalArgumentException(tmpMsg);
        }
    }

    public String getDodsUrl() {
        return this.dodsUrl;
    }

    public Date getDate() {
        return this.date;
    }

    public float getLongitude() {
        return this.longitude;
    }

    public int getRevNum() {
        return this.revNum;
    }

    public int getWvcRows() {
        return this.wvcRows;
    }

    public float setLongitudeMinusModulo() {
        this.longitude = (float)((double)this.longitude - 360.0);
        return this.longitude;
    }

    private String getCatalogEntryDodsUrl() throws IOException {
        ArrayChar a = (ArrayChar)this.getCatalogEntryVariableArray(this.dodsUrlVarName);
        return a.getString();
    }

    private Date getCatalogEntryDate() throws IOException {
        Date retDate = null;
        Array a = null;
        Index index = null;
        a = this.getCatalogEntryVariableArray(this.yearVarName);
        index = a.getIndex().set(0);
        int year = a.getInt(index);
        a = this.getCatalogEntryVariableArray(this.dayOfYearVarName);
        index = a.getIndex().set(0);
        int dayOfYear = a.getInt(index);
        a = this.getCatalogEntryVariableArray(this.hourVarName);
        index = a.getIndex().set(0);
        int hour = a.getInt(index);
        a = this.getCatalogEntryVariableArray(this.minuteVarName);
        index = a.getIndex().set(0);
        int minute = a.getInt(index);
        a = this.getCatalogEntryVariableArray(this.secondVarName);
        index = a.getIndex().set(0);
        int second = a.getInt(index);
        a = this.getCatalogEntryVariableArray(this.millisecondVarName);
        index = a.getIndex().set(0);
        int millisecond = a.getInt(index);
        retDate = this.getDateFromYearDayHourMinSecMillisecValues(year, dayOfYear, hour, minute, second, millisecond);
        return retDate;
    }

    private float getCatalogEntryLongitude() throws IOException {
        Array a = null;
        Index index = null;
        a = this.getCatalogEntryVariableArray(this.longitudeVarName);
        index = a.getIndex().set(0);
        float longitude = a.getFloat(index);
        return longitude;
    }

    private int getCatalogEntryRevNum() throws IOException {
        Array a = null;
        Index index = null;
        a = this.getCatalogEntryVariableArray(this.revNumVarName);
        index = a.getIndex().set(0);
        int revNum = a.getInt(index);
        return revNum;
    }

    private int getCatalogEntryWvcRows() throws IOException {
        Array a = null;
        Index index = null;
        a = this.getCatalogEntryVariableArray(this.wvcRowsVarName);
        index = a.getIndex().set(0);
        int wvcRows = a.getInt(index);
        return wvcRows;
    }

    private Array getCatalogEntryVariableArray(String varName) throws IOException {
        Array a = this.entry.getArray(varName);
        if (a == null) {
            String tmpMsg = "getCatalogEntryVariableArray(): backing store does not contain \"" + varName + "\" variable (entry is probably not a JPL QuikSCAT DFS entry).";
            log.debug(tmpMsg);
            throw new IOException(tmpMsg);
        }
        return a;
    }

    private Date getDateFromYearDayHourMinSecMillisecValues(int year, int dayOfYear, int hour, int minute, int second, int millisecond) {
        Date theDate = null;
        this.calendar.clear();
        this.calendar.set(1, year);
        this.calendar.set(6, dayOfYear);
        this.calendar.set(11, hour);
        this.calendar.set(12, minute);
        this.calendar.set(13, second);
        this.calendar.set(14, millisecond);
        theDate = this.calendar.getTime();
        return theDate;
    }
}

