/*
 * Decompiled with CFR 0.152.
 */
package thredds.dqc.server.latest;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.dqc.server.latest.LatestConfig;

public class LatestConfigFactory {
    private static Logger log = LoggerFactory.getLogger(LatestConfigFactory.class);
    private static String rootElemName = "latestConfig";
    private static String itemElemName = "latestItem";
    private static String itemIdAttName = "id";
    private static String itemRefIdAttName = "refid";
    private static String itemNameAttName = "name";
    private static String itemDirLocationAttName = "dirLocation";
    private static String itemDatasetNameMatchPatternAttName = "datasetNameMatchPattern";
    private static String itemDatasetTimeSubstitutionPatternAttName = "datasetTimeSubstitutionPattern";
    private static String itemServiceBaseURLAttName = "serviceBaseURL";
    private static String itemInvCatSpecVersionAttName = "invCatSpecVersion";
    private static String itemDqcSpecVersionAttName = "dqcSpecVersion";

    public static LatestConfig parseXML(File inFile) throws IOException {
        FileInputStream inStream = new FileInputStream(inFile);
        LatestConfig config = LatestConfigFactory.parseXML(inStream, inFile.getPath());
        inStream.close();
        return config;
    }

    public static LatestConfig parseXML(InputStream inStream, String docId) throws IOException {
        Document doc;
        SAXBuilder builder = new SAXBuilder();
        log.debug("parseXML(): Parsing latest config doc \"" + docId + "\".");
        try {
            doc = builder.build(inStream);
        }
        catch (JDOMException e) {
            log.error("parseXML(): Bad config doc <" + docId + ">: " + e.getMessage());
            return null;
        }
        LatestConfig config = LatestConfigFactory.readConfig(doc.getRootElement());
        if (config == null) {
            log.warn("parseXML(): Config doc <" + docId + "> not in new format; trying old format.");
            config = LatestConfigFactory.readOldConfig(doc.getRootElement());
            if (config == null) {
                log.error("parseXML(): Config doc <" + docId + "> not in new or old format.");
                return null;
            }
        }
        LatestConfigFactory.checkConfigRefConsitency(config);
        if (config.isEmpty()) {
            log.warn("parseXML(): Empty config file <" + docId + ">.");
        }
        return config;
    }

    public static void writeXML(File outFile, LatestConfig config) throws IOException {
        Element rootElem = new Element(rootElemName);
        LatestConfigFactory.addConfigItemElements(rootElem, config);
        Document doc = new Document();
        doc.setRootElement(rootElem);
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        FileOutputStream outStream = new FileOutputStream(outFile);
        outputter.output(doc, (OutputStream)outStream);
        outStream.close();
    }

    private static LatestConfig readConfig(Element rootElem) {
        if (!rootElem.getName().equals(rootElemName)) {
            log.error("readConfig(): Root element <" + rootElem.getName() + "> not as expected <" + rootElemName + ">.");
            return null;
        }
        LatestConfig config = new LatestConfig();
        List list = rootElem.getChildren(itemElemName);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            LatestConfigFactory.readConfigItem((Element)it.next(), config);
        }
        return config;
    }

    private static void readConfigItem(Element curElem, LatestConfig config) {
        int numAtts = curElem.getAttributes().size();
        String id = curElem.getAttributeValue("id");
        if (numAtts == 2) {
            String refId = curElem.getAttributeValue("refid");
            if (id == null || refId == null) {
                log.warn("readConfigItem(): Null value for latestItem@id or latestItem@refid - continue with next latestItem.");
                return;
            }
            if (!config.addItem(id, new LatestConfig.Item(id, refId))) {
                log.warn("readConfigItem(): Config already contains item for this id <" + id + ">.");
                return;
            }
        } else if (numAtts == 8) {
            String name = curElem.getAttributeValue(itemNameAttName);
            String dirLocation = curElem.getAttributeValue(itemDirLocationAttName);
            String datasetNameMatchPattern = curElem.getAttributeValue(itemDatasetNameMatchPatternAttName);
            String datasetTimeSubstitutionPattern = curElem.getAttributeValue(itemDatasetTimeSubstitutionPatternAttName);
            String serviceBaseURL = curElem.getAttributeValue(itemServiceBaseURLAttName);
            if (serviceBaseURL.endsWith("/")) {
                serviceBaseURL = serviceBaseURL.substring(0, serviceBaseURL.length());
            }
            String invCatSpecVersion = curElem.getAttributeValue(itemInvCatSpecVersionAttName);
            String dqcSpecVersion = curElem.getAttributeValue(itemDqcSpecVersionAttName);
            if (id == null || name == null || dirLocation == null || datasetNameMatchPattern == null || datasetTimeSubstitutionPattern == null || serviceBaseURL == null || invCatSpecVersion == null || dqcSpecVersion == null) {
                log.warn("readConfigItem(): Null value for at least one attribute of latestItem - continue with next latestItem.");
                return;
            }
            if (!config.addItem(id, new LatestConfig.Item(id, name, dirLocation, datasetNameMatchPattern, datasetTimeSubstitutionPattern, serviceBaseURL, invCatSpecVersion, dqcSpecVersion))) {
                log.warn("readConfigItem(): Config already contains item for this id <" + id + ">.");
                return;
            }
        } else {
            log.warn("readConfigItem(): Wrong number of attributes for latestItem <" + numAtts + "> - continue with next latestItem.");
            return;
        }
    }

    private static LatestConfig readOldConfig(Element rootElem) {
        String oldRootElemName = "preferences";
        String old2ndElemName = "root";
        String old3rdElemName = "map";
        String groupElemName = "bean";
        String groupCollectionElemName = "beanCollection";
        if (!rootElem.getName().equals(oldRootElemName)) {
            log.error("readOldConfig(): Root element <" + rootElem.getName() + "> not as expected <" + oldRootElemName + ">.");
            return null;
        }
        Element old2ndElem = rootElem.getChild(old2ndElemName);
        if (old2ndElem == null) {
            log.error("readOldConfig(): No second level element with expected name <" + old2ndElemName + ">.");
            return null;
        }
        Element old3rdElem = old2ndElem.getChild(old3rdElemName);
        if (old3rdElem == null) {
            log.error("readOldConfig(): No third level element with expected name <" + old3rdElemName + ">.");
            return null;
        }
        Element groupElem = old3rdElem.getChild(groupElemName);
        if (groupElem == null) {
            log.error("readOldConfig(): No group element with expected name <" + groupElemName + ">.");
            return null;
        }
        String dirName = groupElem.getAttributeValue("dirName");
        String dirNameRoot = groupElem.getAttributeValue("dirNameRoot");
        if (dirName == null || dirNameRoot == null) {
            log.error("readOldConfig(): Null value for dirName or dirNameRoot.");
            return null;
        }
        if (!dirName.startsWith(dirNameRoot)) {
            log.error("readOldConfig(): dirName <" + dirName + "> must start with dirNameRoot <" + dirNameRoot + ">.");
            return null;
        }
        String dirLocation = dirName.endsWith("/") ? dirName.substring(0, dirName.length()) : dirName;
        String datasetNameMatchPattern = groupElem.getAttributeValue("matchPattern");
        String datasetTimeSubstitutionPattern = groupElem.getAttributeValue("substitutePattern");
        String serviceBaseURL = groupElem.getAttributeValue("serviceBaseURL");
        serviceBaseURL = serviceBaseURL + (serviceBaseURL.endsWith("/") ? "" : "/") + dirName.substring(dirNameRoot.length());
        String invCatSpecVersion = groupElem.getAttributeValue("invCatSpecVersion");
        String dqcSpecVersion = groupElem.getAttributeValue("dqcSpecVersion");
        Element groupCollectionElem = old3rdElem.getChild(groupCollectionElemName);
        if (groupCollectionElem == null) {
            log.error("readOldConfig(): No group collection element with expected name <" + groupCollectionElemName + ">.");
            return null;
        }
        LatestConfig config = new LatestConfig();
        LatestConfigFactory.readOldConfigGroup(groupCollectionElem, config, dirLocation, datasetNameMatchPattern, datasetTimeSubstitutionPattern, serviceBaseURL, invCatSpecVersion, dqcSpecVersion);
        return config;
    }

    private static void readOldConfigGroup(Element groupCollectionElem, LatestConfig config, String dirLocation, String datasetNameMatchPattern, String datasetTimeSubstitutionPattern, String serviceBaseURL, String invCatSpecVersion, String dqcSpecVersion) {
        for (Element curElem : groupCollectionElem.getChildren("bean")) {
            String id = curElem.getAttributeValue("name");
            String name = curElem.getAttributeValue("value");
            if (id == null || name == null || dirLocation == null || datasetNameMatchPattern == null || datasetTimeSubstitutionPattern == null || serviceBaseURL == null || invCatSpecVersion == null || dqcSpecVersion == null) {
                log.warn("readOldConfigGroup(): Null value for at least one attribute of latestItem - continue with next latestItem.");
                return;
            }
            if (config.addItem(id, new LatestConfig.Item(id, name, dirLocation, datasetNameMatchPattern.replaceAll("@model@", id), datasetTimeSubstitutionPattern, serviceBaseURL, invCatSpecVersion, dqcSpecVersion))) continue;
            log.warn("readOldConfigGroup(): Config already contains item for this id <" + id + ">.");
            return;
        }
    }

    private static void checkConfigRefConsitency(LatestConfig config) {
        ArrayList itemsToRemove = new ArrayList();
        for (String curId : config.getIds()) {
            LatestConfig.Item referencedItem;
            LatestConfig.Item curItem = config.getItem(curId);
            String curRefId = curItem.getRefId();
            if (curRefId == null || curRefId == null || (referencedItem = LatestConfigFactory.isEndOfRefChainValid(curItem, config, itemsToRemove)) == null) continue;
            curItem.setReferencedItem(referencedItem);
        }
        for (String curRemoveId : itemsToRemove) {
            config.removeItem(curRemoveId);
        }
    }

    private static LatestConfig.Item isEndOfRefChainValid(LatestConfig.Item curItem, LatestConfig config, List listOfItemsToRemove) {
        if (curItem.getRefId() == null) {
            return curItem;
        }
        LatestConfig.Item nextItem = config.getItem(curItem.getRefId());
        if (nextItem == null) {
            if (!listOfItemsToRemove.contains(curItem.getId())) {
                listOfItemsToRemove.add(curItem.getId());
            }
            log.warn("Item <id=" + curItem.getId() + "> refers to non-existent Item <id=" + curItem.getRefId() + ">; it will be removed from config.");
            return null;
        }
        LatestConfig.Item referencedItem = LatestConfigFactory.isEndOfRefChainValid(nextItem, config, listOfItemsToRemove);
        if (referencedItem == null) {
            if (!listOfItemsToRemove.contains(curItem.getId())) {
                listOfItemsToRemove.add(curItem.getId());
            }
            log.warn("Item <id=" + curItem.getId() + "> on chain that refers to non-existent Item; it will be removed from config.");
            return null;
        }
        curItem.setReferencedItem(referencedItem);
        return referencedItem;
    }

    private static void addConfigItemElements(Element rootElem, LatestConfig config) {
        Iterator it = config.getIds().iterator();
        while (it.hasNext()) {
            LatestConfig.Item curItem = config.getItem((String)it.next());
            Element curItemElement = new Element(itemElemName);
            curItemElement.setAttribute(itemIdAttName, curItem.getId());
            if (curItem.getRefId() != null) {
                curItemElement.setAttribute(itemRefIdAttName, curItem.getRefId());
            } else {
                curItemElement.setAttribute(itemNameAttName, curItem.getName());
                curItemElement.setAttribute(itemDirLocationAttName, curItem.getDirLocation());
                curItemElement.setAttribute(itemDatasetNameMatchPatternAttName, curItem.getDatasetNameMatchPattern());
                curItemElement.setAttribute(itemDatasetTimeSubstitutionPatternAttName, curItem.getDatasetTimeSubstitutionPattern());
                curItemElement.setAttribute(itemServiceBaseURLAttName, curItem.getServiceBaseURL());
                curItemElement.setAttribute(itemInvCatSpecVersionAttName, curItem.getInvCatSpecVersion());
                curItemElement.setAttribute(itemDqcSpecVersionAttName, curItem.getDqcSpecVersion());
            }
            rootElem.addContent((Content)curItemElement);
        }
    }
}

