/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.cataloggen;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.cataloggen.CatGenConfig;
import thredds.server.cataloggen.CatGenTaskConfig;
import thredds.server.cataloggen.CatGenTaskRunner;

public class CatGenTaskScheduler {
    private static Logger log = LoggerFactory.getLogger(CatGenTaskScheduler.class);
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final List<ScheduledFuture> scheduledTasks = new ArrayList<ScheduledFuture>();
    private final CatGenConfig config;
    private final File configDir;
    private final File resultDir;
    private final File altResultsDir;

    CatGenTaskScheduler(CatGenConfig config, File configDir, File resultDir, File altResultsDir) {
        this.config = config;
        this.configDir = configDir;
        this.resultDir = resultDir;
        this.altResultsDir = altResultsDir;
    }

    void start() {
        for (CatGenTaskConfig curTask : this.config.getTaskInfoList()) {
            if (curTask.getPeriodInMinutes() <= 0 || this.scheduler.isShutdown()) continue;
            CatGenTaskRunner catGenTaskRunner = new CatGenTaskRunner(curTask, this.configDir, this.resultDir, this.altResultsDir);
            this.scheduledTasks.add(this.scheduler.scheduleAtFixedRate(catGenTaskRunner, curTask.getDelayInMinutes(), curTask.getPeriodInMinutes(), TimeUnit.MINUTES));
        }
    }

    void stop() {
        this.scheduler.shutdown();
    }
}

