/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.cdmremote;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom2.Document;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.transform.XSLTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractCommandController;
import thredds.catalog.InvDatasetFeatureCollection;
import thredds.server.cdmremote.CdmRemoteQueryBean;
import thredds.server.config.TdsContext;
import thredds.servlet.DatasetHandler;
import thredds.servlet.ServletUtil;
import ucar.nc2.NetcdfFile;
import ucar.nc2.constants.CDM;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.point.remote.PointStream;
import ucar.nc2.ft.point.remote.PointStreamProto;
import ucar.nc2.ft.point.writer.FeatureDatasetPointXML;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamProto;
import ucar.nc2.stream.NcStreamWriter;
import ucar.nc2.util.DiskCache2;

public class CdmrFeatureController
extends AbstractCommandController {
    private static final Logger log = LoggerFactory.getLogger(CdmrFeatureController.class);
    private static boolean debug = false;
    private static boolean showTime = false;
    private static boolean showReq = false;
    private static DiskCache2 diskCache;
    private static boolean allow;
    private TdsContext tdsContext;

    public static void setDiskCache(DiskCache2 _diskCache) {
        diskCache = _diskCache;
    }

    public void setAllow(boolean _allow) {
        allow = _allow;
    }

    public CdmrFeatureController() {
        this.setCommandClass(CdmRemoteQueryBean.class);
        this.setCommandName("PointQueryBean");
    }

    public void setTdsContext(TdsContext tdsContext) {
        this.tdsContext = tdsContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ModelAndView handle(HttpServletRequest req, HttpServletResponse res, Object command, BindException errors) throws Exception {
        ModelAndView modelAndView;
        if (!allow) {
            res.sendError(403, "Service not supported");
            return null;
        }
        String absPath = ServletUtil.getRequestServer(req) + req.getContextPath() + req.getServletPath() + req.getPathInfo();
        String path = req.getPathInfo();
        if (showReq) {
            System.out.printf("CdmFeatureController req=%s%n", absPath + "?" + req.getQueryString());
        }
        if (debug) {
            System.out.printf(" path=%s%n query=%s%n", path, req.getQueryString());
        }
        CdmRemoteQueryBean query = null;
        try {
            query = (CdmRemoteQueryBean)command;
            if (!query.validate()) {
                res.sendError(400, query.getErrorMessage());
                if (!debug) return null;
                System.out.printf(" query error= %s %n", query.getErrorMessage());
                return null;
            }
        }
        catch (Throwable t) {
            res.sendError(400, t.getMessage());
        }
        if (debug) {
            System.out.printf(" %s%n", query);
        }
        FeatureDatasetPoint fdp = null;
        InvDatasetFeatureCollection fc = DatasetHandler.getFeatureCollection(req, res, path);
        if (fc != null) {
            fdp = fc.getFeatureDatasetPoint();
        } else {
            FeatureDataset fd;
            NetcdfFile ncfile = DatasetHandler.getNetcdfFile(req, res, path);
            if (ncfile != null && (fd = FeatureDatasetFactoryManager.wrap((FeatureType)FeatureType.ANY, (NetcdfDataset)NetcdfDataset.wrap((NetcdfFile)ncfile, null), null, (Formatter)new Formatter(System.err))) instanceof FeatureDatasetPoint) {
                fdp = (FeatureDatasetPoint)fd;
            }
        }
        if (fdp == null) {
            res.sendError(404, "not a point or station dataset");
            return null;
        }
        List list = fdp.getPointFeatureCollectionList();
        if (list.size() == 0) {
            log.error(fdp.getLocation() + " does not have any PointFeatureCollections");
            res.sendError(404, fdp.getLocation() + " does not have any PointFeatureCollections");
            return null;
        }
        FeatureType ft = null;
        if (path.endsWith("/station")) {
            ft = FeatureType.STATION;
            path = path.substring(0, path.lastIndexOf(47));
        } else if (path.endsWith("/point")) {
            ft = FeatureType.POINT;
            path = path.substring(0, path.lastIndexOf(47));
        }
        if (ft != null && ft != fdp.getFeatureType()) {
            res.sendError(404, "feature type mismatch:  expetected " + ft + " found" + fdp.getFeatureType());
        }
        try {
            CdmRemoteQueryBean.RequestType reqType = query.getRequestType();
            CdmRemoteQueryBean.ResponseType resType = query.getResponseType();
            switch (reqType) {
                case capabilities: 
                case form: {
                    ModelAndView modelAndView2 = this.processXml(req, res, fdp, absPath, query);
                    return modelAndView2;
                }
                case header: {
                    ModelAndView modelAndView3 = this.processHeader(absPath, res, fdp, query);
                    return modelAndView3;
                }
                case dataForm: 
                case data: {
                    ModelAndView modelAndView4 = this.processData(req, res, fdp, path, query);
                    return modelAndView4;
                }
                case stations: {
                    if (resType == CdmRemoteQueryBean.ResponseType.xml) {
                        ModelAndView modelAndView5 = this.processXml(req, res, fdp, absPath, query);
                        return modelAndView5;
                    }
                    ModelAndView modelAndView6 = this.processStations(res, fdp, query);
                    return modelAndView6;
                }
            }
            return null;
        }
        catch (FileNotFoundException e) {
            res.sendError(404, e.getMessage());
            modelAndView = null;
            return modelAndView;
        }
        catch (Throwable t) {
            log.error("CdmRemoteController exception:", t);
            res.sendError(500, t.getMessage());
            modelAndView = null;
            return modelAndView;
        }
        finally {
            if (showReq) {
                System.out.printf(" done%n", new Object[0]);
            }
            if (null != fdp) {
                try {
                    fdp.close();
                }
                catch (IOException ioe) {
                    log.error("Failed to close = " + path);
                }
            }
        }
    }

    private String getContentType(CdmRemoteQueryBean query) {
        CdmRemoteQueryBean.RequestType reqType = query.getRequestType();
        if (reqType == CdmRemoteQueryBean.RequestType.form) {
            return "text/html; charset=iso-8859-1";
        }
        CdmRemoteQueryBean.ResponseType resType = query.getResponseType();
        switch (resType) {
            case csv: {
                return "text/plain";
            }
            case netcdf: {
                return "application/x-netcdf";
            }
            case ncstream: {
                return "application/octet-stream";
            }
            case xml: {
                return "application/xml";
            }
        }
        return "text/plain";
    }

    private String getContentDescription(CdmRemoteQueryBean query) {
        CdmRemoteQueryBean.ResponseType resType = query.getResponseType();
        switch (resType) {
            case ncstream: {
                return "ncstream";
            }
        }
        return null;
    }

    private ModelAndView processData(HttpServletRequest req, HttpServletResponse res, FeatureDatasetPoint fdp, String path, CdmRemoteQueryBean qb) throws IOException {
        long start = 0L;
        switch (fdp.getFeatureType()) {
            case POINT: {
                return this.processPointData(req, res, fdp, path, qb);
            }
            case STATION: {
                return this.processStationData(req, res, fdp, path, qb);
            }
        }
        return null;
    }

    private ModelAndView processPointData(HttpServletRequest req, HttpServletResponse res, FeatureDatasetPoint fdp, String path, CdmRemoteQueryBean qb) throws IOException {
        return null;
    }

    private ModelAndView processStationData(HttpServletRequest req, HttpServletResponse res, FeatureDatasetPoint fdp, String path, CdmRemoteQueryBean qb) throws IOException {
        return null;
    }

    private ModelAndView processStations(HttpServletResponse res, FeatureDatasetPoint fdp, CdmRemoteQueryBean query) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream((OutputStream)res.getOutputStream(), 10000);
        res.setContentType(this.getContentType(query));
        if (null != this.getContentDescription(query)) {
            res.setHeader("Content-Description", this.getContentDescription(query));
        }
        try {
            List coll = fdp.getPointFeatureCollectionList();
            StationTimeSeriesFeatureCollection sfc = (StationTimeSeriesFeatureCollection)coll.get(0);
            List stations = query.getLatLonRect() != null ? sfc.getStations(query.getLatLonRect()) : (query.getStnNames() != null ? sfc.getStations(Arrays.asList(query.getStnNames())) : sfc.getStations());
            PointStreamProto.StationList stationsp = PointStream.encodeStations((List)stations);
            byte[] b = stationsp.toByteArray();
            PointStream.writeMagic((OutputStream)out, (PointStream.MessageType)PointStream.MessageType.StationList);
            NcStream.writeVInt((OutputStream)out, (int)b.length);
            ((OutputStream)out).write(b);
        }
        catch (Throwable t) {
            NcStreamProto.Error err = NcStream.encodeErrorMessage((String)t.getMessage());
            byte[] b = err.toByteArray();
            PointStream.writeMagic((OutputStream)out, (PointStream.MessageType)PointStream.MessageType.Error);
            NcStream.writeVInt((OutputStream)out, (int)b.length);
            ((OutputStream)out).write(b);
            throw new IOException(t);
        }
        ((OutputStream)out).flush();
        res.flushBuffer();
        return null;
    }

    private ModelAndView processHeader(String absPath, HttpServletResponse res, FeatureDatasetPoint fdp, CdmRemoteQueryBean query) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream((OutputStream)res.getOutputStream(), 10000);
        res.setContentType(this.getContentType(query));
        if (null != this.getContentDescription(query)) {
            res.setHeader("Content-Description", this.getContentDescription(query));
        }
        NetcdfFile ncfile = fdp.getNetcdfFile();
        NcStreamWriter ncWriter = new NcStreamWriter(ncfile, absPath);
        long size = ncWriter.sendHeader((OutputStream)out);
        NcStream.writeVInt((OutputStream)out, (int)0);
        ((OutputStream)out).flush();
        res.flushBuffer();
        return null;
    }

    private ModelAndView processXml(HttpServletRequest req, HttpServletResponse res, FeatureDatasetPoint fdp, String absPath, CdmRemoteQueryBean query) throws IOException {
        String infoString;
        block5: {
            FeatureDatasetPointXML xmlWriter = new FeatureDatasetPointXML(fdp, absPath);
            CdmRemoteQueryBean.RequestType reqType = query.getRequestType();
            try {
                Document doc;
                if (reqType == CdmRemoteQueryBean.RequestType.capabilities) {
                    doc = xmlWriter.getCapabilitiesDocument();
                    XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
                    infoString = fmt.outputString(doc);
                    break block5;
                }
                if (reqType == CdmRemoteQueryBean.RequestType.stations) {
                    doc = xmlWriter.makeStationCollectionDocument(query.getLatLonRect(), query.getStnNames());
                    XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
                    infoString = fmt.outputString(doc);
                    break block5;
                }
                if (reqType == CdmRemoteQueryBean.RequestType.form) {
                    String xslt = fdp.getFeatureType() == FeatureType.STATION ? "ncssSobs.xsl" : "fmrcPoint.xsl";
                    InputStream is = this.getXSLT(xslt);
                    Document doc2 = xmlWriter.getCapabilitiesDocument();
                    XSLTransformer transformer = new XSLTransformer(is);
                    Document html = transformer.transform(doc2);
                    XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
                    infoString = fmt.outputString(html);
                    break block5;
                }
                return null;
            }
            catch (Exception e) {
                log.error("SobsServlet internal error on " + fdp.getLocation(), (Throwable)e);
                res.sendError(500, "SobsServlet internal error");
                return null;
            }
        }
        res.setContentLength(infoString.length());
        res.setContentType(this.getContentType(query));
        ServletOutputStream out = res.getOutputStream();
        out.write(infoString.getBytes(CDM.utf8Charset));
        out.flush();
        return null;
    }

    private InputStream getXSLT(String xslName) {
        return ((Object)((Object)this)).getClass().getResourceAsStream("/resources/xsl/" + xslName);
    }

    static {
        allow = true;
    }
}

