/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset.controller;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import thredds.server.ncSubset.controller.AbstractNcssController;
import thredds.servlet.DatasetHandler;
import thredds.servlet.ThreddsConfig;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridDataset;

public class NcssInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(NcssInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        boolean allow = ThreddsConfig.getBoolean("NetcdfSubsetService.allow", false);
        if (handler instanceof HandlerMethod) {
            AbstractNcssController hm = (AbstractNcssController)((HandlerMethod)handler).getBean();
            String servletPath = request.getServletPath();
            String pathInfo = servletPath.substring(AbstractNcssController.getServletPath().length(), servletPath.length());
            if (pathInfo == null) {
                response.sendError(404);
                return false;
            }
            GridDataset gds = this.getGridDataset(request, response, hm.extractRequestPathInfo(pathInfo));
            hm.setGridDataset(gds);
            return allow && gds != null;
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        this.closeGridDataset(handler);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        this.closeGridDataset(handler);
    }

    private GridDataset getGridDataset(HttpServletRequest req, HttpServletResponse res, String pathInfo) throws IOException {
        GridDataset gds;
        block5: {
            gds = null;
            try {
                Set<NetcdfDataset.Enhance> enhance = Collections.unmodifiableSet(EnumSet.of(NetcdfDataset.Enhance.CoordSystems, NetcdfDataset.Enhance.ConvertEnums));
                gds = DatasetHandler.openGridDataset(req, res, pathInfo, enhance);
                if (null == gds) {
                    res.sendError(404);
                }
            }
            catch (FileNotFoundException ioe) {
                if (!res.isCommitted()) {
                    res.sendError(404);
                }
            }
            catch (Throwable e) {
                log.error("GridServlet.showForm", e);
                if (res.isCommitted()) break block5;
                res.sendError(500);
            }
        }
        return gds;
    }

    private void closeGridDataset(Object handler) {
        AbstractNcssController hm;
        GridDataset gds;
        if (handler instanceof HandlerMethod && null != (gds = (hm = (AbstractNcssController)((HandlerMethod)handler).getBean()).getGridDataset())) {
            try {
                gds.close();
            }
            catch (IOException ioe) {
                log.error("Failed to close = " + hm.getRequestPathInfo());
            }
        }
    }
}

