/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.cataloggen;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.cataloggen.CatGenConfig;
import thredds.server.cataloggen.CatGenTaskConfig;

public class CatGenConfigParser {
    private static Logger log = LoggerFactory.getLogger(CatGenConfigParser.class);
    private String rootElemName = "preferences";
    private String extXmlVerAttName = "EXTERNAL_XML_VERSION";
    private String extXmlVerAttVal = "1.0";
    private String rootUserElemName = "root";
    private String rootUserAttName = "type";
    private String rootUserAttVal = "user";
    private String mapElemName = "map";
    private String beanCollElemName = "beanCollection";
    private String beanCollKeyAttName = "key";
    private String beanCollKeyAttVal = "config";
    private String beanCollClassAttName = "class";
    private String beanCollClassAttVal = "thredds.cataloggen.servlet.CatGenTimerTask";
    private String beanElemName = "bean";
    private String beanNameAttName = "name";
    private String beanConfigDocNameAttName = "configDocName";
    private String beanResultFileNameAttName = "resultFileName";
    private String beanDelayAttName = "delayInMinutes";
    private String beanPeriodAttName = "periodInMinutes";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CatGenConfig parseXML(File inFile) throws IOException {
        if (inFile == null) {
            throw new IllegalArgumentException("File must not be null.");
        }
        FileInputStream inStream = null;
        CatGenConfig config = null;
        try {
            inStream = new FileInputStream(inFile);
            config = this.parseXML(inStream, inFile.getPath());
        }
        catch (IOException e) {
            log.error("parseXML(): Could not read config file: " + e.getMessage());
            CatGenConfig catGenConfig = new CatGenConfig("Could not read config file.");
            return catGenConfig;
        }
        finally {
            inStream.close();
        }
        return config;
    }

    public CatGenConfig parseXML(InputStream inStream, String docId) throws IOException {
        Document doc;
        if (inStream == null) {
            throw new IllegalArgumentException("Input stream must not be null.");
        }
        SAXBuilder builder = new SAXBuilder();
        log.debug("parseXML(): Parsing latest config doc \"" + docId + "\".");
        try {
            doc = builder.build(inStream);
        }
        catch (JDOMException e) {
            log.error("parseXML(): Bad config doc <" + docId + ">: " + e.getMessage());
            return new CatGenConfig("Could not parse config document.");
        }
        CatGenConfig config = this.readConfig(doc.getRootElement());
        if (config.getTaskInfoList().isEmpty()) {
            log.warn("parseXML(): Empty config file <" + docId + ">.");
        }
        return config;
    }

    private CatGenConfig readConfig(Element rootElem) {
        if (!rootElem.getName().equals(this.rootElemName)) {
            log.error("readConfig(): Root element <" + rootElem.getName() + "> not as expected <" + this.rootElemName + ">.");
            return new CatGenConfig("Invalid config document.");
        }
        Element rootUserElem = rootElem.getChild(this.rootUserElemName);
        Element mapElem = rootUserElem.getChild(this.mapElemName);
        Element beanColElem = mapElem.getChild(this.beanCollElemName);
        if (beanColElem == null) {
            log.info("readConfig(): empty \"map\" element.");
            return new CatGenConfig();
        }
        String keyAttVal = beanColElem.getAttributeValue(this.beanCollKeyAttName);
        String classAttVal = beanColElem.getAttributeValue(this.beanCollClassAttName);
        if (!keyAttVal.equals(this.beanCollKeyAttVal)) {
            log.error("readConfig(): bean collection element key attribute <" + keyAttVal + "> not as expected <" + this.beanCollKeyAttVal + ">.");
            return new CatGenConfig("Invalid config document.");
        }
        if (!classAttVal.equals(this.beanCollClassAttVal)) {
            log.error("readConfig(): bean collection element class attribute <" + classAttVal + "> not as expected <" + this.beanCollClassAttVal + ">.");
            return new CatGenConfig("Invalid config document.");
        }
        ArrayList<CatGenTaskConfig> configList = new ArrayList<CatGenTaskConfig>();
        for (Element curBeanElem : beanColElem.getChildren(this.beanElemName)) {
            String name = curBeanElem.getAttributeValue(this.beanNameAttName);
            String configDocName = curBeanElem.getAttributeValue(this.beanConfigDocNameAttName);
            String resultFileName = curBeanElem.getAttributeValue(this.beanResultFileNameAttName);
            Attribute delayInMinutesAtt = curBeanElem.getAttribute(this.beanDelayAttName);
            Attribute periodInMinutesAtt = curBeanElem.getAttribute(this.beanPeriodAttName);
            try {
                int delayInMinutes = delayInMinutesAtt.getIntValue();
                int periodInMinutes = periodInMinutesAtt.getIntValue();
                configList.add(new CatGenTaskConfig(name, configDocName, resultFileName, periodInMinutes, delayInMinutes));
            }
            catch (DataConversionException e) {
                log.error("readConfig(): bean element delay or period attribute not an integer value: " + e.getMessage());
                configList.add(new CatGenTaskConfig(name + " - ***Invalid Task*** - Delay <" + delayInMinutesAtt.getValue() + "> or period <" + periodInMinutesAtt.getValue() + "> not integer value.", configDocName, resultFileName, 0, 0));
            }
        }
        return new CatGenConfig(configList);
    }

    public void writeXML(File outFile, CatGenConfig config) throws IOException {
        FileOutputStream outStream = new FileOutputStream(outFile);
        this.writeXML(outStream, config);
        outStream.close();
    }

    public void writeXML(OutputStream outStream, CatGenConfig config) throws IOException {
        Element rootElem = new Element(this.rootElemName);
        rootElem.setAttribute(this.extXmlVerAttName, this.extXmlVerAttVal);
        Document doc = new Document(rootElem);
        Element rootUserElem = new Element(this.rootUserElemName);
        rootUserElem.setAttribute(this.rootUserAttName, this.rootUserAttVal);
        rootElem.addContent((Content)rootUserElem);
        Element mapElem = new Element(this.mapElemName);
        rootUserElem.addContent((Content)mapElem);
        Element beanCollElem = new Element(this.beanCollElemName);
        beanCollElem.setAttribute(this.beanCollKeyAttName, this.beanCollKeyAttVal);
        beanCollElem.setAttribute(this.beanCollClassAttName, this.beanCollClassAttVal);
        mapElem.addContent((Content)beanCollElem);
        for (CatGenTaskConfig curTask : config.getTaskInfoList()) {
            Element curItemElem = new Element(this.beanElemName);
            curItemElem.setAttribute(this.beanNameAttName, curTask.getName());
            curItemElem.setAttribute(this.beanConfigDocNameAttName, curTask.getConfigDocName());
            curItemElem.setAttribute(this.beanResultFileNameAttName, curTask.getResultFileName());
            curItemElem.setAttribute(this.beanDelayAttName, Integer.toString(curTask.getDelayInMinutes()));
            curItemElem.setAttribute(this.beanPeriodAttName, Integer.toString(curTask.getPeriodInMinutes()));
            beanCollElem.addContent((Content)curItemElem);
        }
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        outputter.output(doc, outStream);
    }
}

