/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import opendap.dap.AttributeExistsException;
import opendap.dap.AttributeTable;
import opendap.dap.DAS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dods.DODSNetcdfFile;

public class NcDAS
extends DAS {
    private static Logger log = LoggerFactory.getLogger(NcDAS.class);
    private HashMap usedDims = new HashMap();

    NcDAS(NetcdfFile ncfile) {
        for (Variable v : ncfile.getVariables()) {
            this.doVariable(v, null);
        }
        AttributeTable gtable = new AttributeTable("NC_GLOBAL");
        int count = this.addAttributes(gtable, null, ncfile.getGlobalAttributes().iterator());
        if (count > 0) {
            try {
                this.addAttributeTable("NC_GLOBAL", gtable);
            }
            catch (AttributeExistsException e) {
                log.error("Cant add NC_GLOBAL", (Throwable)e);
            }
        }
        for (Dimension d : ncfile.getDimensions()) {
            if (!d.isUnlimited()) continue;
            AttributeTable table = new AttributeTable("DODS_EXTRA");
            try {
                table.appendAttribute("Unlimited_Dimension", 10, d.getShortName());
                this.addAttributeTable("DODS_EXTRA", table);
            }
            catch (Exception e) {
                log.error("Error adding Unlimited_Dimension =" + e);
            }
            break;
        }
        AttributeTable dimTable = null;
        for (Dimension d : ncfile.getDimensions()) {
            if (null != this.usedDims.get(d.getShortName())) continue;
            if (dimTable == null) {
                dimTable = new AttributeTable("EXTRA_DIMENSION");
            }
            try {
                dimTable.appendAttribute(d.getShortName(), 6, Integer.toString(d.getLength()));
            }
            catch (Exception e) {
                log.error("Error adding Unlimited_Dimension =" + e);
            }
        }
        if (dimTable != null) {
            try {
                this.addAttributeTable("EXTRA_DIMENSION", dimTable);
            }
            catch (AttributeExistsException e) {
                log.error("Cant add EXTRA_DIMENSION", (Throwable)e);
            }
        }
    }

    private void doVariable(Variable v, AttributeTable parentTable) {
        AttributeTable table;
        List dims = v.getDimensions();
        for (int i = 0; i < dims.size(); ++i) {
            Dimension dim = (Dimension)dims.get(i);
            if (!dim.isShared()) continue;
            this.usedDims.put(dim.getShortName(), dim);
        }
        String name = Variable.getDAPName((Variable)v);
        if (parentTable == null) {
            table = new AttributeTable(name);
            try {
                this.addAttributeTable(name, table);
            }
            catch (AttributeExistsException e) {
                log.error("Cant add " + name, (Throwable)e);
            }
        } else {
            table = parentTable.appendContainer(name);
        }
        this.addAttributes(table, v, v.getAttributes().iterator());
        if (v instanceof Structure) {
            Structure s = (Structure)v;
            List nested = s.getVariables();
            for (int i = 0; i < nested.size(); ++i) {
                Variable nv = (Variable)nested.get(i);
                this.doVariable(nv, table);
            }
        }
    }

    private int addAttributes(AttributeTable table, Variable v, Iterator iter) {
        int count = 0;
        while (iter.hasNext()) {
            Attribute att = (Attribute)iter.next();
            int dods_type = DODSNetcdfFile.convertToDODSType((DataType)att.getDataType(), (boolean)false);
            try {
                String attName = att.getShortName();
                if (att.isString()) {
                    table.appendAttribute(attName, dods_type, att.getStringValue());
                } else {
                    if (att.getDataType() == DataType.BYTE) {
                        boolean signed = false;
                        for (int i = 0; i < att.getLength(); ++i) {
                            if (att.getNumericValue(i).byteValue() >= 0) continue;
                            signed = true;
                        }
                        if (signed) {
                            dods_type = 4;
                        }
                    }
                    for (int i = 0; i < att.getLength(); ++i) {
                        table.appendAttribute(attName, dods_type, att.getNumericValue(i).toString());
                    }
                }
                ++count;
            }
            catch (Exception e) {
                log.error("Error appending attribute " + att.getShortName() + " = " + att.getStringValue() + "\n" + e);
            }
        }
        if (v != null && v.getDataType().getPrimitiveClassType() == Character.TYPE) {
            int rank = v.getRank();
            int strlen = rank == 0 ? 0 : v.getShape(rank - 1);
            Dimension dim = rank == 0 ? null : v.getDimension(rank - 1);
            try {
                AttributeTable dodsTable = table.appendContainer("DODS");
                dodsTable.appendAttribute("strlen", 6, Integer.toString(strlen));
                if (dim != null && dim.isShared()) {
                    dodsTable.appendAttribute("dimName", 10, dim.getShortName());
                }
                ++count;
            }
            catch (Exception e) {
                log.error("Error appending attribute strlen\n" + e);
            }
        }
        return count;
    }
}

