/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.radarServer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import thredds.catalog.query.Location;
import thredds.catalog.query.SelectStation;
import thredds.catalog.query.Selector;
import thredds.catalog.query.Station;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class ServerMethods {
    public static final Pattern p_all_i = Pattern.compile("all", 2);
    public static final Pattern p_ascii_i = Pattern.compile("ascii", 2);
    public static final Pattern p_B_pound = Pattern.compile("^#");
    public static final Pattern p_catalog_i = Pattern.compile("catalog", 2);
    public static final Pattern p_config = Pattern.compile("(\\w+)\\s*=\\s+?(.*)");
    public static final Pattern p_dataset = Pattern.compile("ID=\"(.*)\"\\s+path=\"(.*)\"\\s+dirLocation=\"(.*)\"\\s+filter");
    public static final Pattern p_B_D8 = Pattern.compile("^\\d{8}");
    public static final Pattern p_DODS_i = Pattern.compile("(DODS|OPENDAP)", 2);
    public static final Pattern p_HTTPServer_i = Pattern.compile("HTTPServer", 2);
    public static final Pattern p_html_i = Pattern.compile("html", 2);
    public static final Pattern p_isodate = Pattern.compile("(\\d{4})-(\\d{2})-(\\d{2})T(\\d{2}):(\\d{2}):(\\d{2})");
    public static final Pattern p_latitude_longitude = Pattern.compile("latitude=\"([-.0-9]*)\"\\s+longitude=\"([-.0-9]*)\"");
    public static final Pattern p_name_value2 = Pattern.compile("name=\"([A-Za-z0-9 ()_,-:]*)\"\\s*");
    public static final Pattern p_nexrad2 = Pattern.compile("ID=\"(\\w+)/NEXRAD2\"\\s+path=\"(.*)\"\\s+dirLocation=\"(.*)\"\\s+filter");
    public static final Pattern p_qc_or_dqc_i = Pattern.compile("(qc|dqc)", 2);
    public static final Pattern p_space20 = Pattern.compile("%20");
    public static final Pattern p_spaces = Pattern.compile("\\s+");
    public static final Pattern p_station_name = Pattern.compile("\\s*<station\\s+name=\"(.*)\" ");
    public static final Pattern p_stn_i = Pattern.compile("stn", 2);
    public static final Pattern p_value2 = Pattern.compile("value=\"([A-Z0-9]*)\"");
    public static final Pattern p_xml_i = Pattern.compile("xml", 2);
    public static final Pattern p_yyyymmdd = Pattern.compile("(\\d{8})");
    public static final Pattern p_yymmdd_hhmm = Pattern.compile("(\\d{2})(\\d{4}_\\d{4})");
    public static final Pattern p_yyyymmdd_hhmm = Pattern.compile("(\\d{8}_\\d{4})");
    public static final String epic = "1970-01-01T00:00:00";
    protected static SimpleDateFormat dateFormatISO = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    protected static SimpleDateFormat dateFormat;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public ServerMethods(Logger log) {
    }

    public String[] getDAYS(String dirS, PrintWriter pw) {
        Date now = Calendar.getInstance().getTime();
        String check = dateFormat.format(now);
        File dir = new File(dirS);
        if (!dir.exists()) {
            return null;
        }
        String[] TMP = dir.list();
        ArrayList<String> days = new ArrayList<String>();
        for (int i = 0; i < TMP.length; ++i) {
            if (!p_B_D8.matcher(TMP[i]).find() || TMP[i].compareTo(check) > 0) continue;
            days.add(TMP[i]);
        }
        Collections.sort(days, new CompareKeyDescend());
        String[] DAYS = new String[days.size()];
        DAYS = days.toArray(DAYS);
        return DAYS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Station> getStations(String stnLocation) {
        ArrayList<Station> stationList = new ArrayList<Station>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        SelectStation parent = new SelectStation();
        InputStream is = null;
        try {
            DocumentBuilder parser = factory.newDocumentBuilder();
            is = new FileInputStream(stnLocation);
            Document doc = parser.parse(is);
            NodeList stns = doc.getElementsByTagName("station");
            for (int i = 0; i < stns.getLength(); ++i) {
                NamedNodeMap attr = stns.item(i).getAttributes();
                String name = "";
                String value = "";
                String state = "";
                String country = "";
                for (int j = 0; j < attr.getLength(); ++j) {
                    if (attr.item(j).getNodeName().equals("value")) {
                        value = attr.item(j).getNodeValue();
                        continue;
                    }
                    if (attr.item(j).getNodeName().equals("name")) {
                        name = attr.item(j).getNodeValue();
                        continue;
                    }
                    if (attr.item(j).getNodeName().equals("state")) {
                        state = attr.item(j).getNodeValue();
                        continue;
                    }
                    if (!attr.item(j).getNodeName().equals("country")) continue;
                    country = attr.item(j).getNodeValue();
                }
                NodeList child = stns.item(i).getChildNodes();
                Location location = null;
                for (int j = 0; j < child.getLength(); ++j) {
                    if (!child.item(j).getNodeName().equals("location3D")) continue;
                    NamedNodeMap ca = child.item(j).getAttributes();
                    String latitude = "";
                    String longitude = "";
                    String elevation = "";
                    for (int k = 0; k < ca.getLength(); ++k) {
                        if (ca.item(k).getNodeName().equals("latitude")) {
                            latitude = ca.item(k).getNodeValue();
                            continue;
                        }
                        if (ca.item(k).getNodeName().equals("longitude")) {
                            longitude = ca.item(k).getNodeValue();
                            continue;
                        }
                        if (!ca.item(k).getNodeName().equals("elevation")) continue;
                        elevation = ca.item(k).getNodeValue();
                    }
                    location = new Location(latitude, longitude, elevation, null, null, null);
                }
                Station station = new Station((Selector)parent, name, value, state, country, null);
                station.setLocation(location);
                stationList.add(station);
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
            stationList = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            stationList = null;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            stationList = null;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    this.log.error("radarServer getStations(): error closing" + stnLocation);
                }
            }
        }
        return stationList;
    }

    public HashMap<String, Station> getStationMap(List<Station> list) {
        HashMap<String, Station> stationMap = new HashMap<String, Station>();
        for (Station station : list) {
            stationMap.put(station.getValue(), station);
        }
        return stationMap;
    }

    public List<String> getStationNames(List<Station> stations) {
        ArrayList<String> result = new ArrayList<String>();
        for (Station s : stations) {
            result.add(s.getValue());
        }
        return result;
    }

    public List<String> convert4to3stations(List<String> stations) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : stations) {
            result.add(s.substring(1));
        }
        return result;
    }

    public List<String> getStationNames(LatLonRect boundingBox, List<Station> stations) {
        LatLonPointImpl latlonPt = new LatLonPointImpl();
        ArrayList<String> result = new ArrayList<String>();
        for (Station s : stations) {
            latlonPt.set(s.getLocation().getLatitude(), s.getLocation().getLongitude());
            if (!boundingBox.contains((LatLonPoint)latlonPt)) continue;
            result.add(s.getValue());
        }
        return result;
    }

    public String findClosestStation(double lat, double lon, List<Station> stations) {
        double cos = Math.cos(Math.toRadians(lat));
        Station min_station = stations.get(0);
        double min_dist = Double.MAX_VALUE;
        for (Station s : stations) {
            double dx;
            double lat1 = s.getLocation().getLatitude();
            double lon1 = LatLonPointImpl.lonNormal((double)s.getLocation().getLongitude(), (double)lon);
            double dy = Math.toRadians(lat - lat1);
            double dist = dy * dy + (dx = cos * Math.toRadians(lon - lon1)) * dx;
            if (!(dist < min_dist)) continue;
            min_dist = dist;
            min_station = s;
        }
        return min_station.getValue();
    }

    public static BufferedReader getInputStreamReader(String filename) throws FileNotFoundException, IOException {
        return new BufferedReader(new InputStreamReader(ServerMethods.getInputStream(filename)));
    }

    public static InputStream getInputStream(String filename) throws IOException {
        return ServerMethods.getInputStream(filename, null);
    }

    public static InputStream getInputStream(String filename, Class origin) throws IOException {
        File f;
        InputStream s = null;
        while (origin != null && (s = origin.getResourceAsStream(filename)) == null) {
            origin = origin.getSuperclass();
        }
        if (s == null) {
            s = ServerMethods.class.getResourceAsStream(filename);
        }
        if (s == null && (f = new File(filename)).exists()) {
            try {
                s = new FileInputStream(f);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (s == null) {
            try {
                String encodedUrl = p_space20.matcher(filename).replaceAll(" ");
                URL dataUrl = new URL(encodedUrl);
                URLConnection connection = dataUrl.openConnection();
                s = connection.getInputStream();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (s == null) {
            throw new FileNotFoundException("Unable to open:" + filename);
        }
        return s;
    }

    public boolean isValidDay(String dateDir, String yyyymmddStart, String yyyymmddEnd) {
        return dateDir.compareTo(yyyymmddStart) >= 0 && dateDir.compareTo(yyyymmddEnd) <= 0;
    }

    public boolean isValidDate(String dateReport, String dateStart, String dateEnd) {
        String date;
        Matcher m = p_yyyymmdd_hhmm.matcher(dateReport);
        if (m.find()) {
            date = m.group(1);
        } else {
            m = p_yymmdd_hhmm.matcher(dateReport);
            if (m.find()) {
                date = Integer.parseInt(m.group(1)) > 69 ? "19" + m.group(1) + m.group(2) : "20" + m.group(1) + m.group(2);
            } else {
                return false;
            }
        }
        return date.compareTo(dateStart) >= 0 && date.compareTo(dateEnd) <= 0;
    }

    public String hhmm(String dateTime) {
        return dateTime.substring(11, 13) + dateTime.substring(14, 16);
    }

    public String getObTimeISO(String product) {
        String date;
        Matcher m = p_yyyymmdd_hhmm.matcher(product);
        if (m.find()) {
            date = m.group(1);
        } else {
            m = p_yymmdd_hhmm.matcher(product);
            if (m.find()) {
                date = Integer.parseInt(m.group(1)) > 69 ? "19" + m.group(1) + m.group(2) : "20" + m.group(1) + m.group(2);
            } else {
                return epic;
            }
        }
        return date.substring(0, 4) + "-" + date.substring(4, 6) + "-" + date.substring(6, 8) + "T" + date.substring(9, 11) + ":" + date.substring(11, 13) + ":00";
    }

    static {
        dateFormatISO.setTimeZone(TimeZone.getTimeZone("GMT"));
        dateFormat = new SimpleDateFormat("yyyyMMdd");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    protected class CompareKeyDescend
    implements Comparator<String> {
        protected CompareKeyDescend() {
        }

        @Override
        public int compare(String s1, String s2) {
            return s2.compareTo(s1);
        }
    }
}

