/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.root;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import thredds.server.config.TdsContext;
import thredds.servlet.DataRootHandler;
import thredds.servlet.PathMatcher;
import thredds.servlet.ServletUtil;

public class LogController
extends AbstractController {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private File accessLogDirectory;
    private List<File> accessLogFiles = new ArrayList<File>(10);
    private TdsContext tdsContext;

    public void setTdsContext(TdsContext tdsContext) {
        this.tdsContext = tdsContext;
    }

    public void setAccessLogDirectory(String accessLogDirectory) {
        this.accessLogDirectory = new File(accessLogDirectory);
        this.init();
    }

    private void init() {
        for (File f : this.accessLogDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("access.");
            }
        })) {
            this.accessLogFiles.add(f);
        }
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest req, HttpServletResponse res) throws Exception {
        String path = req.getPathInfo();
        if (path == null) {
            path = "";
        }
        if (path.indexOf("/../") != -1 || path.equals("..") || path.startsWith("../") || path.endsWith("/..")) {
            res.sendError(403, "Path cannot contain ..");
            return null;
        }
        File file = null;
        if (path.equals("/log/dataroots.txt")) {
            PrintWriter pw = new PrintWriter((OutputStream)res.getOutputStream());
            PathMatcher pathMatcher = DataRootHandler.getInstance().getPathMatcher();
            Iterator iter = pathMatcher.iterator();
            while (iter.hasNext()) {
                DataRootHandler.DataRoot ds = (DataRootHandler.DataRoot)iter.next();
                pw.format("%s%n", ds.toString2());
            }
            pw.flush();
        } else if (path.equals("/log/access/current")) {
            File dir = this.tdsContext.getTomcatLogDirectory();
            File[] files = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("access");
                }
            });
            if (files == null || files.length == 0) {
                res.sendError(404);
                return null;
            }
            List<File> fileList = Arrays.asList(files);
            Collections.sort(fileList);
            file = fileList.get(fileList.size() - 1);
        } else if (path.equals("/log/access/")) {
            this.showFiles(this.tdsContext.getTomcatLogDirectory(), "access", res);
        } else {
            if (path.startsWith("/log/access/")) {
                file = new File(this.tdsContext.getTomcatLogDirectory(), path.substring(12));
                ServletUtil.returnFile(req, res, file, "text/plain");
                return null;
            }
            if (path.equals("/log/thredds/current")) {
                file = new File(this.tdsContext.getContentDirectory(), "logs/threddsServlet.log");
            } else if (path.equals("/log/thredds/")) {
                this.showFiles(new File(this.tdsContext.getContentDirectory(), "logs"), "thredds", res);
            } else {
                if (path.startsWith("/log/thredds/")) {
                    file = new File(this.tdsContext.getContentDirectory(), "logs/" + path.substring(13));
                    ServletUtil.returnFile(req, res, file, "text/plain");
                    return null;
                }
                PrintWriter pw = new PrintWriter((OutputStream)res.getOutputStream());
                pw.format("/log/access/current%n", new Object[0]);
                pw.format("/log/access/%n", new Object[0]);
                pw.format("/log/thredds/current%n", new Object[0]);
                pw.format("/log/thredds/%n", new Object[0]);
                pw.flush();
            }
        }
        if (file != null) {
            return new ModelAndView("threddsFileView", "file", (Object)file);
        }
        return null;
    }

    private void showFiles(File dir, final String filter, HttpServletResponse res) throws IOException {
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(filter);
            }
        });
        if (files == null || files.length == 0) {
            res.sendError(404);
            return;
        }
        List<File> fileList = Arrays.asList(files);
        Collections.sort(fileList);
        PrintWriter pw = new PrintWriter((OutputStream)res.getOutputStream());
        for (File f : fileList) {
            pw.format("%s %d%n", f.getName(), f.length());
        }
        pw.flush();
    }
}

