/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.cdmremote.stream;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.cdmremote.PointWriter;
import thredds.server.cdmremote.StationWriter;
import thredds.server.cdmremote.params.CdmrfQueryBean;
import thredds.server.config.TdsContext;
import thredds.servlet.ServletUtil;
import thredds.servlet.ThreddsConfig;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamWriter;
import ucar.nc2.util.DiskCache2;
import ucar.unidata.util.StringUtil2;

public final class CdmrfStreamFactory {
    private static final Logger log = LoggerFactory.getLogger(CdmrfStreamFactory.class);
    private static CdmrfStreamFactory INSTANCE;
    private DiskCache2 cdmrCache;

    private CdmrfStreamFactory(DiskCache2 cdmrCache) {
        this.cdmrCache = cdmrCache;
    }

    public static CdmrfStreamFactory getInstance(TdsContext tdsContext) {
        if (INSTANCE == null) {
            String dir = ThreddsConfig.get("CdmRemote.dir", new File(tdsContext.getContentDirectory().getPath(), "/cache/cdmr/").getPath());
            int scourSecs = ThreddsConfig.getSeconds("CdmRemote.scour", 1800);
            int maxAgeSecs = ThreddsConfig.getSeconds("CdmRemote.maxAge", 3600);
            DiskCache2 cdmrCache = new DiskCache2(dir, false, maxAgeSecs / 60, scourSecs / 60);
            INSTANCE = new CdmrfStreamFactory(cdmrCache);
        }
        return INSTANCE;
    }

    public void headerStream(String absPath, HttpServletResponse res, FeatureDatasetPoint fdp, CdmrfQueryBean query) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream((OutputStream)res.getOutputStream(), 10000);
        res.setContentType("application/octet-stream");
        res.setHeader("Content-Description", "ncstream");
        NetcdfFile ncfile = fdp.getNetcdfFile();
        NcStreamWriter ncWriter = new NcStreamWriter(ncfile, absPath);
        long size = ncWriter.sendHeader((OutputStream)out);
        NcStream.writeVInt((OutputStream)out, (int)0);
        ((OutputStream)out).flush();
        res.flushBuffer();
    }

    public void dataStream(HttpServletRequest req, HttpServletResponse res, FeatureDatasetPoint fdp, String path, CdmrfQueryBean qb) throws IOException {
        switch (fdp.getFeatureType()) {
            case POINT: {
                this.pointDataStream(req, res, fdp, path, qb);
                break;
            }
            case STATION: {
                this.stationDataStream(req, res, fdp, path, qb);
            }
        }
    }

    private void pointDataStream(HttpServletRequest req, HttpServletResponse res, FeatureDatasetPoint fdp, String path, CdmrfQueryBean qb) throws IOException {
        List coll = fdp.getPointFeatureCollectionList();
        PointFeatureCollection pfc = (PointFeatureCollection)coll.get(0);
        PointWriter pointWriter = new PointWriter(fdp, pfc, qb, this.cdmrCache);
        if (!pointWriter.validate(res)) {
            return;
        }
        res.setContentType(qb.getResponseType().toString());
        CdmrfQueryBean.ResponseType resType = qb.getResponseType();
        if (resType == CdmrfQueryBean.ResponseType.netcdf) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            path = StringUtil2.replace((String)path, (String)"/", (String)"-");
            res.setHeader("Content-Disposition", "attachment; filename=" + path + ".nc");
            File file = pointWriter.writeNetcdf();
            ServletUtil.returnFile(req, res, file, "application/x-netcdf");
            if (!file.delete()) {
                log.warn("file delete failed =" + file.getPath());
            }
        } else {
            PointWriter.Writer w = pointWriter.write(res);
        }
    }

    private void stationDataStream(HttpServletRequest req, HttpServletResponse res, FeatureDatasetPoint fdp, String path, CdmrfQueryBean qb) throws IOException {
        long start = 0L;
        List coll = fdp.getPointFeatureCollectionList();
        StationTimeSeriesFeatureCollection sfc = (StationTimeSeriesFeatureCollection)coll.get(0);
        StationWriter stationWriter = new StationWriter(fdp, sfc, qb, this.cdmrCache);
        if (!stationWriter.validate(res)) {
            return;
        }
        res.setContentType(qb.getResponseType().toString());
        CdmrfQueryBean.ResponseType resType = qb.getResponseType();
        if (resType == CdmrfQueryBean.ResponseType.netcdf) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            path = StringUtil2.replace((String)path, (String)"/", (String)"-");
            res.setHeader("Content-Disposition", "attachment; filename=" + path + ".nc");
            File file = stationWriter.writeNetcdf();
            ServletUtil.returnFile(req, res, file, "application/x-netcdf");
            if (!file.delete()) {
                log.warn("file delete failed =" + file.getPath());
            }
        }
        StationWriter.Writer w = stationWriter.write(res);
    }
}

