/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.servlet.ServletUtil;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class QueryParams {
    private static Logger log = LoggerFactory.getLogger(QueryParams.class);
    public static final String RAW = "text/plain";
    public static final String XML = "application/xml";
    public static final String HTML = "text/html";
    public static final String CSV = "text/csv";
    public static final String NETCDF = "application/x-netcdf";
    public static final String NETCDFS = "application/x-netcdfs";
    public static final String CdmRemote = "application/x-cdmremote";
    static String[][] validAccept = new String[][]{{"application/xml", "text/xml", "xml"}, {"text/plain", "raw", "ascii"}, {"text/csv", "csv"}, {"text/html", "html"}, {"application/x-netcdf", "netcdf"}, {"application/x-netcdfs", "netcdfStream"}, {"application/x-cdmremote", "cdmRemote"}};
    public String queryString;
    public List<String> accept;
    public String acceptType;
    public boolean wantAllVariables;
    public List<String> vars;
    public boolean hasBB = false;
    public boolean hasStns = false;
    public boolean hasLatlonPoint = false;
    public double north;
    public double south;
    public double east;
    public double west;
    public double lat;
    public double lon;
    public List<String> stns;
    public int horizStride;
    public int vertStride;
    public int timeStride;
    public boolean hasVerticalCoord = false;
    public double vertCoord;
    public boolean hasDateRange = false;
    public boolean hasTimePoint = false;
    public DateType time_start;
    public DateType time_end;
    public DateType time;
    public TimeDuration time_duration;
    public int time_latest;
    public StringBuilder errs = new StringBuilder();
    public boolean fatal;

    public String toString() {
        boolean first;
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("queryString= " + this.queryString + "\n\n");
        sbuff.append("parsed=\n ");
        if (this.hasBB) {
            sbuff.append("bb=" + this.getBB().toString2() + ";");
        } else if (this.hasLatlonPoint) {
            sbuff.append("lat/lon=" + this.getPoint() + ";");
        } else if (this.hasStns) {
            first = true;
            sbuff.append("stns=");
            for (String stnName : this.stns) {
                if (!first) {
                    sbuff.append(",");
                }
                sbuff.append(stnName);
                first = false;
            }
            sbuff.append(";");
        } else {
            sbuff.append("spatial=all;");
        }
        sbuff.append("\n ");
        if (this.hasTimePoint) {
            sbuff.append("time=" + this.time + ";");
        } else if (this.hasDateRange) {
            sbuff.append("timeRange=" + this.getCalendarDateRange() + ";");
        } else {
            sbuff.append("temporal=all;");
        }
        sbuff.append("\n ");
        if (this.wantAllVariables) {
            sbuff.append("vars=all;");
        } else {
            first = true;
            sbuff.append("vars=");
            for (String varName : this.vars) {
                if (!first) {
                    sbuff.append(",");
                }
                sbuff.append(varName);
                first = false;
            }
            sbuff.append(";");
        }
        sbuff.append("\n ");
        return sbuff.toString();
    }

    public boolean parseQuery(HttpServletRequest req, HttpServletResponse res, String[] acceptOK) throws IOException {
        boolean timeNotSpecified;
        String spatial;
        boolean spatialNotSpecified;
        String variables;
        this.queryString = req.getQueryString();
        if (this.queryString == null) {
            this.writeErr(req, res, "Must have a quey string", 400);
            return false;
        }
        this.queryString = URLDecoder.decode(this.queryString, "UTF-8");
        this.accept = this.parseList(req, "accept", validAccept, acceptOK[0]);
        for (String ok : acceptOK) {
            if (!this.accept.contains(ok)) continue;
            this.acceptType = ok;
        }
        if (this.acceptType == null) {
            this.fatal = true;
            this.errs.append("Accept parameter not supported =" + this.accept);
        }
        boolean bl = this.wantAllVariables = (variables = ServletUtil.getParameterIgnoreCase(req, "variables")) != null && variables.equals("all");
        if (!this.wantAllVariables) {
            this.vars = this.parseList(req, "var");
            if (this.vars.isEmpty()) {
                this.vars = null;
                this.wantAllVariables = true;
            }
        }
        boolean bl2 = spatialNotSpecified = (spatial = ServletUtil.getParameterIgnoreCase(req, "spatial")) == null;
        if (spatialNotSpecified || spatial.equalsIgnoreCase("bb")) {
            this.north = this.parseLat(req, "north");
            this.south = this.parseLat(req, "south");
            this.east = this.parseDouble(req, "east");
            this.west = this.parseDouble(req, "west");
            this.hasBB = this.hasValidBB();
        }
        if (!this.hasBB && (spatialNotSpecified || spatial.equalsIgnoreCase("stns"))) {
            this.stns = this.parseList(req, "stn");
            boolean bl3 = this.hasStns = this.stns.size() > 0;
        }
        if (!this.hasBB && !this.hasStns && (spatialNotSpecified || spatial.equalsIgnoreCase("point"))) {
            this.lat = this.parseLat(req, "latitude");
            this.lon = this.parseLon(req, "longitude");
            this.hasLatlonPoint = this.hasValidPoint();
        }
        this.horizStride = this.parseInt(req, "horizStride");
        this.vertStride = this.parseInt(req, "vertStride");
        this.timeStride = this.parseInt(req, "timeStride");
        String temporal = ServletUtil.getParameterIgnoreCase(req, "temporal");
        boolean bl4 = timeNotSpecified = temporal == null;
        if (timeNotSpecified || temporal.equalsIgnoreCase("range")) {
            this.time_start = this.parseDate(req, "time_start");
            this.time_end = this.parseDate(req, "time_end");
            this.time_duration = this.parseW3CDuration(req, "time_duration");
            this.hasDateRange = this.hasValidDateRange();
        }
        if (timeNotSpecified || temporal.equalsIgnoreCase("point")) {
            this.time = this.parseDate(req, "time");
            this.hasTimePoint = this.time != null;
        }
        this.vertCoord = this.parseDouble(req, "vertCoord");
        boolean bl5 = this.hasVerticalCoord = !Double.isNaN(this.vertCoord);
        if (this.fatal) {
            this.writeErr(req, res, this.errs.toString(), 400);
            return false;
        }
        return true;
    }

    public DateType parseDate(HttpServletRequest req, String key) {
        String s = ServletUtil.getParameterIgnoreCase(req, key);
        if (s != null) {
            try {
                return new DateType(s, null, null);
            }
            catch (ParseException e) {
                this.errs.append("Illegal param= '" + key + "=" + s + "' must be valid ISO Date\n");
                this.fatal = true;
            }
        }
        return null;
    }

    public TimeDuration parseW3CDuration(HttpServletRequest req, String key) {
        String s = ServletUtil.getParameterIgnoreCase(req, key);
        if (s != null) {
            try {
                return new TimeDuration(s);
            }
            catch (ParseException e) {
                this.errs.append("Illegal param= '" + key + "=" + s + "' must be valid ISO Duration\n");
                this.fatal = true;
            }
        }
        return null;
    }

    public double parseDouble(HttpServletRequest req, String key) {
        String s = ServletUtil.getParameterIgnoreCase(req, key);
        if (s != null && s.trim().length() > 0) {
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                this.errs.append("Illegal param= '" + key + "=" + s + "' must be valid floating point number\n");
                this.fatal = true;
            }
        }
        return Double.NaN;
    }

    public int parseInt(HttpServletRequest req, String key) {
        String s = ServletUtil.getParameterIgnoreCase(req, key);
        if (s != null && s.trim().length() > 0) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                this.errs.append("Illegal param= '" + key + "=" + s + "' must be valid integer number\n");
                this.fatal = true;
            }
        }
        return 0;
    }

    public double parseLat(HttpServletRequest req, String key) {
        double lat = this.parseDouble(req, key);
        if (!Double.isNaN(lat) && (lat > 90.0 || lat < -90.0)) {
            this.errs.append("Illegal param= '" + key + "=" + lat + "' must be between +/- 90.0\n");
            lat = Double.NaN;
            this.fatal = true;
        }
        return lat;
    }

    public double parseLon(HttpServletRequest req, String key) {
        double lon = this.parseDouble(req, key);
        if (!Double.isNaN(lon)) {
            lon = LatLonPointImpl.lonNormal((double)lon);
        }
        return lon;
    }

    public List<String> parseList(HttpServletRequest req, String key) {
        ArrayList<String> result = new ArrayList<String>();
        String[] vals = ServletUtil.getParameterValuesIgnoreCase(req, key);
        if (vals != null) {
            for (String userVal : vals) {
                if (userVal.contains(",")) {
                    StringTokenizer stoke = new StringTokenizer(userVal, ",");
                    while (stoke.hasMoreTokens()) {
                        String token = stoke.nextToken();
                        result.add(token);
                    }
                    continue;
                }
                result.add(userVal);
            }
        }
        return result;
    }

    public List<String> parseList(HttpServletRequest req, String key, String[][] valids, String defValue) {
        ArrayList<String> result = new ArrayList<String>();
        String[] vals = ServletUtil.getParameterValuesIgnoreCase(req, key);
        if (vals != null) {
            for (String userVal : vals) {
                if (userVal.contains(",")) {
                    StringTokenizer stoke = new StringTokenizer(userVal, ",");
                    while (stoke.hasMoreTokens()) {
                        String token = stoke.nextToken();
                        if (this.findValid(token, valids, result)) continue;
                        this.errs.append("Illegal param '" + key + "=" + token + "'\n");
                    }
                    continue;
                }
                if (this.findValid(userVal, valids, result)) continue;
                this.errs.append("Illegal param= '" + key + "=" + userVal + "'\n");
            }
        }
        if (result.size() == 0 && defValue != null) {
            result.add(defValue);
        }
        return result;
    }

    private boolean findValid(String userVal, String[][] valids, ArrayList<String> result) {
        for (String[] list : valids) {
            String canon = list[0];
            for (String valid : list) {
                if (!userVal.equalsIgnoreCase(valid)) continue;
                result.add(canon);
                return true;
            }
        }
        return false;
    }

    boolean hasValidBB() {
        if (Double.isNaN(this.north) && Double.isNaN(this.south) && Double.isNaN(this.east) && Double.isNaN(this.west)) {
            return false;
        }
        if (Double.isNaN(this.north) || Double.isNaN(this.south) || Double.isNaN(this.east) || Double.isNaN(this.west)) {
            this.errs.append("Bounding Box must have all 4 parameters: north,south,east,west\n");
            this.fatal = true;
            return false;
        }
        if (this.north < this.south) {
            this.errs.append("Bounding Box must have north > south\n");
            this.fatal = true;
            return false;
        }
        if (this.east < this.west) {
            this.errs.append("Bounding Box must have east > west; if crossing 180 meridion, use east boundary > 180\n");
            this.fatal = true;
            return false;
        }
        return true;
    }

    public LatLonRect getBB() {
        return new LatLonRect((LatLonPoint)new LatLonPointImpl(this.south, this.west), (LatLonPoint)new LatLonPointImpl(this.north, this.east));
    }

    LatLonPoint getPoint() {
        return new LatLonPointImpl(this.lat, this.lon);
    }

    boolean hasValidPoint() {
        if (Double.isNaN(this.lat) && Double.isNaN(this.lon)) {
            return false;
        }
        if (Double.isNaN(this.lat) || Double.isNaN(this.lon)) {
            this.errs.append("Missing lat or lon parameter\n");
            this.fatal = true;
            return false;
        }
        return true;
    }

    private boolean hasValidDateRange() {
        if (null == this.time_start && null == this.time_end && null == this.time_duration) {
            return false;
        }
        if (null != this.time_start && null != this.time_end) {
            return true;
        }
        if (null != this.time_start && null != this.time_duration) {
            return true;
        }
        if (null != this.time_end && null != this.time_duration) {
            return true;
        }
        this.errs.append("Must have 2 of 3 parameters: time_start, time_end, time_duration\n");
        return false;
    }

    public CalendarDateRange getCalendarDateRange() {
        return this.hasDateRange ? CalendarDateRange.of((DateRange)new DateRange(this.time_start, this.time_end, this.time_duration, null)) : null;
    }

    public void writeErr(HttpServletRequest req, HttpServletResponse res, String s, int code) throws IOException {
        log.debug("QueryParams bad request = {}", (Object)s);
        res.setStatus(code);
        if (s.length() > 0) {
            PrintWriter pw = res.getWriter();
            pw.print(s);
            pw.print("Request= " + req.getRequestURI() + "?" + req.getQueryString());
            pw.close();
        }
    }
}

