/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset.view.netcdf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.ncSubset.dataservice.StructureDataFactory;
import thredds.server.ncSubset.util.NcssRequestUtils;
import thredds.server.ncSubset.view.netcdf.CFPointWriterWrapper;
import thredds.server.ncSubset.view.netcdf.WriterPointCollectionNoTime;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridAsPointDataset;
import ucar.nc2.time.CalendarDate;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.EarthLocationImpl;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.Station;
import ucar.unidata.geoloc.StationImpl;

class PointCollectionNoTimeWriterWrapper
implements CFPointWriterWrapper {
    private static Logger log = LoggerFactory.getLogger(PointCollectionNoTimeWriterWrapper.class);
    private WriterPointCollectionNoTime writerPointCollectionNoTime;
    private GridAsPointDataset gap;

    private PointCollectionNoTimeWriterWrapper(NetcdfFileWriter.Version version, String filePath, List<Attribute> atts) throws IOException {
        this.writerPointCollectionNoTime = new WriterPointCollectionNoTime(version, filePath, atts);
    }

    @Override
    public boolean header(Map<String, List<String>> groupedVars, GridDataset gds, List<CalendarDate> wDates, List<Attribute> timeDimAtts, LatLonPoint point, Double vertCoord) {
        boolean headerDone = false;
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        atts.add(new Attribute("title", "Extract point data from Grid file " + gds.getLocationURI()));
        NetcdfDataset ncfile = (NetcdfDataset)gds.getNetcdfFile();
        List<String> vars = new ArrayList<List<String>>(groupedVars.values()).get(0);
        this.gap = NcssRequestUtils.buildGridAsPointDataset(gds, vars);
        List<VariableSimpleIF> wantedVars = NcssRequestUtils.wantedVars2VariableSimple(vars, gds, ncfile);
        CoordinateAxis1D zAxis = gds.findGridDatatype(vars.get(0)).getCoordinateSystem().getVerticalAxis();
        String zAxisUnitString = null;
        if (zAxis != null) {
            zAxisUnitString = zAxis.getUnitsString();
        }
        String stnName = "Grid Point";
        String desc = "Grid Point at lat/lon=" + point.getLatitude() + "," + point.getLongitude();
        StationImpl s = new StationImpl(stnName, desc, "", point.getLatitude(), point.getLongitude(), Double.NaN);
        ArrayList<Station> stnList = new ArrayList<Station>();
        stnList.add((Station)s);
        try {
            this.writerPointCollectionNoTime.writeHeader(stnList, wantedVars, zAxisUnitString);
            headerDone = true;
        }
        catch (IOException ioe) {
            log.error("Error writing header", (Throwable)ioe);
        }
        return headerDone;
    }

    @Override
    public boolean write(Map<String, List<String>> groupedVars, GridDataset gridDataset, CalendarDate date, LatLonPoint point, Double targetLevel) {
        boolean allDone = false;
        List<String> vars = new ArrayList<List<String>>(groupedVars.values()).get(0);
        StructureData sdata = StructureDataFactory.getFactory().createSingleStructureData(gridDataset, point, vars, false);
        EarthLocationImpl earthLocation = null;
        Iterator<String> itVars = vars.iterator();
        int cont = 0;
        try {
            while (itVars.hasNext()) {
                String varName = itVars.next();
                GridDatatype grid = gridDataset.findGridDatatype(varName);
                GridAsPointDataset.Point p = this.gap.readData(grid, null, point.getLatitude(), point.getLongitude());
                sdata.findMember(varName).getDataArray().setDouble(0, p.dataValue);
                earthLocation = new EarthLocationImpl(p.lat, p.lon, Double.NaN);
                ++cont;
            }
            this.writerPointCollectionNoTime.writeRecord((EarthLocation)earthLocation, sdata);
            allDone = true;
        }
        catch (IOException ioe) {
            log.error("Error writing data", (Throwable)ioe);
        }
        return allDone;
    }

    @Override
    public boolean trailer() {
        boolean finished = false;
        try {
            this.writerPointCollectionNoTime.finish();
            finished = true;
        }
        catch (IOException ioe) {
            log.error("Error finishing  WriterCFPointCollection" + ioe);
        }
        return finished;
    }

    static PointCollectionNoTimeWriterWrapper createWrapper(NetcdfFileWriter.Version version, String filePath, List<Attribute> atts) throws IOException {
        return new PointCollectionNoTimeWriterWrapper(version, filePath, atts);
    }
}

